/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSOpenPanel;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSTextFieldCell;
import ch.cyberduck.binding.application.NSTextView;
import ch.cyberduck.binding.foundation.NSData;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.DefaultWebUrlProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.browser.DownloadDirectoryFinder;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import ch.cyberduck.ui.cocoa.controller.DefaultBookmarkController;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSSize;

public class ExtendedBookmarkController
extends DefaultBookmarkController {
    private NSButton toggleOptionsButton;
    private NSPopUpButton transferPopup;
    private NSPopUpButton downloadPathPopup;
    private NSOpenPanel downloadFolderOpenPanel;
    private NSTextView commentField;
    private NSPopUpButton connectmodePopup;
    private NSImage favicon;
    private NSTextField webURLField;
    private NSButton webUrlImage;

    public ExtendedBookmarkController(Host bookmark) {
        super(bookmark);
    }

    @Override
    public void awakeFromNib() {
        super.awakeFromNib();
        this.setState(this.toggleOptionsButton, this.preferences.getBoolean("bookmark.toggle.options"));
    }

    @Override
    public void windowWillClose(NSNotification notification) {
        this.preferences.setProperty("bookmark.toggle.options", this.toggleOptionsButton.state());
        super.windowWillClose(notification);
    }

    public void setToggleOptionsButton(NSButton toggleOptionsButton) {
        this.toggleOptionsButton = toggleOptionsButton;
    }

    public void setCommentField(NSTextView field) {
        this.commentField = field;
        this.commentField.setFont(NSFont.userFixedPitchFontOfSize((double)11.0));
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"commentInputDidChange:"), "NSTextDidChangeNotification", field.id());
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                ExtendedBookmarkController.this.updateField(ExtendedBookmarkController.this.commentField, bookmark.getComment());
            }
        });
    }

    public void commentInputDidChange(NSNotification sender) {
        this.bookmark.setComment(this.commentField.textStorage().string());
        this.update();
    }

    public void setConnectmodePopup(NSPopUpButton button) {
        this.connectmodePopup = button;
        this.connectmodePopup.setTarget(this.id());
        this.connectmodePopup.setAction(Foundation.selector((String)"connectmodePopupClicked:"));
        this.connectmodePopup.removeAllItems();
        for (FTPConnectMode m : FTPConnectMode.values()) {
            this.connectmodePopup.addItemWithTitle(m.toString());
            this.connectmodePopup.lastItem().setRepresentedObject(m.name());
            if (!m.equals((Object)FTPConnectMode.unknown)) continue;
            this.connectmodePopup.menu().addItem(NSMenuItem.separatorItem());
        }
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                ExtendedBookmarkController.this.connectmodePopup.setEnabled(bookmark.getProtocol().getType() == Protocol.Type.ftp);
                ExtendedBookmarkController.this.connectmodePopup.selectItemAtIndex(ExtendedBookmarkController.this.connectmodePopup.indexOfItemWithRepresentedObject(bookmark.getFTPConnectMode().name()));
            }
        });
    }

    public void connectmodePopupClicked(NSPopUpButton sender) {
        this.bookmark.setFTPConnectMode(FTPConnectMode.valueOf((String)sender.selectedItem().representedObject()));
        this.update();
    }

    public void setTransferPopup(NSPopUpButton button) {
        this.transferPopup = button;
        this.transferPopup.setTarget(this.id());
        this.transferPopup.setAction(Foundation.selector((String)"transferPopupClicked:"));
        this.transferPopup.removeAllItems();
        Host.TransferType unknown = Host.TransferType.unknown;
        this.transferPopup.addItemWithTitle(unknown.toString());
        this.transferPopup.lastItem().setRepresentedObject(unknown.name());
        this.transferPopup.lastItem().setToolTip(Host.TransferType.valueOf((String)PreferencesFactory.get().getProperty("queue.transfer.type")).toString());
        this.transferPopup.menu().addItem(NSMenuItem.separatorItem());
        for (String name : this.preferences.getList("queue.transfer.type.enabled")) {
            Host.TransferType t = Host.TransferType.valueOf((String)name);
            this.transferPopup.addItemWithTitle(t.toString());
            this.transferPopup.lastItem().setRepresentedObject(t.name());
        }
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                ExtendedBookmarkController.this.transferPopup.selectItemAtIndex(ExtendedBookmarkController.this.transferPopup.indexOfItemWithRepresentedObject(bookmark.getTransferType().name()));
            }
        });
    }

    public void transferPopupClicked(NSPopUpButton sender) {
        this.bookmark.setTransfer(Host.TransferType.valueOf((String)sender.selectedItem().representedObject()));
        this.update();
    }

    public void setDownloadPathPopup(NSPopUpButton button) {
        this.downloadPathPopup = button;
        this.downloadPathPopup.setTarget(this.id());
        this.downloadPathPopup.setAction(Foundation.selector((String)"downloadPathPopupClicked:"));
        this.downloadPathPopup.removeAllItems();
        this.addDownloadPath(new DownloadDirectoryFinder().find(this.bookmark));
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.addDownloadPath(LocalFactory.get((String)this.preferences.getProperty("queue.download.folder")));
        this.addDownloadPath(LocalFactory.get((String)"~/Desktop"));
        this.addDownloadPath(LocalFactory.get((String)"~"));
        this.addDownloadPath(LocalFactory.get((String)"~/Downloads"));
        this.downloadPathPopup.menu().addItem(NSMenuItem.separatorItem());
        this.downloadPathPopup.addItemWithTitle(String.format("%s\u2026", LocaleFactory.localizedString((String)"Choose")));
    }

    private void addDownloadPath(Local f) {
        if (this.downloadPathPopup.menu().itemWithTitle(f.getDisplayName()) == null) {
            this.downloadPathPopup.addItemWithTitle(f.getDisplayName());
            this.downloadPathPopup.lastItem().setImage((NSImage)IconCacheFactory.get().fileIcon(f, Integer.valueOf(16)));
            this.downloadPathPopup.lastItem().setRepresentedObject(f.getAbsolute());
            if (new DownloadDirectoryFinder().find(this.bookmark).equals((Object)f)) {
                this.downloadPathPopup.selectItem(this.downloadPathPopup.lastItem());
            }
        }
    }

    public void downloadPathPopupClicked(NSPopUpButton sender) {
        if (null == sender.selectedItem().representedObject()) {
            this.downloadFolderOpenPanel = NSOpenPanel.openPanel();
            this.downloadFolderOpenPanel.setCanChooseFiles(false);
            this.downloadFolderOpenPanel.setCanChooseDirectories(true);
            this.downloadFolderOpenPanel.setAllowsMultipleSelection(false);
            this.downloadFolderOpenPanel.setCanCreateDirectories(true);
            this.downloadFolderOpenPanel.beginSheetForDirectory(null, null, this.window, this.id(), Foundation.selector((String)"downloadPathPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            Local folder = LocalFactory.get((String)sender.selectedItem().representedObject());
            this.bookmark.setDownloadFolder(folder);
            this.update();
        }
    }

    public void downloadPathPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        switch (returncode) {
            case 1: {
                NSObject selected = sheet.URLs().lastObject();
                if (selected == null) break;
                this.bookmark.setDownloadFolder(LocalFactory.get((String)((NSURL)Rococoa.cast((ObjCObject)selected, NSURL.class)).path()));
            }
        }
        NSMenuItem item = this.downloadPathPopup.itemAtIndex(new NSInteger(0L));
        Local folder = new DownloadDirectoryFinder().find(this.bookmark);
        item.setTitle(folder.getDisplayName());
        item.setRepresentedObject(folder.getAbsolute());
        item.setImage((NSImage)IconCacheFactory.get().fileIcon(folder, Integer.valueOf(16)));
        this.downloadPathPopup.selectItem(item);
        this.downloadFolderOpenPanel = null;
        this.update();
    }

    public void setWebURLField(NSTextField field) {
        this.webURLField = field;
        final NSTextFieldCell cell = this.webURLField.cell();
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"webURLInputDidChange:"), "NSControlTextDidChangeNotification", field.id());
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                ExtendedBookmarkController.this.updateField(ExtendedBookmarkController.this.webURLField, bookmark.getWebURL());
                cell.setPlaceholderString(new DefaultWebUrlProvider().toUrl(bookmark).getUrl());
            }
        });
    }

    public void webURLInputDidChange(NSNotification sender) {
        this.bookmark.setWebURL(this.webURLField.stringValue());
        this.update();
    }

    public void setWebUrlImage(NSButton button) {
        this.webUrlImage = button;
        this.webUrlImage.setTarget(this.id());
        this.webUrlImage.setAction(Foundation.selector((String)"webUrlButtonClicked:"));
        this.webUrlImage.setImage((NSImage)IconCacheFactory.get().iconNamed("site.tiff", Integer.valueOf(16)));
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(final Host bookmark) {
                if (ExtendedBookmarkController.this.preferences.getBoolean("bookmark.favicon.download")) {
                    ExtendedBookmarkController.this.background((BackgroundAction)new AbstractBackgroundAction<Void>(){

                        public Void run() {
                            String f = bookmark.getProtocol().favicon();
                            if (StringUtils.isNotBlank((CharSequence)f)) {
                                ExtendedBookmarkController.this.favicon = (NSImage)IconCacheFactory.get().iconNamed(f, Integer.valueOf(16));
                            } else {
                                String url = String.format("%sfavicon.ico", new DefaultWebUrlProvider().toUrl(bookmark).getUrl());
                                NSData data = NSData.dataWithContentsOfURL((NSURL)NSURL.URLWithString((String)url));
                                if (null == data) {
                                    return null;
                                }
                                ExtendedBookmarkController.this.favicon = NSImage.imageWithData((NSData)data);
                            }
                            if (null != ExtendedBookmarkController.this.favicon) {
                                ExtendedBookmarkController.this.favicon.setSize(new NSSize(16.0, 16.0));
                            }
                            return null;
                        }

                        public void cleanup() {
                            if (null != ExtendedBookmarkController.this.favicon) {
                                ExtendedBookmarkController.this.webUrlImage.setImage(ExtendedBookmarkController.this.favicon);
                            }
                        }
                    });
                }
                ExtendedBookmarkController.this.webUrlImage.setToolTip(new DefaultWebUrlProvider().toUrl(bookmark).getUrl());
            }
        });
    }

    public void webUrlButtonClicked(NSButton sender) {
        BrowserLauncherFactory.get().open(new DefaultWebUrlProvider().toUrl(this.bookmark).getUrl());
    }

    @Override
    public void helpButtonClicked(ID sender) {
        BrowserLauncherFactory.get().open(ProviderHelpServiceFactory.get().help());
    }
}

