/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.FileController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class DuplicateFileController
extends FileController {
    private final Path selected;
    private final Callback callback;

    public DuplicateFileController(Path workdir, Path selected, Cache<Path> cache, Callback callback) {
        super(workdir, selected, cache);
        this.selected = selected;
        this.callback = callback;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(LocaleFactory.localizedString((String)"Duplicate File", (String)"Duplicate"));
        String message = LocaleFactory.localizedString((String)"Enter the name for the new file", (String)"Duplicate");
        alert.setInformativeText(new StringAppender().append(message).toString());
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Duplicate", (String)"Duplicate"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"Duplicate"));
        alert.setIcon((NSImage)IconCacheFactory.get().fileIcon(this.selected, Integer.valueOf(64)));
        super.loadBundle(alert);
    }

    @Override
    public NSView getAccessoryView(NSAlert alert) {
        NSView view = super.getAccessoryView(alert);
        String proposal = MessageFormat.format(PreferencesFactory.get().getProperty("browser.duplicate.format"), FilenameUtils.getBaseName((String)this.selected.getName()), UserDateFormatterFactory.get().getShortFormat(System.currentTimeMillis(), false).replace('/', ':'), StringUtils.isNotBlank((CharSequence)this.selected.getExtension()) ? String.format(".%s", this.selected.getExtension()) : "");
        this.updateField(this.inputField, proposal);
        return view;
    }

    @Override
    public void callback(int returncode, Path file) {
        file.setType(this.selected.getType());
        this.callback.callback(Collections.singletonMap(this.selected, file));
    }

    public static interface Callback {
        public void callback(Map<Path, Path> var1);
    }
}

