/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.worker.DeleteWorker;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.ui.cocoa.controller.ReloadCallback;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;

public class DeleteController
extends ProxyController {
    private final WindowController parent;
    private final SessionPool pool;
    private final boolean trash;

    public DeleteController(WindowController parent, SessionPool pool) {
        this(parent, pool, PreferencesFactory.get().getBoolean("browser.delete.trash"));
    }

    public DeleteController(WindowController parent, SessionPool pool, boolean trash) {
        this.parent = parent;
        this.pool = pool;
        this.trash = trash;
    }

    public void delete(List<Path> selected, final ReloadCallback callback) {
        final List normalized = PathNormalizer.normalize(selected);
        if (normalized.isEmpty()) {
            return;
        }
        StringBuilder alertText = new StringBuilder(MessageFormat.format(LocaleFactory.localizedString((String)"Delete {0} files"), selected.size()));
        Iterator iter = normalized.iterator();
        for (int i = 0; i < 10 && iter.hasNext(); ++i) {
            alertText.append('\n').append('\u2022').append(' ').append(((Path)iter.next()).getName());
        }
        if (iter.hasNext()) {
            alertText.append('\n').append('\u2022').append(' ').append('\u2026');
        }
        NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Delete"), (String)alertText.toString(), (String)LocaleFactory.localizedString((String)"Delete"), (String)LocaleFactory.localizedString((String)"Cancel"), null);
        this.parent.alert(alert, new SheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    DeleteController.this.parent.background((BackgroundAction)new WorkerBackgroundAction((Controller)DeleteController.this.parent, DeleteController.this.pool, (Worker)new DeleteWorker(LoginCallbackFactory.get((Controller)DeleteController.this.parent), normalized, (ProgressListener)DeleteController.this.parent, DeleteController.this.trash){

                        public void cleanup(List<Path> deleted) {
                            callback.done(deleted);
                        }
                    }));
                } else {
                    callback.cancel();
                }
            }
        });
    }
}

