/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSResponder;
import ch.cyberduck.binding.application.NSSecureTextField;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSTokenField;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.CertificateIdentityCallback;
import ch.cyberduck.core.CertificateStoreFactory;
import ch.cyberduck.core.DefaultCharsetProvider;
import ch.cyberduck.core.DisabledCertificateIdentityCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.ui.LoginInputValidator;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;

public class DefaultBookmarkController
extends BookmarkController {
    private static final Logger log = LogManager.getLogger(DefaultBookmarkController.class);
    private static final String TIMEZONE_CONTINENT_PREFIXES = "^(Africa|America|Asia|Atlantic|Australia|Europe|Indian|Pacific)/.*";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private NSTextField nicknameField;
    private NSTokenField labelsField;
    private NSPopUpButton certificatePopup;
    private NSPopUpButton timezonePopup;
    private NSPopUpButton encodingPopup;
    private final KeychainX509KeyManager x509KeyManager;

    public DefaultBookmarkController(Host bookmark) {
        this(bookmark, new LoginOptions(bookmark.getProtocol()));
    }

    public DefaultBookmarkController(Host bookmark, LoginOptions options) {
        super(bookmark, options);
        this.x509KeyManager = new KeychainX509KeyManager((CertificateIdentityCallback)new DisabledCertificateIdentityCallback(), this.bookmark, CertificateStoreFactory.get());
    }

    public DefaultBookmarkController(Host bookmark, LoginInputValidator validator, LoginOptions options) {
        super(bookmark, validator, options);
        this.x509KeyManager = new KeychainX509KeyManager((CertificateIdentityCallback)new DisabledCertificateIdentityCallback(), this.bookmark, CertificateStoreFactory.get());
    }

    @Override
    public void awakeFromNib() {
        super.awakeFromNib();
        this.window.makeFirstResponder((NSResponder)this.hostField);
    }

    public void setNicknameField(NSTextField f) {
        this.nicknameField = f;
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"nicknameFieldDidChange:"), "NSControlTextDidChangeNotification", f.id());
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                DefaultBookmarkController.this.updateField(DefaultBookmarkController.this.nicknameField, BookmarkNameProvider.toString((Host)bookmark));
            }
        });
    }

    public void nicknameFieldDidChange(NSNotification sender) {
        this.bookmark.setNickname(this.nicknameField.stringValue());
        this.update();
    }

    public void setLabelsField(final NSTokenField f) {
        this.labelsField = f;
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"tokenFieldDidChange:"), "NSControlTextDidEndEditingNotification", f.id());
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                if (bookmark.getLabels().isEmpty()) {
                    f.setObjectValue((NSObject)NSArray.array());
                } else {
                    f.setObjectValue((NSObject)NSArray.arrayWithObjects((String[])bookmark.getLabels().toArray(new String[bookmark.getLabels().size()])));
                }
            }
        });
    }

    public void tokenFieldDidChange(NSNotification sender) {
        NSObject next;
        HashSet<String> labels = new HashSet<String>();
        NSArray dict = (NSArray)Rococoa.cast((ObjCObject)this.labelsField.objectValue(), NSArray.class);
        NSEnumerator i = dict.objectEnumerator();
        while (null != (next = i.nextObject())) {
            labels.add(next.toString());
        }
        this.bookmark.setLabels(labels);
        this.update();
    }

    @Override
    public void setPasswordField(NSSecureTextField f) {
        super.setPasswordField(f);
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"passwordFieldTextDidEndEditing:"), "NSControlTextDidEndEditingNotification", f.id());
    }

    public void passwordFieldTextDidEndEditing(NSNotification notification) {
        if (this.options.keychain && this.options.password) {
            if (StringUtils.isBlank((CharSequence)this.bookmark.getHostname())) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)this.bookmark.getCredentials().getUsername())) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)this.passwordField.stringValue())) {
                return;
            }
            try {
                PasswordStoreFactory.get().addPassword(this.bookmark.getProtocol().getScheme(), this.bookmark.getPort(), this.bookmark.getHostname(), this.bookmark.getCredentials().getUsername(), StringUtils.strip((String)this.passwordField.stringValue()));
            }
            catch (LocalAccessDeniedException e) {
                log.error(String.format("Failure saving credentials for %s in keychain. %s", new Object[]{this.bookmark, e}));
            }
        }
    }

    public void setCertificatePopup(NSPopUpButton button) {
        this.certificatePopup = button;
        this.certificatePopup.setTarget(this.id());
        Selector action = Foundation.selector((String)"certificateSelectionChanged:");
        this.certificatePopup.setAction(action);
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                DefaultBookmarkController.this.certificatePopup.setEnabled(DefaultBookmarkController.this.options.certificate);
                DefaultBookmarkController.this.certificatePopup.removeAllItems();
                DefaultBookmarkController.this.certificatePopup.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
                if (DefaultBookmarkController.this.options.certificate) {
                    DefaultBookmarkController.this.certificatePopup.menu().addItem(NSMenuItem.separatorItem());
                    for (String certificate : DefaultBookmarkController.this.x509KeyManager.list()) {
                        DefaultBookmarkController.this.certificatePopup.addItemWithTitle(certificate);
                        DefaultBookmarkController.this.certificatePopup.lastItem().setRepresentedObject(certificate);
                    }
                }
                if (bookmark.getCredentials().isCertificateAuthentication()) {
                    DefaultBookmarkController.this.certificatePopup.selectItemAtIndex(DefaultBookmarkController.this.certificatePopup.indexOfItemWithRepresentedObject(bookmark.getCredentials().getCertificate()));
                } else {
                    DefaultBookmarkController.this.certificatePopup.selectItemWithTitle(LocaleFactory.localizedString((String)"None"));
                }
            }
        });
    }

    public void certificateSelectionChanged(NSPopUpButton sender) {
        this.bookmark.getCredentials().setCertificate(sender.selectedItem().representedObject());
        this.update();
    }

    public void setTimezonePopup(NSPopUpButton button) {
        this.timezonePopup = button;
        this.timezonePopup.setTarget(this.id());
        this.timezonePopup.setAction(Foundation.selector((String)"timezonePopupClicked:"));
        this.timezonePopup.removeAllItems();
        List<String> timezones = Arrays.asList(TimeZone.getAvailableIDs());
        this.timezonePopup.addItemWithTitle(UTC.getID());
        this.timezonePopup.lastItem().setRepresentedObject(UTC.getID());
        this.timezonePopup.menu().addItem(NSMenuItem.separatorItem());
        timezones.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return TimeZone.getTimeZone(o1).getID().compareTo(TimeZone.getTimeZone(o2).getID());
            }
        });
        for (String tz : timezones) {
            if (!tz.matches(TIMEZONE_CONTINENT_PREFIXES)) continue;
            this.timezonePopup.addItemWithTitle(String.format("%s", tz));
            this.timezonePopup.lastItem().setRepresentedObject(tz);
        }
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                DefaultBookmarkController.this.timezonePopup.setEnabled(!bookmark.getProtocol().isUTCTimezone());
                if (null == bookmark.getTimezone()) {
                    if (bookmark.getProtocol().isUTCTimezone()) {
                        DefaultBookmarkController.this.timezonePopup.setTitle(UTC.getID());
                    } else {
                        DefaultBookmarkController.this.timezonePopup.setTitle(TimeZone.getTimeZone(DefaultBookmarkController.this.preferences.getProperty("ftp.timezone.default")).getID());
                    }
                } else {
                    DefaultBookmarkController.this.timezonePopup.setTitle(bookmark.getTimezone().getID());
                }
            }
        });
    }

    public void timezonePopupClicked(NSPopUpButton sender) {
        String[] ids;
        String selected = sender.selectedItem().representedObject();
        for (String id : ids = TimeZone.getAvailableIDs()) {
            TimeZone tz = TimeZone.getTimeZone(id);
            if (!tz.getID().equals(selected)) continue;
            this.bookmark.setTimezone(tz);
            break;
        }
        this.update();
    }

    public void setEncodingPopup(NSPopUpButton button) {
        this.encodingPopup = button;
        this.encodingPopup.setTarget(this.id());
        Selector action = Foundation.selector((String)"encodingSelectionChanged:");
        this.encodingPopup.setAction(action);
        this.encodingPopup.removeAllItems();
        this.encodingPopup.addItemWithTitle(DEFAULT);
        this.encodingPopup.menu().addItem(NSMenuItem.separatorItem());
        for (String encoding : new DefaultCharsetProvider().availableCharsets()) {
            this.encodingPopup.addItemWithTitle(encoding);
            this.encodingPopup.lastItem().setRepresentedObject(encoding);
        }
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                DefaultBookmarkController.this.encodingPopup.setEnabled(bookmark.getProtocol().isEncodingConfigurable());
                if (!bookmark.getProtocol().isEncodingConfigurable()) {
                    DefaultBookmarkController.this.encodingPopup.selectItemWithTitle(DEFAULT);
                } else if (null == bookmark.getEncoding()) {
                    DefaultBookmarkController.this.encodingPopup.selectItemWithTitle(DEFAULT);
                } else {
                    DefaultBookmarkController.this.encodingPopup.selectItemAtIndex(DefaultBookmarkController.this.encodingPopup.indexOfItemWithRepresentedObject(bookmark.getEncoding()));
                }
            }
        });
    }

    public void encodingSelectionChanged(NSPopUpButton sender) {
        if (sender.selectedItem().title().equals(DEFAULT)) {
            this.bookmark.setEncoding(null);
        } else {
            this.bookmark.setEncoding(sender.selectedItem().title());
        }
        this.update();
    }
}

