/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.SessionPoolFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.worker.CopyWorker;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.controller.OverwriteController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class CopyController
extends ProxyController {
    private final Preferences preferences = PreferencesFactory.get();
    private final BrowserController parent;
    private final Cache<Path> cache;

    public CopyController(BrowserController parent) {
        this(parent, parent.getCache());
    }

    public CopyController(BrowserController parent, Cache<Path> cache) {
        this.parent = parent;
        this.cache = cache;
    }

    public void copy(Path path, Path renamed) {
        this.copy(Collections.singletonMap(path, renamed));
    }

    public void copy(final Map<Path, Path> selected) {
        DefaultMainAction action = new DefaultMainAction(){

            public void run() {
                SessionPool pool = CopyController.this.parent.getSession();
                CopyController.this.parent.background((BackgroundAction)new WorkerBackgroundAction((Controller)CopyController.this.parent, CopyController.this.parent.getSession(), (Worker)new CopyWorker(selected, pool.getHost().getProtocol().getStatefulness() == Protocol.Statefulness.stateful ? SessionPoolFactory.create((Controller)CopyController.this.parent, (Host)pool.getHost()) : pool, CopyController.this.cache, (ProgressListener)CopyController.this.parent, (ConnectionCallback)LoginCallbackFactory.get((Controller)CopyController.this.parent)){

                    public void cleanup(Map<Path, Path> result) {
                        ArrayList<Path> changed = new ArrayList<Path>();
                        changed.addAll(result.keySet());
                        changed.addAll(result.values());
                        CopyController.this.parent.reload(CopyController.this.parent.workdir(), changed, new ArrayList<Path>(selected.values()));
                    }
                }));
            }
        };
        this.copy(selected, action);
    }

    private void copy(final Map<Path, Path> selected, final DefaultMainAction action) {
        if (this.preferences.getBoolean("browser.copy.confirm")) {
            StringBuilder alertText = new StringBuilder(LocaleFactory.localizedString((String)"Do you want to copy the selected files?", (String)"Duplicate"));
            Iterator<Map.Entry<Path, Path>> iter = selected.entrySet().iterator();
            for (int i = 0; i < 10 && iter.hasNext(); ++i) {
                Map.Entry<Path, Path> next = iter.next();
                alertText.append(String.format("\n%s %s", Character.toString('\u2022'), next.getKey().getName()));
            }
            if (iter.hasNext()) {
                alertText.append(String.format("\n%s \u2026)", Character.toString('\u2022')));
            }
            final NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Copy", (String)"Transfer"), (String)alertText.toString(), (String)LocaleFactory.localizedString((String)"Copy", (String)"Transfer"), (String)LocaleFactory.localizedString((String)"Cancel"), null);
            alert.setShowsSuppressionButton(true);
            alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't ask again", (String)"Configuration"));
            this.parent.alert(alert, new SheetCallback(){

                public void callback(int returncode) {
                    if (alert.suppressionButton().state() == 1) {
                        CopyController.this.preferences.setProperty("browser.copy.confirm", false);
                    }
                    if (returncode == 1) {
                        new OverwriteController(CopyController.this.parent).overwrite(new ArrayList<Path>(selected.values()), (MainAction)action);
                    }
                }
            });
        } else {
            new OverwriteController(this.parent, this.cache).overwrite(new ArrayList<Path>(selected.values()), (MainAction)action);
        }
    }

    public static interface Callback {
        public void callback(Map<Path, Path> var1);
    }
}

