/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSResponder;
import ch.cyberduck.binding.application.NSSecureTextField;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.ui.LoginInputValidator;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;

public class ConnectionController
extends BookmarkController {
    private NSButton keychainCheckbox;

    public ConnectionController(Host bookmark) {
        this(bookmark, new LoginOptions(bookmark.getProtocol()));
    }

    public ConnectionController(Host bookmark, LoginOptions options) {
        super(bookmark, new LoginInputValidator(bookmark, options), options);
    }

    @Override
    public void awakeFromNib() {
        super.awakeFromNib();
        if (this.options.user) {
            this.window.makeFirstResponder((NSResponder)this.usernameField);
        }
        if (this.options.password && !StringUtils.isBlank((CharSequence)this.bookmark.getCredentials().getUsername())) {
            this.window.makeFirstResponder((NSResponder)this.passwordField);
        }
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    protected String getBundleName() {
        return "Connection";
    }

    @Override
    public void callback(int returncode) {
        if (-1 == returncode) {
            this.bookmark.getCredentials().setPassword(null);
        }
    }

    public void setKeychainCheckbox(final NSButton keychainCheckbox) {
        this.keychainCheckbox = keychainCheckbox;
        this.keychainCheckbox.setTarget(this.id());
        this.keychainCheckbox.setAction(Foundation.selector((String)"keychainCheckboxClicked:"));
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                keychainCheckbox.setEnabled(ConnectionController.this.options.keychain);
                keychainCheckbox.setState(bookmark.getCredentials().isSaved() ? 1 : 0);
            }
        });
    }

    public void keychainCheckboxClicked(NSButton sender) {
        this.bookmark.getCredentials().setSaved(sender.state() == 1);
    }

    @Override
    public void setPasswordField(NSSecureTextField field) {
        super.setPasswordField(field);
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"passwordFieldTextDidChange:"), "NSControlTextDidChangeNotification", field.id());
    }

    public void passwordFieldTextDidChange(NSNotification notification) {
        this.bookmark.getCredentials().setPassword(StringUtils.trim((String)this.passwordField.stringValue()));
    }
}

