/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.Scheme;
import java.security.Key;
import java.security.PublicKey;
import java.text.MessageFormat;
import net.schmizz.sshj.common.KeyType;

public class ChangedHostKeyAlertController
extends AlertController {
    private final String hostname;
    private final String fingerprint;
    private final PublicKey key;

    public ChangedHostKeyAlertController(String hostname, String fingerprint, PublicKey key) {
        this.hostname = hostname;
        this.fingerprint = fingerprint;
        this.key = key;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(0);
        alert.setMessageText(MessageFormat.format(LocaleFactory.localizedString((String)"Changed fingerprint", (String)"Sftp"), this.hostname));
        alert.setInformativeText(MessageFormat.format(LocaleFactory.localizedString((String)"The fingerprint for the {1} key sent by the server is {0}.", (String)"Sftp"), this.fingerprint, KeyType.fromKey((Key)this.key).toString()));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Allow"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Deny"));
        alert.setShowsSuppressionButton(true);
        alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Always"));
        super.loadBundle(alert);
    }

    protected String help() {
        return ProviderHelpServiceFactory.get().help(Scheme.sftp);
    }
}

