/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AbstractTableDelegate;
import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.SheetInvoker;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSCell;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSComboBox;
import ch.cyberduck.binding.application.NSDraggingInfo;
import ch.cyberduck.binding.application.NSEvent;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSImageCell;
import ch.cyberduck.binding.application.NSLayoutManager;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSOpenPanel;
import ch.cyberduck.binding.application.NSOutlineView;
import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSProgressIndicator;
import ch.cyberduck.binding.application.NSResponder;
import ch.cyberduck.binding.application.NSSavePanel;
import ch.cyberduck.binding.application.NSSearchField;
import ch.cyberduck.binding.application.NSSegmentedCell;
import ch.cyberduck.binding.application.NSSegmentedControl;
import ch.cyberduck.binding.application.NSTabView;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.application.NSText;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSTextFieldCell;
import ch.cyberduck.binding.application.NSTitlebarAccessoryViewController;
import ch.cyberduck.binding.application.NSToolbar;
import ch.cyberduck.binding.application.NSToolbarItem;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSData;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSIndexSet;
import ch.cyberduck.binding.foundation.NSMutableArray;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSRange;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.binding.quicklook.QLPreviewPanel;
import ch.cyberduck.binding.quicklook.QLPreviewPanelController;
import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Archive;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.BookmarkSearchFilter;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.NSObjectPathReference;
import ch.cyberduck.core.Navigation;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.PasswordCallbackFactory;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.ReverseLookupCache;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.SessionPoolFactory;
import ch.cyberduck.core.TerminalService;
import ch.cyberduck.core.TerminalServiceFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.bonjour.RendezvousCollection;
import ch.cyberduck.core.editor.DefaultEditorListener;
import ch.cyberduck.core.editor.Editor;
import ch.cyberduck.core.editor.EditorFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Scheduler;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.keychain.SFCertificatePanel;
import ch.cyberduck.core.keychain.SecurityFunctions;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationQuitCallback;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.local.DisabledApplicationQuitCallback;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.local.TemporaryFileService;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.logging.UnifiedSystemLogTranscriptListener;
import ch.cyberduck.core.pasteboard.HostPasteboard;
import ch.cyberduck.core.pasteboard.PathPasteboard;
import ch.cyberduck.core.pasteboard.PathPasteboardFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.serializer.HostDictionary;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BrowserTransferBackgroundAction;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.DisconnectBackgroundAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.QuicklookTransferBackgroundAction;
import ch.cyberduck.core.threading.WindowMainAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.transfer.CopyTransfer;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.SyncTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.UploadTransfer;
import ch.cyberduck.core.vault.LoadingVaultLookupListener;
import ch.cyberduck.core.vault.VaultCredentials;
import ch.cyberduck.core.vault.VaultFactory;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.worker.CopyWorker;
import ch.cyberduck.core.worker.CreateDirectoryWorker;
import ch.cyberduck.core.worker.CreateSymlinkWorker;
import ch.cyberduck.core.worker.CreateVaultWorker;
import ch.cyberduck.core.worker.DownloadShareWorker;
import ch.cyberduck.core.worker.LoadVaultWorker;
import ch.cyberduck.core.worker.LockVaultWorker;
import ch.cyberduck.core.worker.MountWorker;
import ch.cyberduck.core.worker.SearchWorker;
import ch.cyberduck.core.worker.SessionListWorker;
import ch.cyberduck.core.worker.TouchWorker;
import ch.cyberduck.core.worker.UploadShareWorker;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.ui.browser.BookmarkColumn;
import ch.cyberduck.ui.browser.BrowserColumn;
import ch.cyberduck.ui.browser.DownloadDirectoryFinder;
import ch.cyberduck.ui.browser.PathReloadFinder;
import ch.cyberduck.ui.browser.RecursiveSearchFilter;
import ch.cyberduck.ui.browser.SearchFilterFactory;
import ch.cyberduck.ui.browser.UploadDirectoryFinder;
import ch.cyberduck.ui.browser.UploadTargetFinder;
import ch.cyberduck.ui.cocoa.callback.PromptAlertCallback;
import ch.cyberduck.ui.cocoa.callback.PromptLimitedListProgressListener;
import ch.cyberduck.ui.cocoa.controller.AbstractPathTableDelegate;
import ch.cyberduck.ui.cocoa.controller.ArchiveController;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import ch.cyberduck.ui.cocoa.controller.BookmarkControllerFactory;
import ch.cyberduck.ui.cocoa.controller.CommandController;
import ch.cyberduck.ui.cocoa.controller.ConnectionController;
import ch.cyberduck.ui.cocoa.controller.ConnectionControllerFactory;
import ch.cyberduck.ui.cocoa.controller.CreateFileController;
import ch.cyberduck.ui.cocoa.controller.CreateSymlinkController;
import ch.cyberduck.ui.cocoa.controller.DeleteController;
import ch.cyberduck.ui.cocoa.controller.DuplicateFileController;
import ch.cyberduck.ui.cocoa.controller.FolderController;
import ch.cyberduck.ui.cocoa.controller.GotoController;
import ch.cyberduck.ui.cocoa.controller.InfoController;
import ch.cyberduck.ui.cocoa.controller.InfoControllerFactory;
import ch.cyberduck.ui.cocoa.controller.MainController;
import ch.cyberduck.ui.cocoa.controller.MoveController;
import ch.cyberduck.ui.cocoa.controller.OverwriteController;
import ch.cyberduck.ui.cocoa.controller.ReloadCallback;
import ch.cyberduck.ui.cocoa.controller.RestoreController;
import ch.cyberduck.ui.cocoa.controller.RevertController;
import ch.cyberduck.ui.cocoa.controller.TableColumnFactory;
import ch.cyberduck.ui.cocoa.controller.TransferControllerFactory;
import ch.cyberduck.ui.cocoa.controller.VaultController;
import ch.cyberduck.ui.cocoa.datasource.BookmarkTableDataSource;
import ch.cyberduck.ui.cocoa.datasource.BrowserListViewDataSource;
import ch.cyberduck.ui.cocoa.datasource.BrowserOutlineViewDataSource;
import ch.cyberduck.ui.cocoa.datasource.BrowserTableDataSource;
import ch.cyberduck.ui.cocoa.delegate.ArchiveMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.CopyURLMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.EditMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.OpenURLMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.URLMenuDelegate;
import ch.cyberduck.ui.cocoa.toolbar.BrowserToolbarFactory;
import ch.cyberduck.ui.cocoa.toolbar.BrowserToolbarValidator;
import ch.cyberduck.ui.cocoa.view.BookmarkCell;
import ch.cyberduck.ui.cocoa.view.OutlineCell;
import ch.cyberduck.ui.quicklook.QuickLook;
import ch.cyberduck.ui.quicklook.QuickLookFactory;
import com.sun.jna.NativeLong;
import com.sun.jna.PointerType;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public class BrowserController
extends WindowController
implements NSToolbar.Delegate,
NSMenu.Validation,
QLPreviewPanelController {
    private static final Logger log = LogManager.getLogger(BrowserController.class);
    private static NSPoint cascade = new NSPoint(0.0, 0.0);
    private final NSTextFieldCell outlineCellPrototype = OutlineCell.outlineCell();
    private final NSImageCell imageCellPrototype = NSImageCell.imageCell();
    private final NSTextFieldCell textCellPrototype = NSTextFieldCell.textFieldCell();
    private final NSTextFieldCell filenameCellPrototype = NSTextFieldCell.textFieldCell();
    private final TableColumnFactory browserListColumnsFactory = new TableColumnFactory();
    private final TableColumnFactory browserOutlineColumnsFactory = new TableColumnFactory();
    private final TableColumnFactory bookmarkTableColumnFactory = new TableColumnFactory();
    private final NSLayoutManager layoutManager = NSLayoutManager.layoutManager();
    public final BrowserToolbarValidator browserToolbarValidator = new BrowserToolbarValidator(this);
    private final AbstractHostCollection bookmarks = BookmarkCollection.defaultCollection();
    private final BrowserToolbarFactory browserToolbarFactory = new BrowserToolbarFactory(this, this.bookmarks);
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private final QuickLook quicklook = QuickLookFactory.get();
    private final Preferences preferences = PreferencesFactory.get();
    private final Navigation navigation = new Navigation();
    private final TranscriptListener transcript = new UnifiedSystemLogTranscriptListener();
    private final TemporaryFileService temporary = TemporaryFileServiceFactory.instance();
    private SessionPool pool = SessionPool.DISCONNECTED;
    private final Map<Path, Editor> editors = new HashMap<Path, Editor>();
    private Path workdir;
    private boolean showHiddenFiles;
    private Filter<Path> filenameFilter;
    private PathPasteboard pasteboard = PathPasteboard.EMPTY;
    private final ListProgressListener listener = new PromptLimitedListProgressListener(this);
    private final Cache<Path> cache = new ReverseLookupCache((Cache)new PathCache(this.preferences.getInteger("browser.cache.size")), this.preferences.getInteger("browser.cache.size"));
    private Scheduler scheduler;
    protected NSProgressIndicator statusSpinner;
    protected NSProgressIndicator browserSpinner;
    private BrowserOutlineViewDataSource browserOutlineModel;
    private NSOutlineView browserOutlineView;
    private AbstractBrowserTableDelegate browserOutlineViewDelegate;
    private BrowserListViewDataSource browserListModel;
    private NSTableView browserListView;
    private AbstractBrowserTableDelegate browserListViewDelegate;
    private NSToolbar toolbar;
    private NSTitlebarAccessoryViewController accessoryView;
    private NSTabView browserTabView;
    private NSMenu editMenu;
    private EditMenuDelegate editMenuDelegate;
    private NSMenu urlMenu;
    private URLMenuDelegate urlMenuDelegate;
    private NSMenu openUrlMenu;
    private URLMenuDelegate openUrlMenuDelegate;
    private NSMenu archiveMenu;
    private ArchiveMenuDelegate archiveMenuDelegate;
    private NSSegmentedControl bookmarkSwitchView;
    private BookmarkTableDataSource bookmarkModel;
    private NSTableView bookmarkTable;
    private AbstractTableDelegate<Host, BookmarkColumn> bookmarkTableDelegate;
    private NSSearchField searchField;
    private NSButton editBookmarkButton;
    private NSButton addBookmarkButton;
    private NSButton deleteBookmarkButton;
    private NSSegmentedControl navigationButton;
    private NSSegmentedControl upButton;
    private NSPopUpButton pathPopupButton;
    private NSTextField statusLabel;
    private NSButton securityLabel;
    private NSOpenPanel downloadToPanel;
    private NSSavePanel downloadAsPanel;
    private NSOpenPanel syncPanel;
    private NSOpenPanel uploadPanel;
    private NSButton uploadPanelHiddenFilesCheckbox;

    public BrowserController() {
        if (PreferencesFactory.get().getBoolean("browser.showHidden")) {
            this.filenameFilter = SearchFilterFactory.NULL_FILTER;
            this.showHiddenFiles = true;
        } else {
            this.filenameFilter = SearchFilterFactory.HIDDEN_FILTER;
            this.showHiddenFiles = false;
        }
        this.loadBundle();
    }

    public static void updateBookmarkTableRowHeight() {
        for (BrowserController controller : MainController.getBrowsers()) {
            controller._updateBookmarkCell();
        }
    }

    public static void updateBrowserTableAttributes() {
        for (BrowserController controller : MainController.getBrowsers()) {
            controller._updateBrowserAttributes(controller.browserListView);
            controller._updateBrowserAttributes((NSTableView)controller.browserOutlineView);
        }
    }

    public static void updateBrowserTableColumns() {
        for (BrowserController controller : MainController.getBrowsers()) {
            controller._updateBrowserColumns(controller.browserListView, controller.browserListViewDelegate);
            controller._updateBrowserColumns((NSTableView)controller.browserOutlineView, controller.browserOutlineViewDelegate);
        }
    }

    public static NSUInteger applicationShouldTerminate(final NSApplication app) {
        for (final BrowserController controller : MainController.getBrowsers()) {
            if (controller.unmount(new SheetCallback(){

                public void callback(int returncode) {
                    if (returncode == 1) {
                        controller.window().close();
                        if (NSApplication.NSTerminateNow.equals((Object)BrowserController.applicationShouldTerminate(app))) {
                            app.replyToApplicationShouldTerminate(true);
                        }
                    } else {
                        app.replyToApplicationShouldTerminate(false);
                    }
                }
            }, new Runnable(){

                @Override
                public void run() {
                }
            })) continue;
            return NSApplication.NSTerminateCancel;
        }
        return NSApplication.NSTerminateNow;
    }

    protected String getBundleName() {
        return "Browser";
    }

    protected void validateToolbar() {
        this.toolbar.validateVisibleItems();
    }

    public void awakeFromNib() {
        super.awakeFromNib();
        this.toolbar = NSToolbar.toolbarWithIdentifier((String)"Cyberduck Toolbar");
        this.toolbar.setDelegate(this.id());
        this.toolbar.setAllowsUserCustomization(true);
        this.toolbar.setAutosavesConfiguration(true);
        this.window.setToolbar(this.toolbar);
        this._configureBrowserColumns(this.browserListView, this.browserListViewDelegate);
        this._configureBrowserColumns((NSTableView)this.browserOutlineView, this.browserOutlineViewDelegate);
        if (LicenseFactory.find().equals(LicenseFactory.EMPTY_LICENSE)) {
            this.addDonateWindowTitle();
        }
        this.selectBookmarks(BookmarkSwitchSegement.bookmarks);
    }

    public Comparator<Path> getComparator() {
        return this.getSelectedBrowserDelegate().getSortingComparator();
    }

    public Filter<Path> getFilter() {
        return this.filenameFilter;
    }

    protected void setFilter(Filter<Path> filter) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set path filter to %s", filter));
        }
        if (null == filter) {
            this.searchField.setStringValue("");
            this.filenameFilter = SearchFilterFactory.create((boolean)this.showHiddenFiles);
        } else {
            this.filenameFilter = filter;
        }
    }

    public PathPasteboard getPasteboard() {
        return this.pasteboard;
    }

    protected void setShowHiddenFiles(boolean showHidden) {
        if (showHidden) {
            this.filenameFilter = SearchFilterFactory.NULL_FILTER;
            this.showHiddenFiles = true;
        } else {
            this.filenameFilter = SearchFilterFactory.HIDDEN_FILTER;
            this.showHiddenFiles = false;
        }
    }

    private void getFocus() {
        if (this.getSelectedTabView() == BrowserTab.bookmarks) {
            this.window.makeFirstResponder((NSResponder)this.bookmarkTable);
            this.bookmarkTableDelegate.selectionDidChange(NSNotification.notificationWithName((String)"", (ID)this.id()));
        } else if (this.isMounted()) {
            this.window.makeFirstResponder((NSResponder)this.getSelectedBrowserView());
        }
        this.setStatus();
    }

    public void reload() {
        if (this.isMounted()) {
            this.reload(this.workdir, Collections.singleton(this.workdir), this.getSelectedPaths(), false);
        } else {
            NSTableView browser = this.getSelectedBrowserView();
            BrowserTableDataSource model = this.getSelectedBrowserModel();
            model.render(browser, Collections.emptyList());
        }
        this.setStatus();
    }

    public void reload(Path workdir, List<Path> changed, List<Path> selected) {
        this.reload(workdir, new PathReloadFinder().find(changed), selected, true);
    }

    public void reload(Path workdir, Set<Path> folders, List<Path> selected) {
        this.reload(workdir, folders, selected, true);
    }

    public void reload(final Path workdir, Set<Path> folders, final List<Path> selected, boolean invalidate) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Reload data with selected files %s", selected));
        }
        for (Path folder : folders) {
            if (!folder.getName().startsWith(".")) continue;
            this.setShowHiddenFiles(true);
        }
        final BrowserTableDataSource model = this.getSelectedBrowserModel();
        final NSTableView browser = this.getSelectedBrowserView();
        if (folders.isEmpty()) {
            model.render(browser, Collections.emptyList());
        }
        if (null == workdir) {
            this.setNavigation(false);
            model.render(browser, Collections.emptyList());
        } else {
            for (final Path folder : folders) {
                if (invalidate) {
                    this.cache.invalidate((Referenceable)folder);
                } else if (this.cache.isValid((Referenceable)folder)) {
                    this.reload(browser, model, workdir, selected, folder);
                    return;
                }
                this.background((BackgroundAction)new WorkerBackgroundAction((Controller)this, this.pool, (Worker)new SessionListWorker(this.cache, folder, this.listener){

                    public void cleanup(AttributedList<Path> list) {
                        super.cleanup(list);
                        if (AttributedList.emptyList() != list) {
                            BrowserController.this.reload(browser, model, workdir, selected, folder);
                        }
                    }
                }));
            }
        }
    }

    private void reload(NSTableView browser, BrowserTableDataSource model, Path workdir, List<Path> selected, Path folder) {
        this.workdir = workdir;
        this.setNavigation(workdir != null);
        model.render(browser, Collections.singletonList(folder));
        this.setStatus();
        this.select(selected);
    }

    private void select(List<Path> selected) {
        NSTableView browser = this.getSelectedBrowserView();
        if (CollectionUtils.isEqualCollection(this.getSelectedPaths(), selected)) {
            return;
        }
        browser.deselectAll(null);
        for (Path path : selected) {
            this.select(path);
        }
    }

    private void select(Path file) {
        int row;
        NSTableView browser = this.getSelectedBrowserView();
        BrowserTableDataSource model = this.getSelectedBrowserModel();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Select row for reference %s", file));
        }
        if (-1 == (row = model.indexOf(browser, file))) {
            log.warn(String.format("Failed to find row for %s", file));
            return;
        }
        NSInteger index = new NSInteger((long)row);
        browser.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)index), true);
        browser.scrollRowToVisible(index);
    }

    private void updateQuickLookSelection(List<Path> selected) {
        ArrayList<TransferItem> downloads = new ArrayList<TransferItem>();
        for (Path file : selected) {
            if (!file.isFile()) continue;
            downloads.add(new TransferItem(file, this.temporary.create(this.pool.getHost().getUuid(), file)));
        }
        if (downloads.size() > 0) {
            this.background((BackgroundAction)new QuicklookTransferBackgroundAction((Controller)this, this.quicklook, this.pool, downloads));
        }
    }

    private Path getWorkdirFromSelection() {
        Path selected;
        if (this.getSelectionCount() == 1 && null != (selected = this.getSelectedPath())) {
            return selected.getParent();
        }
        return this.workdir;
    }

    public Path getSelectedPath() {
        List<Path> s = this.getSelectedPaths();
        if (s.size() > 0) {
            return s.get(0);
        }
        return null;
    }

    public List<Path> getSelectedPaths() {
        Path file;
        AbstractBrowserTableDelegate delegate = this.getSelectedBrowserDelegate();
        NSTableView view = this.getSelectedBrowserView();
        NSIndexSet iterator = view.selectedRowIndexes();
        ArrayList<Path> selected = new ArrayList<Path>();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound) && null != (file = delegate.pathAtRow(index.intValue()))) {
            selected.add(file);
            index = iterator.indexGreaterThanIndex(index);
        }
        return selected;
    }

    public int getSelectionCount() {
        return this.getSelectedBrowserView().numberOfSelectedRows().intValue();
    }

    public void setWindow(NSWindow window) {
        window.setFrameAutosaveName("Browser");
        if (window.respondsToSelector(Foundation.selector((String)"setSubtitle:"))) {
            window.setSubtitle("");
        }
        window.setTitle(this.preferences.getProperty("application.name"));
        window.setMiniwindowImage((NSImage)IconCacheFactory.get().iconNamed("cyberduck-document.icns"));
        window.setMovableByWindowBackground(true);
        window.setCollectionBehavior(window.collectionBehavior() | 0x80);
        window.setContentMinSize(new NSSize(600.0, 200.0));
        if (window.respondsToSelector(Foundation.selector((String)"setTabbingIdentifier:"))) {
            window.setTabbingIdentifier(this.preferences.getProperty("browser.window.tabbing.identifier"));
        }
        if (window.respondsToSelector(Foundation.selector((String)"setToolbarStyle:"))) {
            window.setToolbarStyle(3);
        }
        if (window.respondsToSelector(Foundation.selector((String)"setTitlebarSeparatorStyle:"))) {
            window.setTitlebarSeparatorStyle(1);
        }
        super.setWindow(window);
        window.registerForDraggedTypes(NSArray.arrayWithObject((String)"Apple files promise pasteboard type"));
        cascade = this.cascade(cascade);
    }

    public void windowWillClose(NSNotification notification) {
        cascade = new NSPoint(this.window().frame().origin.x.doubleValue(), this.window().frame().origin.y.doubleValue() + this.window().frame().size.height.doubleValue());
        super.windowWillClose(notification);
    }

    public NSUInteger draggingEntered(NSDraggingInfo sender) {
        return this.draggingUpdated(sender);
    }

    public NSUInteger draggingUpdated(NSDraggingInfo sender) {
        NSView hit;
        NSPasteboard pasteboard = sender.draggingPasteboard();
        if (pasteboard.types().indexOfObject((NSObject)NSString.stringWithString((String)"Apple files promise pasteboard type")) != null && (hit = sender.draggingDestinationWindow().contentView().hitTest(sender.draggingLocation())) != null && hit.equals(this.bookmarkSwitchView)) {
            return NSDraggingInfo.NSDragOperationCopy;
        }
        return NSDraggingInfo.NSDragOperationNone;
    }

    public boolean prepareForDragOperation(NSDraggingInfo sender) {
        return true;
    }

    public boolean performDragOperation(NSDraggingInfo sender) {
        for (Host bookmark : HostPasteboard.getPasteboard()) {
            Host duplicate = new HostDictionary().deserialize(bookmark.serialize(SerializerFactory.get()));
            duplicate.setUuid(null);
            this.bookmarks.add(0, (Object)duplicate);
        }
        return true;
    }

    public void setDonateButton(NSButton button) {
        button.setTitle(LocaleFactory.localizedString((String)"Get a registration key!", (String)"License"));
        button.setAction(Foundation.selector((String)"donateMenuClicked:"));
        button.sizeToFit();
        NSView view = NSView.create();
        view.setFrameSize(new NSSize(button.frame().size.width.doubleValue() + 10.0, button.frame().size.height.doubleValue()));
        view.addSubview((NSView)button);
        this.accessoryView = NSTitlebarAccessoryViewController.create();
        this.accessoryView.setView(view);
        if (this.accessoryView.respondsToSelector(Foundation.selector((String)"setAutomaticallyAdjustsSize:"))) {
            this.accessoryView.setAutomaticallyAdjustsSize(true);
        }
        this.accessoryView.setLayoutAttribute(NSTitlebarAccessoryViewController.NSLayoutAttributeRight);
    }

    private void addDonateWindowTitle() {
        this.window.addTitlebarAccessoryViewController(this.accessoryView);
    }

    public void removeDonateWindowTitle() {
        this.accessoryView.removeFromParentViewController();
    }

    public BrowserTab getSelectedTabView() {
        return BrowserTab.byPosition(this.browserTabView.indexOfTabViewItem(this.browserTabView.selectedTabViewItem()));
    }

    public void setBrowserTabView(NSTabView browserTabView) {
        this.browserTabView = browserTabView;
    }

    public NSTableView getSelectedBrowserView() {
        switch (BrowserSwitchSegement.byPosition(this.preferences.getInteger("browser.view"))) {
            case list: {
                return this.browserListView;
            }
        }
        return this.browserOutlineView;
    }

    public BrowserTableDataSource getSelectedBrowserModel() {
        switch (BrowserSwitchSegement.byPosition(this.preferences.getInteger("browser.view"))) {
            case list: {
                return this.browserListModel;
            }
        }
        return this.browserOutlineModel;
    }

    public AbstractBrowserTableDelegate getSelectedBrowserDelegate() {
        switch (BrowserSwitchSegement.byPosition(this.preferences.getInteger("browser.view"))) {
            case list: {
                return this.browserListViewDelegate;
            }
        }
        return this.browserOutlineViewDelegate;
    }

    public void setEditMenu(NSMenu editMenu) {
        this.editMenu = editMenu;
        this.editMenuDelegate = new EditMenuDelegate(){

            @Override
            protected Path getEditable() {
                Path selected = BrowserController.this.getSelectedPath();
                if (null == selected) {
                    return null;
                }
                if (BrowserController.this.isEditable(selected)) {
                    return selected;
                }
                return null;
            }

            @Override
            protected ID getTarget() {
                return BrowserController.this.id();
            }
        };
        this.editMenu.setDelegate(this.editMenuDelegate.id());
    }

    public EditMenuDelegate getEditMenuDelegate() {
        return this.editMenuDelegate;
    }

    public void setUrlMenu(NSMenu urlMenu) {
        this.urlMenu = urlMenu;
        this.urlMenuDelegate = new CopyURLMenuDelegate(){

            @Override
            protected SessionPool getSession() {
                return BrowserController.this.pool;
            }

            @Override
            protected List<Path> getSelected() {
                List<Path> s = BrowserController.this.getSelectedPaths();
                if (s.isEmpty() && BrowserController.this.isMounted()) {
                    return Collections.singletonList(BrowserController.this.workdir);
                }
                return s;
            }
        };
        this.urlMenu.setDelegate(this.urlMenuDelegate.id());
    }

    public void setOpenUrlMenu(NSMenu openUrlMenu) {
        this.openUrlMenu = openUrlMenu;
        this.openUrlMenuDelegate = new OpenURLMenuDelegate(){

            @Override
            protected SessionPool getSession() {
                return BrowserController.this.pool;
            }

            @Override
            protected List<Path> getSelected() {
                List<Path> s = BrowserController.this.getSelectedPaths();
                if (s.isEmpty() && BrowserController.this.isMounted()) {
                    return Collections.singletonList(BrowserController.this.workdir);
                }
                return s;
            }
        };
        this.openUrlMenu.setDelegate(this.openUrlMenuDelegate.id());
    }

    public void setArchiveMenu(NSMenu archiveMenu) {
        this.archiveMenu = archiveMenu;
        this.archiveMenuDelegate = new ArchiveMenuDelegate();
        this.archiveMenu.setDelegate(this.archiveMenuDelegate.id());
    }

    public void sortBookmarksByNickame(ID sender) {
        this.bookmarks.sort(BookmarkCollection.SORT_BY_NICKNAME);
        this.reloadBookmarks();
    }

    public void sortBookmarksByHostname(ID sender) {
        this.bookmarks.sort(BookmarkCollection.SORT_BY_HOSTNAME);
        this.reloadBookmarks();
    }

    public void sortBookmarksByProtocol(ID sender) {
        this.bookmarks.sort(BookmarkCollection.SORT_BY_PROTOCOL);
        this.reloadBookmarks();
    }

    public void setBookmarkSwitchView(NSSegmentedControl bookmarkSwitchView) {
        this.bookmarkSwitchView = bookmarkSwitchView;
        this.bookmarkSwitchView.setSegmentCount(4);
        NSSegmentedCell cell = (NSSegmentedCell)Rococoa.cast((ObjCObject)this.bookmarkSwitchView.cell(), NSSegmentedCell.class);
        cell.setToolTip_forSegment(LocaleFactory.localizedString((String)"Browser", (String)"Preferences"), BookmarkSwitchSegement.browser.ordinal());
        this.bookmarkSwitchView.setImage_forSegment(BookmarkSwitchSegement.browser.image(), BookmarkSwitchSegement.browser.ordinal());
        cell.setToolTip_forSegment(LocaleFactory.localizedString((String)"Bookmarks", (String)"Browser"), BookmarkSwitchSegement.bookmarks.ordinal());
        this.bookmarkSwitchView.setImage_forSegment(BookmarkSwitchSegement.bookmarks.image(), BookmarkSwitchSegement.bookmarks.ordinal());
        cell.setToolTip_forSegment(LocaleFactory.localizedString((String)"History"), BookmarkSwitchSegement.history.ordinal());
        this.bookmarkSwitchView.setImage_forSegment(BookmarkSwitchSegement.history.image(), BookmarkSwitchSegement.history.ordinal());
        cell.setToolTip_forSegment(LocaleFactory.localizedString((String)"Bonjour"), BookmarkSwitchSegement.rendezvous.ordinal());
        this.bookmarkSwitchView.setImage_forSegment(BookmarkSwitchSegement.rendezvous.image(), BookmarkSwitchSegement.rendezvous.ordinal());
        this.bookmarkSwitchView.setTarget(this.id());
        this.bookmarkSwitchView.setAction(Foundation.selector((String)"bookmarkSwitchButtonClicked:"));
    }

    public NSSegmentedControl getBookmarkSwitchView() {
        return this.bookmarkSwitchView;
    }

    public void bookmarkSwitchMenuClicked(NSMenuItem sender) {
        switch (this.getSelectedTabView()) {
            case bookmarks: {
                this.selectBrowser(BrowserSwitchSegement.byPosition(this.preferences.getInteger("browser.view")));
                break;
            }
            case list: 
            case outline: {
                this.selectBookmarks(BookmarkSwitchSegement.bookmarks);
            }
        }
    }

    public void bookmarkSwitchButtonClicked(ID sender) {
        BookmarkSwitchSegement selected = BookmarkSwitchSegement.byPosition(this.bookmarkSwitchView.selectedSegment());
        switch (selected) {
            case browser: {
                this.selectBrowser(BrowserSwitchSegement.outline);
                break;
            }
            case bookmarks: 
            case history: 
            case rendezvous: {
                this.selectBookmarks(selected);
            }
        }
    }

    public void browserSwitchButtonClicked(NSSegmentedControl sender) {
        this.selectBrowser(BrowserSwitchSegement.byPosition(sender.selectedSegment()));
    }

    public void browserSwitchMenuClicked(NSMenuItem sender) {
        this.selectBrowser(BrowserSwitchSegement.byPosition(sender.tag()));
    }

    private void selectBrowser(BrowserSwitchSegement selected) {
        this.bookmarkSwitchView.setSelectedSegment(BookmarkSwitchSegement.browser.ordinal());
        this.setNavigation(this.isMounted());
        switch (selected) {
            case list: {
                this.browserTabView.selectTabViewItemAtIndex(BrowserTab.list.ordinal());
                break;
            }
            case outline: {
                this.browserTabView.selectTabViewItemAtIndex(BrowserTab.outline.ordinal());
            }
        }
        this.preferences.setProperty("browser.view", selected.ordinal());
        this.setFilter(null);
        this.reload();
        this.getFocus();
    }

    private void selectBookmarks(BookmarkSwitchSegement selected) {
        HistoryCollection source;
        this.bookmarkSwitchView.setSelectedSegment(selected.ordinal());
        this.setNavigation(false);
        this.browserTabView.selectTabViewItemAtIndex(BrowserTab.bookmarks.ordinal());
        switch (selected) {
            case history: {
                source = HistoryCollection.defaultCollection();
                break;
            }
            case rendezvous: {
                source = RendezvousCollection.defaultCollection();
                break;
            }
            default: {
                source = this.bookmarks;
            }
        }
        if (!source.isLoaded()) {
            this.browserSpinner.startAnimation(null);
            source.addListener((CollectionListener)new AbstractCollectionListener<Host>((AbstractHostCollection)source){
                final /* synthetic */ AbstractHostCollection val$source;
                {
                    this.val$source = abstractHostCollection;
                }

                public void collectionLoaded() {
                    BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                        public void run() {
                            BrowserController.this.browserSpinner.stopAnimation(null);
                            BrowserController.this.bookmarkTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
                        }
                    });
                    this.val$source.removeListener((CollectionListener)this);
                }
            });
        } else {
            this.browserSpinner.stopAnimation(null);
            this.bookmarkTable.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        }
        this.bookmarkModel.setSource((AbstractHostCollection)source);
        this.setBookmarkFilter(null);
        this.reloadBookmarks();
        if (this.isMounted()) {
            int row = this.bookmarkModel.getSource().indexOf((Object)this.pool.getHost());
            if (row != -1) {
                this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)new NSInteger((long)row)), false);
                this.bookmarkTable.scrollRowToVisible(new NSInteger((long)row));
            } else {
                this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)new NSInteger(0L)), false);
                this.bookmarkTable.scrollRowToVisible(new NSInteger(0L));
            }
        } else {
            this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)new NSInteger(0L)), false);
            this.bookmarkTable.scrollRowToVisible(new NSInteger(0L));
        }
        this.getFocus();
    }

    public void reloadBookmarks() {
        this.bookmarkTable.reloadData();
        this.setStatus();
    }

    public boolean acceptsPreviewPanelControl(QLPreviewPanel panel) {
        return true;
    }

    public void beginPreviewPanelControl(QLPreviewPanel panel) {
    }

    public void endPreviewPanelControl(QLPreviewPanel panel) {
    }

    public void setBrowserOutlineView(NSOutlineView view) {
        this.browserOutlineView = view;
        this.browserOutlineView.registerForDraggedTypes(NSArray.arrayWithObjects((String[])new String[]{"Apple URL pasteboard type", "NSFilenamesPboardType", "Apple files promise pasteboard type"}));
        this._updateBrowserAttributes((NSTableView)this.browserOutlineView);
        this.browserOutlineView.setAllowsMultipleSelection(true);
        this.browserOutlineView.setAllowsEmptySelection(true);
        this.browserOutlineView.setAllowsColumnResizing(true);
        this.browserOutlineView.setAllowsColumnSelection(false);
        this.browserOutlineView.setAllowsColumnReordering(true);
        this.browserOutlineView.setRowHeight(new CGFloat((double)(this.layoutManager.defaultLineHeightForFont(NSFont.systemFontOfSize((double)this.preferences.getFloat("browser.font.size"))).intValue() + 2)));
        NSTableColumn c = this.browserOutlineColumnsFactory.create(BrowserColumn.filename.name());
        c.headerCell().setStringValue(LocaleFactory.localizedString((String)"Filename"));
        c.setMinWidth(new CGFloat(100.0));
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.filename.name())));
        c.setMaxWidth(new CGFloat(1000.0));
        c.setResizingMask(3);
        this.outlineCellPrototype.setEditable(true);
        c.setDataCell((NSCell)this.outlineCellPrototype);
        this.browserOutlineView.addTableColumn(c);
        this.browserOutlineView.setOutlineTableColumn(c);
        this.browserOutlineModel = new BrowserOutlineViewDataSource(this, this.cache);
        this.browserOutlineView.setDataSource(this.browserOutlineModel.id());
        this.browserOutlineViewDelegate = new AbstractBrowserOutlineViewDelegate(this.browserOutlineView.tableColumnWithIdentifier(BrowserColumn.filename.name())){

            public void enterKeyPressed(ID sender) {
                if (BrowserController.this.preferences.getBoolean("browser.enterkey.rename")) {
                    if (BrowserController.this.browserOutlineView.numberOfSelectedRows().intValue() == 1 && BrowserController.this.browserOutlineViewDelegate.isColumnRowEditable(NSTableColumn.tableColumnWithIdentifier((String)BrowserColumn.filename.name()), BrowserController.this.browserOutlineView.selectedRow())) {
                        BrowserController.this.renameFileButtonClicked(sender);
                    }
                } else {
                    this.tableRowDoubleClicked(sender);
                }
            }

            public void outlineView_willDisplayCell_forTableColumn_item(NSOutlineView view, NSTextFieldCell cell, NSTableColumn tableColumn, NSObject item) {
                if (null == item) {
                    return;
                }
                Path file = (Path)BrowserController.this.cache.lookup((CacheReference)new NSObjectPathReference(item));
                if (null == file) {
                    return;
                }
                if (tableColumn.identifier().equals(BrowserColumn.filename.name())) {
                    ((OutlineCell)Rococoa.cast((ObjCObject)cell, OutlineCell.class)).setIcon(BrowserController.this.browserOutlineModel.iconForPath(file));
                }
                if (!BrowserController.this.isConnected() || !SearchFilterFactory.HIDDEN_FILTER.accept((Object)file)) {
                    cell.setTextColor(NSColor.disabledControlTextColor());
                } else {
                    cell.setTextColor(NSColor.controlTextColor());
                }
            }

            public boolean outlineView_shouldExpandItem(NSOutlineView view, NSObject item) {
                NSEvent event = NSApplication.sharedApplication().currentEvent();
                if (event != null && 6 == event.type()) {
                    if (!BrowserController.this.preferences.getBoolean("browser.view.autoexpand")) {
                        if (log.isDebugEnabled()) {
                            log.debug("Returning false to #outlineViewShouldExpandItem while dragging because browser.view.autoexpand == false");
                        }
                        return false;
                    }
                    NSInteger draggingColumn = view.columnAtPoint(view.convertPoint_fromView(event.locationInWindow(), null));
                    if (draggingColumn.intValue() != 0) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Returning false to #outlineViewShouldExpandItem for column %s", draggingColumn));
                        }
                        return false;
                    }
                }
                return true;
            }

            public boolean outlineView_isGroupItem(NSOutlineView view, NSObject item) {
                return false;
            }

            public void outlineViewItemWillExpand(NSNotification notification) {
                NSObject object = ((NSDictionary)Rococoa.cast((ObjCObject)notification.userInfo(), NSDictionary.class)).objectForKey("NSObject");
                NSObjectPathReference reference = new NSObjectPathReference(object);
                Path directory = (Path)BrowserController.this.cache.lookup((CacheReference)reference);
                if (null == directory) {
                    return;
                }
                BrowserController.this.reload(BrowserController.this.workdir, Collections.singleton(directory), BrowserController.this.getSelectedPaths(), false);
            }

            public void outlineViewItemDidExpand(NSNotification notification) {
                BrowserController.this.setStatus();
            }

            public void outlineViewItemWillCollapse(NSNotification notification) {
            }

            public void outlineViewItemDidCollapse(NSNotification notification) {
                BrowserController.this.setStatus();
            }

            protected boolean isTypeSelectSupported() {
                return true;
            }
        };
        this.browserOutlineView.setDelegate(this.browserOutlineViewDelegate.id());
    }

    public void setBrowserListView(NSTableView view) {
        this.browserListView = view;
        this.browserListView.registerForDraggedTypes(NSArray.arrayWithObjects((String[])new String[]{"Apple URL pasteboard type", "NSFilenamesPboardType", "Apple files promise pasteboard type"}));
        this._updateBrowserAttributes(this.browserListView);
        this.browserListView.setAllowsMultipleSelection(true);
        this.browserListView.setAllowsEmptySelection(true);
        this.browserListView.setAllowsColumnResizing(true);
        this.browserListView.setAllowsColumnSelection(false);
        this.browserListView.setAllowsColumnReordering(true);
        this.browserListView.setRowHeight(new CGFloat((double)(this.layoutManager.defaultLineHeightForFont(NSFont.systemFontOfSize((double)this.preferences.getFloat("browser.font.size"))).intValue() + 2)));
        NSTableColumn c = this.browserListColumnsFactory.create(BrowserColumn.icon.name());
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.icon.name())));
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setDataCell((NSCell)this.imageCellPrototype);
        c.dataCell().setAlignment(TEXT_ALIGNMENT_CENTER);
        this.browserListView.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.filename.name());
        c.headerCell().setStringValue(BrowserColumn.filename.toString());
        c.setMinWidth(100.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.filename.name())));
        c.setMaxWidth(1000.0);
        c.setResizingMask(3);
        this.filenameCellPrototype.setEditable(true);
        c.setDataCell((NSCell)this.filenameCellPrototype);
        this.browserListView.addTableColumn(c);
        this.browserListModel = new BrowserListViewDataSource(this, this.cache);
        this.browserListView.setDataSource(this.browserListModel.id());
        this.browserListViewDelegate = new AbstractBrowserListViewDelegate<Path>(this.browserListView.tableColumnWithIdentifier(BrowserColumn.filename.name())){

            public void enterKeyPressed(ID sender) {
                if (BrowserController.this.preferences.getBoolean("browser.enterkey.rename")) {
                    if (BrowserController.this.browserListView.numberOfSelectedRows().intValue() == 1 && BrowserController.this.browserListViewDelegate.isColumnRowEditable(NSTableColumn.tableColumnWithIdentifier((String)BrowserColumn.filename.name()), BrowserController.this.browserListView.selectedRow())) {
                        BrowserController.this.renameFileButtonClicked(sender);
                    }
                } else {
                    this.tableRowDoubleClicked(sender);
                }
            }

            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSTextFieldCell cell, NSTableColumn tableColumn, NSInteger row) {
                Path file = (Path)BrowserController.this.browserListModel.get(BrowserController.this.workdir).get(row.intValue());
                if (cell.isKindOfClass(Foundation.getClass((String)NSTextFieldCell.class.getSimpleName()))) {
                    if (!BrowserController.this.isConnected() || !SearchFilterFactory.HIDDEN_FILTER.accept((Object)file)) {
                        cell.setTextColor(NSColor.disabledControlTextColor());
                    } else {
                        cell.setTextColor(NSColor.controlTextColor());
                    }
                }
            }

            protected boolean isTypeSelectSupported() {
                return true;
            }
        };
        this.browserListView.setDelegate(this.browserListViewDelegate.id());
    }

    public void tableHeaderMenuItemClicked(NSMenuItem sender) {
        boolean enabled = !this.preferences.getBoolean(String.format("browser.column.%s", sender.representedObject()));
        sender.setState(enabled ? 1 : 0);
        this.preferences.setProperty(String.format("browser.column.%s", sender.representedObject()), enabled);
        BrowserController.updateBrowserTableColumns();
    }

    protected void _updateBrowserAttributes(NSTableView tableView) {
        tableView.setUsesAlternatingRowBackgroundColors(this.preferences.getBoolean("browser.alternatingRows"));
        if (this.preferences.getBoolean("browser.horizontalLines") && this.preferences.getBoolean("browser.verticalLines")) {
            tableView.setGridStyleMask(new NSUInteger((long)(NSTableView.NSTableViewSolidHorizontalGridLineMask.intValue() | NSTableView.NSTableViewSolidVerticalGridLineMask.intValue())));
        } else if (this.preferences.getBoolean("browser.verticalLines")) {
            tableView.setGridStyleMask(NSTableView.NSTableViewSolidVerticalGridLineMask);
        } else if (this.preferences.getBoolean("browser.horizontalLines")) {
            tableView.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        } else {
            tableView.setGridStyleMask(NSTableView.NSTableViewGridNone);
        }
    }

    protected void _updateBookmarkCell() {
        int size = this.preferences.getInteger("bookmark.icon.size");
        double width = (double)size * 1.5;
        NSTableColumn c = this.bookmarkTable.tableColumnWithIdentifier(BookmarkColumn.icon.name());
        c.setMinWidth(width);
        c.setMaxWidth(width);
        c.setWidth(width);
        this.bookmarkTable.noteHeightOfRowsWithIndexesChanged(NSIndexSet.indexSetWithIndexesInRange((NSRange)NSRange.NSMakeRange((NSUInteger)new NSUInteger(0L), (NSUInteger)new NSUInteger((NativeLong)this.bookmarkTable.numberOfRows()))));
    }

    private void _updateBrowserColumns(NSTableView table, AbstractBrowserTableDelegate delegate) {
        NSObject next;
        NSEnumerator tableColumns = table.tableColumns().objectEnumerator();
        while ((next = tableColumns.nextObject()) != null) {
            NSTableColumn c = (NSTableColumn)Rococoa.cast((ObjCObject)next, NSTableColumn.class);
            c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", c.identifier())));
        }
    }

    private void _configureBrowserColumns(NSTableView table, AbstractBrowserTableDelegate delegate) {
        NSTableColumn c = this.browserListColumnsFactory.create(BrowserColumn.size.name());
        c.headerCell().setStringValue(BrowserColumn.size.toString());
        c.setMinWidth(50.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.size.name())));
        c.setMaxWidth(150.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.size.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.modified.name());
        c.headerCell().setStringValue(BrowserColumn.modified.toString());
        c.setMinWidth(100.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.modified.name())));
        c.setMaxWidth(500.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.modified.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.owner.name());
        c.headerCell().setStringValue(BrowserColumn.owner.toString());
        c.setMinWidth(50.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.owner.name())));
        c.setMaxWidth(500.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.owner.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.group.name());
        c.headerCell().setStringValue(BrowserColumn.group.toString());
        c.setMinWidth(50.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.group.name())));
        c.setMaxWidth(500.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.group.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.permission.name());
        c.headerCell().setStringValue(BrowserColumn.permission.toString());
        c.setMinWidth(100.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.permission.name())));
        c.setMaxWidth(800.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.permission.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.kind.name());
        c.headerCell().setStringValue(BrowserColumn.kind.toString());
        c.setMinWidth(50.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.kind.name())));
        c.setMaxWidth(500.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.kind.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.extension.name());
        c.headerCell().setStringValue(BrowserColumn.extension.toString());
        c.setMinWidth(50.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.extension.name())));
        c.setMaxWidth(500.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.extension.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.region.name());
        c.headerCell().setStringValue(BrowserColumn.region.toString());
        c.setMinWidth(50.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.region.name())));
        c.setMaxWidth(500.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.region.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.version.name());
        c.headerCell().setStringValue(BrowserColumn.version.toString());
        c.setMinWidth(50.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.version.name())));
        c.setMaxWidth(500.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.version.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.checksum.name());
        c.headerCell().setStringValue(BrowserColumn.checksum.toString());
        c.setMinWidth(50.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.checksum.name())));
        c.setMaxWidth(500.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.checksum.name())));
        table.addTableColumn(c);
        c = this.browserListColumnsFactory.create(BrowserColumn.storageclass.name());
        c.headerCell().setStringValue(BrowserColumn.storageclass.toString());
        c.setMinWidth(50.0);
        c.setWidth((double)this.preferences.getFloat(String.format("browser.column.%s.width", BrowserColumn.storageclass.name())));
        c.setMaxWidth(500.0);
        c.setResizingMask(3);
        c.setDataCell((NSCell)this.textCellPrototype);
        c.setHidden(!this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.storageclass.name())));
        table.addTableColumn(c);
        NSTableColumn selected = table.tableColumnWithIdentifier(this.preferences.getProperty("browser.sort.column"));
        if (null == selected) {
            selected = table.tableColumnWithIdentifier(BrowserColumn.filename.name());
        }
        delegate.setSelectedColumn(selected);
        table.setIndicatorImage_inTableColumn(this.getSelectedBrowserDelegate().isSortedAscending() ? (NSImage)IconCacheFactory.get().iconNamed("NSAscendingSortIndicator") : (NSImage)IconCacheFactory.get().iconNamed("NSDescendingSortIndicator"), selected);
        table.sizeToFit();
        NSMenu headerMenu = NSMenu.menu();
        for (BrowserColumn column : BrowserColumn.values()) {
            if (BrowserColumn.icon.equals((Object)column)) continue;
            NSMenuItem item = NSMenuItem.itemWithTitle((String)column.toString(), (Selector)Foundation.selector((String)"tableHeaderMenuItemClicked:"), (String)"");
            item.setRepresentedObject(column.name());
            item.setTarget(this.id());
            item.setEnabled(!BrowserColumn.filename.equals((Object)column));
            item.setState(this.preferences.getBoolean(String.format("browser.column.%s", column.name())) ? 1 : 0);
            headerMenu.addItem(item);
        }
        table.headerView().setMenu(headerMenu);
        this.reload();
    }

    public NSTableView getBookmarkTable() {
        return this.bookmarkTable;
    }

    public void setBookmarkTable(NSTableView view) {
        this.bookmarkTable = view;
        this.bookmarkTable.setSelectionHighlightStyle(NSTableView.NSTableViewSelectionHighlightStyleSourceList);
        this.bookmarkModel = new BookmarkTableDataSource(this);
        this.bookmarkTable.setDataSource(this.bookmarkModel.id());
        NSTableColumn c = this.bookmarkTableColumnFactory.create(BookmarkColumn.icon.name());
        c.headerCell().setStringValue("");
        c.setResizingMask(0);
        c.setDataCell((NSCell)this.imageCellPrototype);
        this.bookmarkTable.addTableColumn(c);
        c = this.bookmarkTableColumnFactory.create(BookmarkColumn.bookmark.name());
        c.headerCell().setStringValue(LocaleFactory.localizedString((String)"Bookmarks", (String)"Browser"));
        c.setMinWidth(150.0);
        c.setResizingMask(1);
        c.setDataCell((NSCell)BookmarkCell.bookmarkCell());
        this.bookmarkTable.addTableColumn(c);
        c = this.bookmarkTableColumnFactory.create(BookmarkColumn.status.name());
        c.headerCell().setStringValue("");
        c.setMinWidth(40.0);
        c.setWidth(40.0);
        c.setMaxWidth(40.0);
        c.setResizingMask(1);
        c.setDataCell((NSCell)this.imageCellPrototype);
        c.dataCell().setAlignment(TEXT_ALIGNMENT_CENTER);
        this.bookmarkTable.addTableColumn(c);
        this.bookmarkTableDelegate = new AbstractTableDelegate<Host, BookmarkColumn>(this.bookmarkTable.tableColumnWithIdentifier(BookmarkColumn.bookmark.name())){
            private static final double kSwipeGestureLeft = 1.0;
            private static final double kSwipeGestureRight = -1.0;
            private static final double kSwipeGestureUp = 1.0;
            private static final double kSwipeGestureDown = -1.0;

            public String tooltip(Host bookmark, BookmarkColumn column) {
                return new HostUrlProvider().get(bookmark);
            }

            public void tableRowDoubleClicked(ID sender) {
                BrowserController.this.connectBookmarkButtonClicked(sender);
            }

            public void enterKeyPressed(ID sender) {
                this.tableRowDoubleClicked(sender);
            }

            public void deleteKeyPressed(ID sender) {
                if (BrowserController.this.bookmarkModel.getSource().allowsDelete()) {
                    BrowserController.this.deleteBookmarkButtonClicked(sender);
                }
            }

            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            public void selectionDidChange(NSNotification notification) {
                BrowserController.this.addBookmarkButton.setEnabled(BrowserController.this.bookmarkModel.getSource().allowsAdd());
                int selected = BrowserController.this.bookmarkTable.numberOfSelectedRows().intValue();
                BrowserController.this.editBookmarkButton.setEnabled(BrowserController.this.bookmarkModel.getSource().allowsEdit() && selected == 1);
                BrowserController.this.deleteBookmarkButton.setEnabled(BrowserController.this.bookmarkModel.getSource().allowsDelete() && selected > 0);
            }

            public CGFloat tableView_heightOfRow(NSTableView view, NSInteger row) {
                int size = BrowserController.this.preferences.getInteger("bookmark.icon.size");
                if (16 == size) {
                    return new CGFloat(18.0);
                }
                if (32 == size) {
                    return new CGFloat(45.0);
                }
                return new CGFloat(70.0);
            }

            public boolean isTypeSelectSupported() {
                return true;
            }

            public String tableView_typeSelectStringForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                return BookmarkNameProvider.toString((Host)((Host)BrowserController.this.bookmarkModel.getSource().get(row.intValue())));
            }

            public boolean tableView_isGroupRow(NSTableView view, NSInteger row) {
                return false;
            }

            public void swipeWithEvent(NSEvent event) {
                if (event.deltaY().doubleValue() == 1.0) {
                    NSInteger row = BrowserController.this.bookmarkTable.selectedRow();
                    NSInteger next = -1 == row.intValue() ? new NSInteger(0L) : new NSInteger(row.longValue() - 1L);
                    BrowserController.this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)next), false);
                } else if (event.deltaY().doubleValue() == -1.0) {
                    NSInteger row = BrowserController.this.bookmarkTable.selectedRow();
                    NSInteger next = -1 == row.intValue() ? new NSInteger(0L) : new NSInteger(row.longValue() + 1L);
                    BrowserController.this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)next), false);
                }
            }
        };
        this.bookmarkTable.setDelegate(this.bookmarkTableDelegate.id());
        this.bookmarkTable.registerForDraggedTypes(NSArray.arrayWithObjects((String[])new String[]{"Apple URL pasteboard type", "NSStringPboardType", "NSFilenamesPboardType", "Apple files promise pasteboard type"}));
        this._updateBookmarkCell();
        int size = this.preferences.getInteger("bookmark.icon.size");
        if (16 == size) {
            this.bookmarkTable.setRowHeight(new CGFloat(18.0));
        } else if (32 == size) {
            this.bookmarkTable.setRowHeight(new CGFloat(45.0));
        } else {
            this.bookmarkTable.setRowHeight(new CGFloat(70.0));
        }
        this.bookmarkTable.setUsesAlternatingRowBackgroundColors(this.preferences.getBoolean("browser.alternatingRows"));
        this.bookmarkTable.setGridStyleMask(NSTableView.NSTableViewGridNone);
        this.bookmarkTable.setAllowsMultipleSelection(true);
        this.bookmarkTable.setAllowsEmptySelection(true);
        this.bookmarkTable.setAllowsColumnResizing(false);
        this.bookmarkTable.setAllowsColumnSelection(false);
        this.bookmarkTable.setAllowsColumnReordering(false);
        this.bookmarkTable.sizeToFit();
    }

    public BookmarkTableDataSource getBookmarkModel() {
        return this.bookmarkModel;
    }

    public void quickConnectSelectionChanged(NSComboBox sender) {
        String input = StringUtils.trim((String)sender.stringValue());
        if (StringUtils.isBlank((CharSequence)input)) {
            return;
        }
        for (Host h : this.bookmarks) {
            if (!BookmarkNameProvider.toString((Host)h).equals(input)) continue;
            this.mount(h);
            return;
        }
        try {
            this.mount(HostParser.parse((String)input));
        }
        catch (HostParserException e) {
            log.warn((Object)e);
        }
    }

    public NSSearchField getSearchField() {
        return this.searchField;
    }

    public void setSearchField(NSSearchField searchField) {
        this.searchField = searchField;
        if (this.searchField.respondsToSelector(Foundation.selector((String)"setSendsWholeSearchString:"))) {
            this.searchField.setSendsWholeSearchString(false);
        }
        if (this.searchField.respondsToSelector(Foundation.selector((String)"setSendsSearchStringImmediately:"))) {
            this.searchField.setSendsSearchStringImmediately(false);
        }
        this.searchField.setTarget(this.id());
        this.searchField.setAction(Foundation.selector((String)"searchFieldTextDidChange:"));
        this.searchField.cell().setSendsActionOnEndEditing(false);
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"searchFieldTextDidEndEditing:"), "NSControlTextDidEndEditingNotification", this.searchField.id());
    }

    public void searchButtonClicked(ID sender) {
        this.window().makeFirstResponder((NSResponder)this.searchField);
    }

    public void searchFieldTextDidChange(NSNotification notification) {
        String input = this.searchField.stringValue();
        switch (this.getSelectedTabView()) {
            case bookmarks: {
                this.setBookmarkFilter(input);
                break;
            }
            case list: 
            case outline: {
                this.setFilter((Filter<Path>)SearchFilterFactory.create((String)input, (boolean)this.showHiddenFiles));
                this.reload();
            }
        }
    }

    public void searchFieldTextDidEndEditing(NSNotification notification) {
        switch (this.getSelectedTabView()) {
            case list: 
            case outline: {
                String input = this.searchField.stringValue();
                if (StringUtils.isBlank((CharSequence)input)) {
                    this.setFilter((Filter<Path>)SearchFilterFactory.create((boolean)this.showHiddenFiles));
                    this.reload();
                    break;
                }
                NSObject action = notification.userInfo().objectForKey("NSTextMovement");
                if (null == action) {
                    return;
                }
                switch (Integer.parseInt(action.toString())) {
                    case 16: {
                        NSAlert alert = NSAlert.alert((String)MessageFormat.format(LocaleFactory.localizedString((String)"Search for {0}"), input), (String)MessageFormat.format(LocaleFactory.localizedString((String)"Do you want to search in {0} recursively?"), this.workdir.getName()), (String)LocaleFactory.localizedString((String)"Search"), (String)LocaleFactory.localizedString((String)"Cancel"), null);
                        this.alert(alert, new SheetCallback(){

                            public void callback(int returncode) {
                                if (returncode == 1) {
                                    BrowserController.this.background((BackgroundAction)new WorkerBackgroundAction((Controller)BrowserController.this, BrowserController.this.pool, (Worker)new SearchWorker(BrowserController.this.workdir, BrowserController.this.filenameFilter, BrowserController.this.cache, BrowserController.this.listener){

                                        public void cleanup(AttributedList<Path> list) {
                                            super.cleanup(list);
                                            BrowserController.this.setFilter((Filter<Path>)new RecursiveSearchFilter(list));
                                            BrowserController.this.reload();
                                        }
                                    }));
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private void setBookmarkFilter(String searchString) {
        if (StringUtils.isBlank((CharSequence)searchString)) {
            this.searchField.setStringValue("");
            this.bookmarkModel.setFilter(null);
        } else {
            this.bookmarkModel.setFilter((HostFilter)new BookmarkSearchFilter(searchString));
        }
        this.reloadBookmarks();
    }

    public void connectBookmarkButtonClicked(ID sender) {
        if (this.bookmarkTable.numberOfSelectedRows().intValue() == 1) {
            Host selected = (Host)this.bookmarkModel.getSource().get(this.bookmarkTable.selectedRow().intValue());
            this.mount(selected);
        }
    }

    public void setEditBookmarkButton(NSButton editBookmarkButton) {
        this.editBookmarkButton = editBookmarkButton;
        this.editBookmarkButton.setEnabled(false);
        this.editBookmarkButton.setTarget(this.id());
        this.editBookmarkButton.setAction(Foundation.selector((String)"editBookmarkButtonClicked:"));
        this.editBookmarkButton.image().setTemplate(true);
    }

    public void editBookmarkButtonClicked(ID sender) {
        BookmarkController c = BookmarkControllerFactory.create(this.bookmarks, (Host)this.bookmarkModel.getSource().get(this.bookmarkTable.selectedRow().intValue()));
        c.window().makeKeyAndOrderFront(null);
    }

    public void duplicateBookmarkButtonClicked(ID sender) {
        Host selected = (Host)this.bookmarkModel.getSource().get(this.bookmarkTable.selectedRow().intValue());
        this.selectBookmarks(BookmarkSwitchSegement.bookmarks);
        Host duplicate = new HostDictionary().deserialize(selected.serialize(SerializerFactory.get()));
        duplicate.setUuid(null);
        this.addBookmark(duplicate);
    }

    public void setAddBookmarkButton(NSButton addBookmarkButton) {
        this.addBookmarkButton = addBookmarkButton;
        this.addBookmarkButton.setTarget(this.id());
        this.addBookmarkButton.setAction(Foundation.selector((String)"addBookmarkButtonClicked:"));
        this.addBookmarkButton.image().setTemplate(true);
    }

    public void addBookmarkButtonClicked(ID sender) {
        Host bookmark;
        if (this.isMounted()) {
            Path selected = this.getSelectedPath();
            if (null == selected || !selected.isDirectory()) {
                selected = this.workdir;
            }
            bookmark = new HostDictionary().deserialize(this.pool.getHost().serialize(SerializerFactory.get()));
            bookmark.setUuid(null);
            bookmark.setDefaultPath(selected.getAbsolute());
        } else {
            bookmark = new Host(ProtocolFactory.get().forName(this.preferences.getProperty("connection.protocol.default")));
        }
        this.selectBookmarks(BookmarkSwitchSegement.bookmarks);
        this.addBookmark(bookmark);
    }

    public void addBookmark(Host item) {
        this.bookmarkModel.setFilter(null);
        this.bookmarkModel.getSource().add((Object)item);
        int row = this.bookmarkModel.getSource().lastIndexOf((Object)item);
        NSInteger index = new NSInteger((long)row);
        this.bookmarkTable.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)index), false);
        this.bookmarkTable.scrollRowToVisible(index);
        BookmarkController c = BookmarkControllerFactory.create(this.bookmarks, item);
        c.window().makeKeyAndOrderFront(null);
    }

    public void setDeleteBookmarkButton(NSButton deleteBookmarkButton) {
        this.deleteBookmarkButton = deleteBookmarkButton;
        this.deleteBookmarkButton.setEnabled(false);
        this.deleteBookmarkButton.setTarget(this.id());
        this.deleteBookmarkButton.setAction(Foundation.selector((String)"deleteBookmarkButtonClicked:"));
        this.deleteBookmarkButton.image().setTemplate(true);
    }

    public void deleteBookmarkButtonClicked(ID sender) {
        NSIndexSet iterator = this.bookmarkTable.selectedRowIndexes();
        final ArrayList<Host> selected = new ArrayList<Host>();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            selected.add((Host)this.bookmarkModel.getSource().get(index.intValue()));
            index = iterator.indexGreaterThanIndex(index);
        }
        StringBuilder alertText = new StringBuilder(LocaleFactory.localizedString((String)"Do you want to delete the selected bookmark?"));
        Iterator iter = selected.iterator();
        for (int i = 0; i < 10 && iter.hasNext(); ++i) {
            alertText.append('\n').append('\u2022').append(' ').append(BookmarkNameProvider.toString((Host)((Host)iter.next())));
        }
        if (iter.hasNext()) {
            alertText.append('\n').append('\u2022').append(' ').append('\u2026');
        }
        NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Delete Bookmark"), (String)alertText.toString(), (String)LocaleFactory.localizedString((String)"Delete"), (String)LocaleFactory.localizedString((String)"Cancel"), null);
        this.alert(alert, new SheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    BrowserController.this.bookmarkTable.deselectAll(null);
                    BrowserController.this.bookmarkModel.getSource().removeAll((Collection)selected);
                }
            }
        });
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    private void setNavigation(boolean enabled) {
        if (!enabled) {
            this.searchField.setStringValue("");
        }
        this.pathPopupButton.removeAllItems();
        if (enabled) {
            this.navigation.add(this.workdir);
            Path p = this.workdir;
            do {
                this.addNavigation(p);
            } while (!(p = p.getParent()).isRoot());
            this.addNavigation(p);
        }
        this.pathPopupButton.setEnabled(enabled);
        this.navigationButton.setEnabled_forSegment(enabled && this.navigation.getBack().size() > 1, NavigationSegment.back.position());
        this.navigationButton.setEnabled_forSegment(enabled && this.navigation.getForward().size() > 0, NavigationSegment.forward.position());
        this.upButton.setEnabled_forSegment(enabled && !this.workdir.isRoot(), NavigationSegment.up.position());
    }

    public void setNavigationButton(NSSegmentedControl navigationButton) {
        this.navigationButton = navigationButton;
        this.navigationButton.setTarget(this.id());
        this.navigationButton.setAction(Foundation.selector((String)"navigationButtonClicked:"));
        NSSegmentedCell cell = (NSSegmentedCell)Rococoa.cast((ObjCObject)this.navigationButton.cell(), NSSegmentedCell.class);
        this.navigationButton.setImage_forSegment((NSImage)IconCacheFactory.get().iconNamed("nav-backward.tiff"), NavigationSegment.back.position());
        this.navigationButton.imageForSegment(NavigationSegment.back.position()).setTemplate(true);
        cell.setToolTip_forSegment(LocaleFactory.localizedString((String)"Back", (String)"Main"), NavigationSegment.back.position());
        this.navigationButton.setImage_forSegment((NSImage)IconCacheFactory.get().iconNamed("nav-forward.tiff"), NavigationSegment.forward.position());
        this.navigationButton.imageForSegment(NavigationSegment.forward.position()).setTemplate(true);
        cell.setToolTip_forSegment(LocaleFactory.localizedString((String)"Forward", (String)"Main"), NavigationSegment.forward.position());
    }

    public void navigationButtonClicked(NSSegmentedControl sender) {
        switch (NavigationSegment.byPosition(sender.selectedSegment())) {
            case back: {
                this.backButtonClicked(sender.id());
                break;
            }
            case forward: {
                this.forwardButtonClicked(sender.id());
            }
        }
    }

    public void backButtonClicked(ID sender) {
        Path selected = this.navigation.back();
        if (selected != null) {
            Path previous = this.workdir;
            if (previous.getParent().equals((Object)selected)) {
                this.setWorkdir(selected, previous);
            } else {
                this.setWorkdir(selected);
            }
        }
    }

    public void forwardButtonClicked(ID sender) {
        Path selected = this.navigation.forward();
        if (selected != null) {
            this.setWorkdir(selected);
        }
    }

    public void setUpButton(NSSegmentedControl upButton) {
        this.upButton = upButton;
        this.upButton.setTarget(this.id());
        this.upButton.setAction(Foundation.selector((String)"upButtonClicked:"));
        this.upButton.setImage_forSegment((NSImage)IconCacheFactory.get().iconNamed("nav-up.tiff"), NavigationSegment.up.position());
        this.upButton.imageForSegment(NavigationSegment.up.position()).setTemplate(true);
    }

    public void upButtonClicked(ID sender) {
        Path previous = this.workdir;
        this.setWorkdir(previous.getParent(), previous);
    }

    public void setPathPopup(NSPopUpButton pathPopupButton) {
        this.pathPopupButton = pathPopupButton;
        this.pathPopupButton.setTarget(this.id());
        this.pathPopupButton.setAction(Foundation.selector((String)"pathPopupSelectionChanged:"));
    }

    public void pathPopupSelectionChanged(NSPopUpButton sender) {
        String selected = sender.selectedItem().representedObject();
        if (selected != null) {
            Path workdir;
            Path p = workdir = this.workdir();
            while (!p.getAbsolute().equals(selected)) {
                p = p.getParent();
            }
            this.setWorkdir(p);
            if (workdir.getParent().equals((Object)p)) {
                this.setWorkdir(p, workdir);
            } else {
                this.setWorkdir(p);
            }
        }
    }

    public void encodingMenuClicked(NSMenuItem sender) {
        String encoding = sender.representedObject();
        if (null == encoding) {
            return;
        }
        if (this.isMounted()) {
            if (this.pool.getHost().getEncoding().equals(encoding)) {
                return;
            }
            this.pool.getHost().setEncoding(encoding);
            this.mount(this.pool.getHost());
        }
    }

    public void setStatusSpinner(NSProgressIndicator statusSpinner) {
        this.statusSpinner = statusSpinner;
        this.statusSpinner.setDisplayedWhenStopped(false);
        this.statusSpinner.setIndeterminate(true);
    }

    public void setBrowserSpinner(NSProgressIndicator browserSpinner) {
        this.browserSpinner = browserSpinner;
    }

    public void setStatusLabel(NSTextField statusLabel) {
        this.statusLabel = statusLabel;
        this.statusLabel.setFont(NSFont.monospacedDigitSystemFontOfSize((double)NSFont.smallSystemFontSize()));
    }

    public void setStatus() {
        BackgroundAction current = this.registry.getCurrent();
        this.message(null != current ? current.getActivity() : null);
    }

    public void stop(BackgroundAction action) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                BrowserController.this.statusSpinner.stopAnimation(null);
            }
        });
        super.stop(action);
    }

    public void start(BackgroundAction action) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                BrowserController.this.statusSpinner.startAnimation(null);
            }
        });
        super.start(action);
    }

    public void message(final String label) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                if (StringUtils.isNotBlank((CharSequence)label)) {
                    BrowserController.this.statusLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)label, (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                } else if (BrowserController.this.getSelectedTabView() == BrowserTab.bookmarks) {
                    BrowserController.this.statusLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)MessageFormat.format(LocaleFactory.localizedString((String)"{0} Bookmarks"), BrowserController.this.bookmarkTable.numberOfRows()), (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                } else if (BrowserController.this.isMounted()) {
                    BrowserController.this.statusLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)MessageFormat.format(LocaleFactory.localizedString((String)"{0} Items"), String.valueOf(BrowserController.this.getSelectedBrowserView().numberOfRows())), (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                } else {
                    BrowserController.this.statusLabel.setStringValue("");
                }
            }
        });
    }

    public void log(TranscriptListener.Type type, String message) {
        this.transcript.log(type, message);
    }

    public void setSecurityLabel(NSButton securityLabel) {
        this.securityLabel = securityLabel;
        this.securityLabel.setEnabled(false);
        this.securityLabel.setTarget(this.id());
        this.securityLabel.setAction(Foundation.selector((String)"securityLabelClicked:"));
    }

    public void securityLabelClicked(ID sender) {
        List<X509Certificate> certificates = Arrays.asList(((X509TrustManager)this.pool.getFeature(X509TrustManager.class)).getAcceptedIssuers());
        if (certificates.isEmpty()) {
            return;
        }
        try {
            NSMutableArray certs = NSMutableArray.arrayWithCapacity((NSUInteger)new NSUInteger((long)certificates.size()));
            for (X509Certificate certificate : certificates) {
                certs.addObject((PointerType)SecurityFunctions.library.SecCertificateCreateWithData(null, NSData.dataWithBase64EncodedString((String)Base64.encodeBase64String((byte[])certificate.getEncoded()))));
            }
            SFCertificatePanel panel = SFCertificatePanel.sharedCertificatePanel();
            panel.setShowsHelp(false);
            panel.beginSheetForWindow_modalDelegate_didEndSelector_contextInfo_certificates_showGroup(this.window, this.id(), Foundation.selector((String)"certificateSheetDidEnd:returnCode:contextInfo:"), null, (NSArray)certs, true);
        }
        catch (CertificateException e) {
            log.warn(String.format("Failure decoding certificate %s", e.getMessage()));
        }
    }

    public void certificateSheetDidEnd_returnCode_contextInfo(NSWindow sheet, NSInteger returnCode, NSObject contextInfo) {
    }

    public void quicklookButtonClicked(ID sender) {
        if (this.quicklook.isOpen()) {
            this.quicklook.close();
        } else {
            this.updateQuickLookSelection(this.getSelectedPaths());
        }
    }

    public void reloadButtonClicked(ID sender) {
        if (this.isMounted()) {
            HashSet<Path> folders = new HashSet<Path>();
            switch (BrowserSwitchSegement.byPosition(this.preferences.getInteger("browser.view"))) {
                case outline: {
                    for (int i = 0; i < this.browserOutlineView.numberOfRows().intValue(); ++i) {
                        NSObject item = this.browserOutlineView.itemAtRow(new NSInteger((long)i));
                        Path file = (Path)this.cache.lookup((CacheReference)new NSObjectPathReference(item));
                        if (null == file || !file.isDirectory()) continue;
                        this.cache.invalidate((Referenceable)file);
                        if (!this.browserOutlineView.isItemExpanded(item)) continue;
                        folders.add(file);
                    }
                    break;
                }
            }
            folders.add(this.workdir);
            this.reload(this.workdir, folders, this.getSelectedPaths(), true);
        }
    }

    public void newBrowserButtonClicked(ID sender) {
        Path selected = this.getSelectedPath();
        if (null == selected || !selected.isDirectory()) {
            selected = this.workdir;
        }
        BrowserController c = MainController.newDocument(true);
        Host duplicate = new HostDictionary().deserialize(this.pool.getHost().serialize(SerializerFactory.get()));
        duplicate.setUuid(null);
        duplicate.setDefaultPath(selected.getAbsolute());
        c.mount(duplicate);
    }

    public boolean isEditable(Path selected) {
        if (this.isMounted()) {
            if (this.pool.getHost().getCredentials().isAnonymousLogin()) {
                return false;
            }
            return selected.isFile();
        }
        return false;
    }

    public void gotoButtonClicked(ID sender) {
        GotoController sheet = new GotoController(this, this.cache);
        sheet.beginSheet(this);
    }

    public void createFileButtonClicked(ID sender) {
        CreateFileController sheet = new CreateFileController(this.getWorkdirFromSelection(), this.getSelectedPath(), this.cache, new CreateFileController.Callback(){

            @Override
            public void callback(final boolean edit, final Path file) {
                BrowserController.this.background((BackgroundAction)new WorkerBackgroundAction((Controller)BrowserController.this, BrowserController.this.pool, (Worker)new TouchWorker(file){

                    public void cleanup(Path folder) {
                        BrowserController.this.reload(BrowserController.this.workdir, Collections.singletonList(file), Collections.singletonList(file));
                        if (edit) {
                            file.attributes().setSize(0L);
                            BrowserController.this.edit(file);
                        }
                    }
                }));
            }
        });
        sheet.beginSheet(this);
    }

    public void createSymlinkButtonClicked(ID sender) {
        CreateSymlinkController sheet = new CreateSymlinkController(this.getWorkdirFromSelection(), this.getSelectedPath(), this.cache, new CreateSymlinkController.Callback(){

            @Override
            public void callback(Path selected, Path link) {
                BrowserController.this.background((BackgroundAction)new WorkerBackgroundAction((Controller)BrowserController.this, BrowserController.this.pool, (Worker)new CreateSymlinkWorker(link, selected.getName()){

                    public void cleanup(Path symlink) {
                        BrowserController.this.reload(BrowserController.this.workdir, Collections.singletonList(symlink), Collections.singletonList(symlink));
                    }
                }));
            }
        });
        sheet.beginSheet(this);
    }

    public void duplicateFileButtonClicked(ID sender) {
        DuplicateFileController sheet = new DuplicateFileController(this.getWorkdirFromSelection(), this.getSelectedPath(), this.cache, new DuplicateFileController.Callback(){

            @Override
            public void callback(final Map<Path, Path> selected) {
                new OverwriteController(BrowserController.this).overwrite(new ArrayList<Path>(selected.values()), (MainAction)new DefaultMainAction(){

                    public void run() {
                        BrowserController.this.background((BackgroundAction)new WorkerBackgroundAction((Controller)BrowserController.this, BrowserController.this.pool, (Worker)new CopyWorker(selected, BrowserController.this.pool.getHost().getProtocol().getStatefulness() == Protocol.Statefulness.stateful ? SessionPoolFactory.create((Controller)BrowserController.this, (Host)BrowserController.this.pool.getHost()) : BrowserController.this.pool, BrowserController.this.cache, (ProgressListener)BrowserController.this, (ConnectionCallback)LoginCallbackFactory.get((Controller)BrowserController.this)){

                            public void cleanup(Map<Path, Path> result) {
                                ArrayList<Path> changed = new ArrayList<Path>();
                                changed.addAll(result.keySet());
                                changed.addAll(result.values());
                                BrowserController.this.reload(BrowserController.this.workdir, changed, new ArrayList<Path>(selected.values()));
                            }
                        }));
                    }
                });
            }
        });
        sheet.beginSheet(this);
    }

    public void createFolderButtonClicked(ID sender) {
        Location feature = (Location)this.pool.getFeature(Location.class);
        FolderController sheet = new FolderController(this.getWorkdirFromSelection(), this.getSelectedPath(), this.cache, feature != null ? feature.getLocations() : Collections.emptySet(), feature != null ? feature.getDefault() : Location.unknown, new FolderController.Callback(){

            @Override
            public void callback(Path folder, String region) {
                BrowserController.this.background((BackgroundAction)new WorkerBackgroundAction((Controller)BrowserController.this, BrowserController.this.pool, (Worker)new CreateDirectoryWorker(folder, region){

                    public void cleanup(Path folder) {
                        BrowserController.this.reload(BrowserController.this.workdir, Collections.singletonList(folder), Collections.singletonList(folder));
                    }
                }));
            }
        });
        sheet.beginSheet(this);
    }

    public void createEncryptedVaultButtonClicked(ID sender) {
        Location feature = (Location)this.pool.getFeature(Location.class);
        VaultController sheet = new VaultController(this.getWorkdirFromSelection(), this.getSelectedPath(), this.cache, (Set<Location.Name>)(feature != null ? feature.getLocations() : Collections.emptySet()), feature != null ? feature.getDefault() : Location.unknown, new VaultController.Callback(){

            @Override
            public void callback(final Path folder, String region, VaultCredentials passphrase) {
                BrowserController.this.background((BackgroundAction)new WorkerBackgroundAction((Controller)BrowserController.this, BrowserController.this.pool, (Worker)new CreateVaultWorker(region, passphrase, (PasswordStore)PasswordStoreFactory.get(), VaultFactory.get((Path)folder, (String)new HostPreferences(BrowserController.this.pool.getHost()).getProperty("cryptomator.vault.masterkey.filename"), (String)new HostPreferences(BrowserController.this.pool.getHost()).getProperty("cryptomator.vault.config.filename"), (byte[])new HostPreferences(BrowserController.this.pool.getHost()).getProperty("cryptomator.vault.pepper").getBytes(StandardCharsets.UTF_8))){

                    public void cleanup(Path vault) {
                        BrowserController.this.reload(BrowserController.this.workdir, Collections.singletonList(folder), Collections.singletonList(folder));
                    }
                }));
            }
        });
        sheet.beginSheet(this);
    }

    public void lockUnlockEncryptedVaultButtonClicked(ID sender) {
        Path directory = new UploadTargetFinder(this.workdir).find(this.getSelectedPath());
        if (directory.attributes().getVault() != null) {
            this.background((BackgroundAction)new WorkerBackgroundAction((Controller)this, this.pool, (Worker)new LockVaultWorker(this.pool.getVault(), directory.attributes().getVault()){

                public void cleanup(Path vault) {
                    if (vault != null) {
                        BrowserController.this.reload(vault, Collections.singleton(vault), Collections.emptyList(), true);
                    }
                }
            }));
        } else {
            this.background((BackgroundAction)new WorkerBackgroundAction((Controller)this, this.pool, (Worker)new LoadVaultWorker((VaultLookupListener)new LoadingVaultLookupListener(this.pool.getVault(), (PasswordStore)PasswordStoreFactory.get(), PasswordCallbackFactory.get((Controller)this)), directory){

                public void cleanup(Vault vault) {
                    if (vault != null) {
                        BrowserController.this.reload(vault.getHome(), Collections.singleton(vault.getHome()), Collections.emptyList(), true);
                    }
                }
            }));
        }
    }

    public void renameFileButtonClicked(ID sender) {
        NSTableView browser = this.getSelectedBrowserView();
        browser.editRow(browser.columnWithIdentifier(BrowserColumn.filename.name()), browser.selectedRow(), true);
        Path selected = this.getSelectedPath();
        if (StringUtils.isNotBlank((CharSequence)selected.getExtension())) {
            NSText view = browser.currentEditor();
            if (null == view) {
                return;
            }
            int index = selected.getName().indexOf(selected.getExtension()) - 1;
            if (index > 0) {
                view.setSelectedRange(NSRange.NSMakeRange((NSUInteger)new NSUInteger(0L), (NSUInteger)new NSUInteger((long)index)));
            }
        }
    }

    public void sendCustomCommandClicked(ID sender) {
        CommandController controller = new CommandController(this, this.pool);
        SheetInvoker sheet = new SheetInvoker((SheetCallback)controller, (WindowController)this, (WindowController)controller);
        sheet.beginSheet();
    }

    public void editMenuClicked(NSMenuItem sender) {
        for (Path selected : this.getSelectedPaths()) {
            this.edit(new Application(sender.representedObject()), selected);
        }
    }

    public void editButtonClicked(ID sender) {
        for (Path selected : this.getSelectedPaths()) {
            this.edit(selected);
        }
    }

    public void edit(Path file) {
        this.edit(EditorFactory.getEditor((String)file.getName()), file);
    }

    protected void edit(Application application, final Path file) {
        Editor editor = this.editors.getOrDefault(file, EditorFactory.instance().create(this.pool.getHost(), file, (ProgressListener)this));
        this.background((BackgroundAction)new WorkerBackgroundAction((Controller)this, this.pool, editor.open(application, (ApplicationQuitCallback)new DisabledApplicationQuitCallback(), (FileWatcherListener)new DefaultEditorListener((Controller)this, this.pool, editor, new DefaultEditorListener.Listener(){

            public void saved() {
                BrowserController.this.reload(BrowserController.this.workdir, new PathReloadFinder().find(Collections.singletonList(file)), Collections.singletonList(file), true);
            }
        }))));
    }

    public void openBrowserButtonClicked(ID sender) {
        DescriptiveUrlBag list = this.getSelectionCount() == 1 ? ((UrlProvider)this.pool.getFeature(UrlProvider.class)).toUrl(this.getSelectedPath()) : ((UrlProvider)this.pool.getFeature(UrlProvider.class)).toUrl(this.workdir);
        if (!list.isEmpty()) {
            BrowserLauncherFactory.get().open(list.find(DescriptiveUrl.Type.http).getUrl());
        }
    }

    public void infoButtonClicked(ID sender) {
        if (this.getSelectionCount() > 0) {
            InfoController c = InfoControllerFactory.create(this, this.getSelectedPaths());
            c.window().makeKeyAndOrderFront(null);
        }
    }

    public void revertFileButtonClicked(ID sender) {
        final List<Path> selected = this.getSelectedPaths();
        new RevertController(this, this.pool).revert(selected, new ReloadCallback(){

            @Override
            public void done(List<Path> files) {
                BrowserController.this.reload(BrowserController.this.workdir(), selected, Collections.emptyList());
            }
        });
    }

    public void restoreFileButtonClicked(ID sender) {
        final List<Path> selected = this.getSelectedPaths();
        new RestoreController(this, this.pool).restore(selected, new ReloadCallback(){

            @Override
            public void done(List<Path> files) {
                BrowserController.this.reload(BrowserController.this.workdir(), selected, (List<Path>)selected);
            }
        });
    }

    public void deleteFileButtonClicked(ID sender) {
        final List<Path> selected = this.getSelectedPaths();
        new DeleteController(this, this.pool).delete(selected, new ReloadCallback(){

            @Override
            public void done(List<Path> files) {
                BrowserController.this.reload(BrowserController.this.workdir(), selected, Collections.emptyList());
            }
        });
    }

    public void shareFileButtonClicked(ID sender) {
        final Path file = null != this.getSelectedPath() ? this.getSelectedPath() : this.workdir();
        this.background((BackgroundAction)new WorkerBackgroundAction((Controller)this, this.pool, (Worker)new DownloadShareWorker<Void>(file, null, PasswordCallbackFactory.get((Controller)this)){

            public void cleanup(final DescriptiveUrl url) {
                if (!DescriptiveUrl.EMPTY.equals((Object)url)) {
                    AlertController alert = new AlertController(NSAlert.alert((String)LocaleFactory.localizedString((String)"Share\u2026", (String)"Main"), (String)MessageFormat.format(LocaleFactory.localizedString((String)"You have successfully created a share link for {0}.", (String)"SDS"), file.getName()), (String)LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), (String)LocaleFactory.localizedString((String)"Copy", (String)"Main"), null)){

                        public void callback(int returncode) {
                            switch (returncode) {
                                case -1: {
                                    NSPasteboard pboard = NSPasteboard.generalPasteboard();
                                    pboard.declareTypes(NSArray.arrayWithObject((NSObject)NSString.stringWithString((String)"NSStringPboardType")), null);
                                    if (pboard.setStringForType(url.getUrl(), "NSStringPboardType")) break;
                                    log.error(String.format("Error writing URL to %s", "NSStringPboardType"));
                                }
                            }
                        }

                        public NSView getAccessoryView(NSAlert alert) {
                            NSTextField field = NSTextField.textfieldWithFrame((NSRect)new NSRect(0.0, 22.0));
                            field.setEditable(false);
                            field.setSelectable(true);
                            field.cell().setWraps(false);
                            field.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)url.getUrl(), (NSDictionary)TRUNCATE_MIDDLE_ATTRIBUTES));
                            return field;
                        }
                    };
                    alert.beginSheet((WindowController)BrowserController.this);
                }
            }
        }));
    }

    public void requestFilesButtonClicked(ID sender) {
        final Path file = null != this.getSelectedPath() ? this.getSelectedPath() : this.workdir();
        this.background((BackgroundAction)new WorkerBackgroundAction((Controller)this, this.pool, (Worker)new UploadShareWorker<Void>(file, null, PasswordCallbackFactory.get((Controller)this)){

            public void cleanup(final DescriptiveUrl url) {
                if (!DescriptiveUrl.EMPTY.equals((Object)url)) {
                    AlertController alert = new AlertController(NSAlert.alert((String)LocaleFactory.localizedString((String)"Share\u2026", (String)"Main"), (String)MessageFormat.format(LocaleFactory.localizedString((String)"You have successfully created a share link for {0}.", (String)"SDS"), file.getName()), (String)LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), (String)LocaleFactory.localizedString((String)"Copy", (String)"Main"), null)){

                        public void callback(int returncode) {
                            switch (returncode) {
                                case -1: {
                                    NSPasteboard pboard = NSPasteboard.generalPasteboard();
                                    pboard.declareTypes(NSArray.arrayWithObject((NSObject)NSString.stringWithString((String)"NSStringPboardType")), null);
                                    if (pboard.setStringForType(url.getUrl(), "NSStringPboardType")) break;
                                    log.error(String.format("Error writing URL to %s", "NSStringPboardType"));
                                }
                            }
                        }

                        public NSView getAccessoryView(NSAlert alert) {
                            NSTextField field = NSTextField.textfieldWithFrame((NSRect)new NSRect(0.0, 22.0));
                            field.setEditable(false);
                            field.setSelectable(true);
                            field.cell().setWraps(false);
                            field.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)url.getUrl(), (NSDictionary)TRUNCATE_MIDDLE_ATTRIBUTES));
                            return field;
                        }
                    };
                    alert.beginSheet((WindowController)BrowserController.this);
                }
            }
        }));
    }

    public void downloadToButtonClicked(ID sender) {
        this.downloadToPanel = NSOpenPanel.openPanel();
        this.downloadToPanel.setCanChooseDirectories(true);
        this.downloadToPanel.setCanCreateDirectories(true);
        this.downloadToPanel.setCanChooseFiles(false);
        this.downloadToPanel.setAllowsMultipleSelection(false);
        this.downloadToPanel.setPrompt(LocaleFactory.localizedString((String)"Choose"));
        this.downloadToPanel.beginSheetForDirectory(new DownloadDirectoryFinder().find(this.pool.getHost()).getAbsolute(), null, this.window, this.id(), Foundation.selector((String)"downloadToPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void downloadToPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        sheet.orderOut(contextInfo);
        if (returncode == 1 && sheet.URL() != null) {
            Local target = LocalFactory.get((String)sheet.URL().path());
            new DownloadDirectoryFinder().save(this.pool.getHost(), target);
            ArrayList<TransferItem> downloads = new ArrayList<TransferItem>();
            for (Path file : this.getSelectedPaths()) {
                downloads.add(new TransferItem(file, LocalFactory.get((Local)target, (String)file.getName())));
            }
            this.transfer((Transfer)new DownloadTransfer(this.pool.getHost(), downloads), Collections.emptyList());
        }
        this.downloadToPanel = null;
    }

    public void downloadAsButtonClicked(ID sender) {
        this.downloadAsPanel = NSSavePanel.savePanel();
        this.downloadAsPanel.setMessage(LocaleFactory.localizedString((String)"Download the selected file to\u2026"));
        this.downloadAsPanel.setNameFieldLabel(LocaleFactory.localizedString((String)"Download As:"));
        this.downloadAsPanel.setPrompt(LocaleFactory.localizedString((String)"Download", (String)"Transfer"));
        this.downloadAsPanel.setCanCreateDirectories(true);
        this.downloadAsPanel.beginSheetForDirectory(new DownloadDirectoryFinder().find(this.pool.getHost()).getAbsolute(), this.getSelectedPath().getName(), this.window, this.id(), Foundation.selector((String)"downloadAsPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void downloadAsPanelDidEnd_returnCode_contextInfo(NSSavePanel sheet, int returncode, ID contextInfo) {
        sheet.orderOut(contextInfo);
        if (returncode == 1 && sheet.URL() != null) {
            Local target = LocalFactory.get((String)sheet.URL().path());
            new DownloadDirectoryFinder().save(this.pool.getHost(), target.getParent());
            List<TransferItem> downloads = Collections.singletonList(new TransferItem(this.getSelectedPath(), target));
            this.transfer((Transfer)new DownloadTransfer(this.pool.getHost(), downloads), Collections.emptyList());
        }
    }

    public void syncButtonClicked(ID sender) {
        Path selection = this.getSelectionCount() == 1 && this.getSelectedPath().isDirectory() ? this.getSelectedPath() : this.workdir;
        this.syncPanel = NSOpenPanel.openPanel();
        this.syncPanel.setCanChooseDirectories(selection.isDirectory());
        this.syncPanel.setTreatsFilePackagesAsDirectories(true);
        this.syncPanel.setCanChooseFiles(selection.isFile());
        this.syncPanel.setCanCreateDirectories(true);
        this.syncPanel.setAllowsMultipleSelection(false);
        this.syncPanel.setMessage(MessageFormat.format(LocaleFactory.localizedString((String)"Synchronize {0} with"), selection.getName()));
        this.syncPanel.setPrompt(LocaleFactory.localizedString((String)"Choose"));
        this.syncPanel.beginSheetForDirectory(new UploadDirectoryFinder().find(this.pool.getHost()).getAbsolute(), null, this.window, this.id(), Foundation.selector((String)"syncPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void syncPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        sheet.orderOut(contextInfo);
        if (returncode == 1 && sheet.URL() != null) {
            Local target = LocalFactory.get((String)sheet.URL().path());
            new UploadDirectoryFinder().save(this.pool.getHost(), target.getParent());
            Path selected = this.getSelectionCount() == 1 && this.getSelectedPath().isDirectory() ? this.getSelectedPath() : this.workdir;
            this.transfer((Transfer)new SyncTransfer(this.pool.getHost(), new TransferItem(selected, target)));
        }
    }

    public void downloadButtonClicked(ID sender) {
        ArrayList<TransferItem> downloads = new ArrayList<TransferItem>();
        Local folder = new DownloadDirectoryFinder().find(this.pool.getHost());
        for (Path file : this.getSelectedPaths()) {
            downloads.add(new TransferItem(file, LocalFactory.get((Local)folder, (String)file.getName())));
        }
        this.transfer((Transfer)new DownloadTransfer(this.pool.getHost(), downloads), Collections.emptyList());
    }

    public void uploadButtonClicked(ID sender) {
        this.uploadPanel = NSOpenPanel.openPanel();
        this.uploadPanel.setCanChooseDirectories(true);
        this.uploadPanel.setCanChooseFiles(((Touch)this.pool.getFeature(Touch.class)).isSupported(new UploadTargetFinder(this.workdir).find(this.getSelectedPath()), ""));
        this.uploadPanel.setCanCreateDirectories(false);
        this.uploadPanel.setTreatsFilePackagesAsDirectories(true);
        this.uploadPanel.setAllowsMultipleSelection(true);
        this.uploadPanel.setPrompt(LocaleFactory.localizedString((String)"Upload", (String)"Transfer"));
        if (this.uploadPanel.respondsToSelector(Foundation.selector((String)"setShowsHiddenFiles:"))) {
            this.uploadPanelHiddenFilesCheckbox = NSButton.buttonWithFrame((NSRect)new NSRect(0.0, 0.0));
            this.uploadPanelHiddenFilesCheckbox.setTitle(LocaleFactory.localizedString((String)"Show Hidden Files"));
            this.uploadPanelHiddenFilesCheckbox.setTarget(this.id());
            this.uploadPanelHiddenFilesCheckbox.setAction(Foundation.selector((String)"uploadPanelSetShowHiddenFiles:"));
            this.uploadPanelHiddenFilesCheckbox.setButtonType(3);
            this.uploadPanelHiddenFilesCheckbox.setState(0);
            this.uploadPanelHiddenFilesCheckbox.sizeToFit();
            this.uploadPanel.setAccessoryView((NSView)this.uploadPanelHiddenFilesCheckbox);
        }
        this.uploadPanel.beginSheetForDirectory(new UploadDirectoryFinder().find(this.pool.getHost()).getAbsolute(), null, this.window, this.id(), Foundation.selector((String)"uploadPanelDidEnd:returnCode:contextInfo:"), null);
    }

    public void uploadPanelSetShowHiddenFiles(ID sender) {
        this.uploadPanel.setShowsHiddenFiles(this.uploadPanelHiddenFilesCheckbox.state() == 1);
    }

    public void uploadPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        sheet.orderOut(contextInfo);
        if (returncode == 1) {
            NSObject next;
            Path destination = new UploadTargetFinder(this.workdir).find(this.getSelectedPath());
            NSArray selected = sheet.URLs();
            NSEnumerator iterator = selected.objectEnumerator();
            ArrayList<TransferItem> uploads = new ArrayList<TransferItem>();
            boolean parentFound = false;
            Local parent = null;
            while ((next = iterator.nextObject()) != null) {
                Local local = LocalFactory.get((String)((NSURL)Rococoa.cast((ObjCObject)next, NSURL.class)).path());
                Local localParent = local.getParent();
                if (!parentFound && localParent != parent) {
                    parentFound = true;
                    parent = localParent;
                } else if (parentFound && localParent != parent) {
                    parent = null;
                }
                uploads.add(new TransferItem(new Path(destination, local.getName(), local.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file)), local));
            }
            if (parent != null) {
                new UploadDirectoryFinder().save(this.pool.getHost(), parent);
            }
            this.transfer((Transfer)new UploadTransfer(this.pool.getHost(), uploads));
        }
        this.uploadPanel = null;
        this.uploadPanelHiddenFilesCheckbox = null;
    }

    public void transfer(Transfer transfer) {
        ArrayList<Path> selected = new ArrayList<Path>();
        for (TransferItem i : transfer.getRoots()) {
            selected.add(i.remote);
        }
        this.transfer(transfer, selected);
    }

    public void transfer(Transfer transfer, List<Path> selected) {
        this.transfer(transfer, selected, Host.TransferType.getType((Host)transfer.getSource()).equals((Object)Host.TransferType.browser));
    }

    public void transfer(Transfer transfer, final List<Path> selected, boolean browser) {
        TransferCallback callback = new TransferCallback(){

            public void complete(Transfer transfer) {
                BrowserController.this.invoke((MainAction)new WindowMainAction(BrowserController.this){

                    public void run() {
                        BrowserController.this.reload(BrowserController.this.workdir, selected, (List<Path>)selected);
                    }
                });
            }
        };
        if (browser) {
            this.background((BackgroundAction)new BrowserTransferBackgroundAction((Controller)this, this.pool, transfer, callback));
        } else {
            TransferControllerFactory.get().start(transfer, new TransferOptions(), callback);
        }
    }

    public void insideButtonClicked(ID sender) {
        Path selected = this.getSelectedPath();
        if (null == selected) {
            return;
        }
        if (selected.isDirectory()) {
            this.setWorkdir(selected);
        } else if (selected.isFile() || this.getSelectionCount() > 1) {
            if (this.preferences.getBoolean("browser.doubleclick.edit")) {
                this.editButtonClicked(null);
            } else {
                this.downloadButtonClicked(null);
            }
        }
    }

    public void connectButtonClicked(ID sender) {
        final ConnectionController controller = ConnectionControllerFactory.create(this);
        SheetInvoker sheet = new SheetInvoker(new SheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    BrowserController.this.mount(controller.getBookmark());
                }
                controller.callback(returncode);
            }
        }, (WindowController)this, (WindowController)controller);
        sheet.beginSheet();
    }

    public void disconnectButtonClicked(ID sender) {
        for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
            action.cancel();
        }
        this.disconnect(new Runnable(){

            @Override
            public void run() {
                if (BrowserController.this.preferences.getBoolean("browser.disconnect.bookmarks.show")) {
                    BrowserController.this.selectBookmarks(BookmarkSwitchSegement.bookmarks);
                } else {
                    BrowserController.this.selectBrowser(BrowserSwitchSegement.byPosition(BrowserController.this.preferences.getInteger("browser.view")));
                }
            }
        });
    }

    public void showHiddenFilesClicked(NSMenuItem sender) {
        if (sender.state() == 1) {
            this.setShowHiddenFiles(false);
            sender.setState(0);
        } else if (sender.state() == 0) {
            this.setShowHiddenFiles(true);
            sender.setState(1);
        }
        this.reload();
    }

    public SessionPool getSession() {
        return this.pool;
    }

    public Cache<Path> getCache() {
        return this.cache;
    }

    public boolean isMounted() {
        if (this.pool == SessionPool.DISCONNECTED) {
            return false;
        }
        return this.workdir != null;
    }

    public boolean isConnected() {
        switch (this.pool.getState()) {
            case open: {
                return !this.cache.isEmpty();
            }
        }
        return false;
    }

    public boolean isIdle() {
        return this.registry.isEmpty();
    }

    public ID validRequestorForSendType_returnType(String sendType, String returnType) {
        log.debug("validRequestorForSendType_returnType:" + sendType + "," + returnType);
        if (StringUtils.isNotEmpty((CharSequence)sendType)) {
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)returnType) && "NSFilenamesPboardType".equals(sendType)) {
            return this.id();
        }
        return null;
    }

    public boolean readSelectionFromPasteboard(NSPasteboard pboard) {
        return this.upload(pboard);
    }

    public boolean writeSelectionToPasteboard_types(NSPasteboard pboard, NSArray types) {
        return false;
    }

    public void copy(ID sender) {
        this.pasteboard.clear();
        this.pasteboard.setCopy(true);
        List<Path> s = this.getSelectedPaths();
        this.pasteboard.addAll(s);
        NSPasteboard clipboard = NSPasteboard.generalPasteboard();
        if (s.size() == 0) {
            s.add(this.workdir);
        }
        clipboard.declareTypes(NSArray.arrayWithObject((NSObject)NSString.stringWithString((String)"NSStringPboardType")), null);
        StringBuilder copy = new StringBuilder();
        Iterator<Path> i = s.iterator();
        while (i.hasNext()) {
            Path next = i.next();
            copy.append(next.getAbsolute());
            if (this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.size.name()))) {
                copy.append(",");
                if (-1L != next.attributes().getSize()) {
                    copy.append(next.attributes().getSize());
                }
            }
            if (this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.modified.name()))) {
                copy.append(",");
                if (-1L != next.attributes().getModificationDate()) {
                    copy.append(next.attributes().getModificationDate());
                }
            }
            if (this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.owner.name()))) {
                copy.append(",");
                if (StringUtils.isNotBlank((CharSequence)next.attributes().getOwner())) {
                    copy.append(next.attributes().getOwner());
                }
            }
            if (this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.group.name()))) {
                copy.append(",");
                if (StringUtils.isNotBlank((CharSequence)next.attributes().getGroup())) {
                    copy.append(next.attributes().getGroup());
                }
            }
            if (this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.permission.name()))) {
                copy.append(",");
                if (Permission.EMPTY != next.attributes().getPermission()) {
                    copy.append(next.attributes().getPermission().getMode());
                }
            }
            if (this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.region.name()))) {
                copy.append(",").append(next.attributes().getRegion());
            }
            if (this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.version.name()))) {
                copy.append(",").append(next.attributes().getVersionId());
            }
            if (this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.checksum.name()))) {
                copy.append(",");
                if (Checksum.NONE != next.attributes().getChecksum()) {
                    copy.append(",").append(next.attributes().getChecksum().hash);
                }
            }
            if (this.preferences.getBoolean(String.format("browser.column.%s", BrowserColumn.storageclass.name()))) {
                copy.append(",").append(next.attributes().getStorageClass());
            }
            if (!i.hasNext()) continue;
            copy.append("\n");
        }
        if (!clipboard.setStringForType(copy.toString(), "NSStringPboardType")) {
            log.error("Error writing to NSPasteboard.StringPboardType.");
        }
    }

    public void cut(ID sender) {
        this.pasteboard.clear();
        this.pasteboard.setCut(true);
        this.pasteboard.addAll(this.getSelectedPaths());
        NSPasteboard clipboard = NSPasteboard.generalPasteboard();
        clipboard.declareTypes(NSArray.arrayWithObject((NSObject)NSString.stringWithString((String)"NSStringPboardType")), null);
        if (!clipboard.setStringForType(this.getSelectedPath().getAbsolute(), "NSStringPboardType")) {
            log.error("Error writing to NSPasteboard.StringPboardType.");
        }
    }

    public void paste(ID sender) {
        if (this.pasteboard.isEmpty()) {
            NSPasteboard pboard = NSPasteboard.generalPasteboard();
            this.upload(pboard);
        } else {
            final HashMap<Path, Path> files = new HashMap<Path, Path>();
            Path parent = this.workdir;
            for (Path next : this.pasteboard) {
                Path renamed = new Path(parent, next.getName(), next.getType(), new PathAttributes(next.attributes()));
                files.put(next, renamed);
            }
            this.pasteboard.clear();
            if (this.pasteboard.isCut()) {
                new MoveController(this).rename(files);
            }
            if (this.pasteboard.isCopy()) {
                new OverwriteController(this).overwrite(new ArrayList<Path>(files.values()), (MainAction)new DefaultMainAction(){

                    public void run() {
                        BrowserController.this.transfer((Transfer)new CopyTransfer(BrowserController.this.pool.getHost(), BrowserController.this.pool.getHost(), files), new ArrayList<Path>(files.values()), true);
                    }
                });
            }
        }
    }

    private boolean upload(NSPasteboard pboard) {
        NSObject o;
        if (!this.isMounted()) {
            return false;
        }
        if (pboard.availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null && (o = pboard.propertyListForType("NSFilenamesPboardType")) != null && o.isKindOfClass((ObjCClass)NSArray.CLASS)) {
            NSArray elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
            ArrayList<TransferItem> uploads = new ArrayList<TransferItem>();
            for (int i = 0; i < elements.count().intValue(); ++i) {
                Local local = LocalFactory.get((String)elements.objectAtIndex(new NSUInteger((long)i)).toString());
                uploads.add(new TransferItem(new Path(this.workdir, local.getName(), local.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file)), local));
            }
            this.transfer((Transfer)new UploadTransfer(this.pool.getHost(), uploads));
        }
        return false;
    }

    public void openTerminalButtonClicked(ID sender) {
        Path selected;
        Path workdir = null;
        if (this.getSelectionCount() == 1 && (selected = this.getSelectedPath()).isDirectory()) {
            workdir = selected;
        }
        if (null == workdir) {
            workdir = this.workdir;
        }
        try {
            TerminalService terminal = TerminalServiceFactory.get();
            terminal.open(this.pool.getHost(), workdir);
        }
        catch (AccessDeniedException e) {
            new PromptAlertCallback(this).alert(this.pool.getHost(), (BackgroundException)e, new StringBuilder());
        }
    }

    public void archiveMenuClicked(NSMenuItem sender) {
        Archive archive = Archive.forName((String)sender.representedObject());
        this.archiveClicked(archive);
    }

    public void archiveButtonClicked(NSToolbarItem sender) {
        this.archiveClicked(Archive.TARGZ);
    }

    private void archiveClicked(Archive format) {
        new ArchiveController(this).archive(format, this.getSelectedPaths());
    }

    public void unarchiveButtonClicked(ID sender) {
        new ArchiveController(this).unarchive(this.getSelectedPaths());
    }

    public Path workdir() {
        return this.workdir;
    }

    public void setWorkdir(Path directory) {
        this.setWorkdir(directory, Collections.emptyList());
    }

    public void setWorkdir(Path directory, Path selected) {
        this.setWorkdir(directory, Collections.singletonList(selected));
    }

    public void setWorkdir(Path directory, List<Path> selected) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set working directory to %s", directory));
        }
        this.setFilter((Filter<Path>)SearchFilterFactory.create((boolean)this.showHiddenFiles));
        NSTableView browser = this.getSelectedBrowserView();
        this.window.endEditingFor((NSObject)browser);
        if (null == directory) {
            this.reload(null, Collections.emptySet(), selected, false);
        } else {
            this.reload(directory, Collections.singleton(directory), selected, false);
        }
    }

    private void addNavigation(Path p) {
        this.pathPopupButton.addItemWithTitle(p.getAbsolute());
        this.pathPopupButton.lastItem().setRepresentedObject(p.getAbsolute());
        if (p.isVolume()) {
            this.pathPopupButton.lastItem().setImage((NSImage)IconCacheFactory.get().volumeIcon(this.pool.getHost().getProtocol(), Integer.valueOf(16)));
        } else {
            this.pathPopupButton.lastItem().setImage((NSImage)IconCacheFactory.get().fileIcon(p, Integer.valueOf(16)));
        }
    }

    public void mount(final Host bookmark) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Mount session for %s", bookmark));
        }
        this.unmount(new Runnable(){

            @Override
            public void run() {
                BrowserController.this.pool = SessionPoolFactory.create((Controller)BrowserController.this, (Host)bookmark, (SessionPoolFactory.Usage[])new SessionPoolFactory.Usage[]{SessionPoolFactory.Usage.browser});
                BrowserController.this.background((BackgroundAction)new WorkerBackgroundAction<Path>((Controller)BrowserController.this, BrowserController.this.pool, (Worker)new MountWorker(bookmark, BrowserController.this.cache, BrowserController.this.listener){

                    public void cleanup(Path workdir) {
                        super.cleanup(workdir);
                        if (null == workdir) {
                            BrowserController.this.doUnmount(() -> {});
                        } else {
                            BrowserController.this.pasteboard = PathPasteboardFactory.getPasteboard((Host)bookmark);
                            BrowserController.this.bookmarkTable.setNeedsDisplay();
                            BrowserController.this.setWorkdir(workdir);
                            BrowserController.this.selectBrowser(BrowserSwitchSegement.byPosition(BrowserController.this.preferences.getInteger("browser.view")));
                            BrowserController.this.window.setRepresentedFilename(HistoryCollection.defaultCollection().getFile(bookmark).getAbsolute());
                            if (BrowserController.this.preferences.getBoolean("browser.disconnect.confirm")) {
                                BrowserController.this.window.setDocumentEdited(true);
                            }
                            BrowserController.this.securityLabel.setImage(bookmark.getProtocol().isSecure() ? (NSImage)IconCacheFactory.get().iconNamed("NSLockLockedTemplate") : (NSImage)IconCacheFactory.get().iconNamed("NSLockUnlockedTemplate"));
                            BrowserController.this.securityLabel.setEnabled(BrowserController.this.pool.getFeature(X509TrustManager.class) != null);
                            BrowserController.this.scheduler = (Scheduler)BrowserController.this.pool.getFeature(Scheduler.class);
                            if (BrowserController.this.scheduler != null) {
                                BrowserController.this.scheduler.repeat(BrowserController.this.pool, PasswordCallbackFactory.get((Controller)BrowserController.this));
                            }
                        }
                    }
                }){

                    public void init() {
                        super.init();
                        if (BrowserController.this.window.respondsToSelector(Foundation.selector((String)"setSubtitle:"))) {
                            BrowserController.this.window.setTitle(BookmarkNameProvider.toString((Host)bookmark, (boolean)false));
                            BrowserController.this.window.setSubtitle(BookmarkNameProvider.toHostname((Host)bookmark, (boolean)true));
                        } else {
                            BrowserController.this.window.setTitle(BookmarkNameProvider.toString((Host)bookmark, (boolean)true));
                        }
                        BrowserController.this.window.setRepresentedFilename("");
                        BrowserController.this.bookmarkTable.setNeedsDisplay();
                    }
                });
            }
        });
    }

    public boolean unmount(final Runnable disconnected) {
        return this.unmount(new SheetCallback(){

            public void callback(int returncode) {
                if (returncode == 1) {
                    BrowserController.this.doUnmount(disconnected);
                }
            }
        }, disconnected);
    }

    public boolean unmount(final SheetCallback callback, Runnable disconnected) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Unmount session %s", this.pool));
        }
        if (this.isConnected() && this.preferences.getBoolean("browser.disconnect.confirm")) {
            final NSAlert alert = NSAlert.alert((String)MessageFormat.format(LocaleFactory.localizedString((String)"Disconnect from {0}"), this.pool.getHost().getHostname()), (String)LocaleFactory.localizedString((String)"The connection will be closed."), (String)LocaleFactory.localizedString((String)"Disconnect"), (String)LocaleFactory.localizedString((String)"Cancel"), null);
            alert.setShowsSuppressionButton(true);
            alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't ask again", (String)"Configuration"));
            this.alert(alert, new SheetCallback(){

                public void callback(int returncode) {
                    if (alert.suppressionButton().state() == 1) {
                        BrowserController.this.preferences.setProperty("browser.disconnect.confirm", false);
                    }
                    callback.callback(returncode);
                }
            });
            return false;
        }
        this.doUnmount(disconnected);
        return true;
    }

    private void doUnmount(final Runnable disconnected) {
        this.disconnect(new Runnable(){

            @Override
            public void run() {
                if (BrowserController.this.scheduler != null) {
                    BrowserController.this.scheduler.shutdown();
                }
                BrowserController.this.pool.shutdown();
                BrowserController.this.pool = SessionPool.DISCONNECTED;
                BrowserController.this.cache.clear();
                BrowserController.this.setWorkdir(null);
                BrowserController.this.window.setTitle("");
                if (BrowserController.this.window.respondsToSelector(Foundation.selector((String)"setSubtitle:"))) {
                    BrowserController.this.window.setSubtitle("");
                }
                BrowserController.this.window.setRepresentedFilename("");
                BrowserController.this.navigation.clear();
                disconnected.run();
            }
        });
    }

    private void disconnect(final Runnable disconnected) {
        InfoController c = InfoControllerFactory.get(this);
        if (null != c) {
            c.window().close();
        }
        this.background((BackgroundAction)new DisconnectBackgroundAction((Controller)this, this.pool){

            public void cleanup() {
                super.cleanup();
                BrowserController.this.pasteboard.clear();
                BrowserController.this.window.setDocumentEdited(false);
                disconnected.run();
            }
        });
    }

    public void printDocument(ID sender) {
        this.print((NSView)this.getSelectedBrowserView());
    }

    public boolean windowShouldClose(NSWindow sender) {
        return this.unmount(() -> ((NSWindow)sender).close());
    }

    public boolean validateMenuItem(NSMenuItem item) {
        Selector action = item.action();
        if (action.equals((Object)Foundation.selector((String)"paste:"))) {
            String title = "Paste {0}";
            item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)"Paste {0}"), "").trim());
            if (this.isMounted()) {
                if (this.pasteboard.isEmpty()) {
                    NSObject o;
                    if (NSPasteboard.generalPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null && (o = NSPasteboard.generalPasteboard().propertyListForType("NSFilenamesPboardType")) != null && o.isKindOfClass((ObjCClass)NSArray.CLASS)) {
                        NSArray elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
                        if (elements.count().intValue() == 1) {
                            item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)"Paste {0}"), "\"" + elements.objectAtIndex(new NSUInteger(0L)) + "\"").trim());
                        } else {
                            item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)"Paste {0}"), MessageFormat.format(LocaleFactory.localizedString((String)"{0} Items"), String.valueOf(elements.count().intValue()))).trim());
                        }
                    }
                } else if (this.pasteboard.size() == 1) {
                    item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)"Paste {0}"), "\"" + ((Path)this.pasteboard.get(0)).getName() + "\"").trim());
                } else {
                    item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)"Paste {0}"), MessageFormat.format(LocaleFactory.localizedString((String)"{0} Items"), String.valueOf(this.pasteboard.size()))).trim());
                }
            }
        } else if (action.equals((Object)Foundation.selector((String)"cut:")) || action.equals((Object)Foundation.selector((String)"copy:"))) {
            String title = null;
            if (action.equals((Object)Foundation.selector((String)"cut:"))) {
                title = "Cut {0}";
            } else if (action.equals((Object)Foundation.selector((String)"copy:"))) {
                title = "Copy {0}";
            }
            if (this.isMounted()) {
                int count = this.getSelectionCount();
                if (0 == count) {
                    item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)title), "").trim());
                } else if (1 == count) {
                    item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)title), "\"" + this.getSelectedPath().getName() + "\"").trim());
                } else {
                    item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)title), MessageFormat.format(LocaleFactory.localizedString((String)"{0} Items"), String.valueOf(this.getSelectionCount()))).trim());
                }
            } else {
                item.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)title), "").trim());
            }
        } else if (action.equals((Object)Foundation.selector((String)"showHiddenFilesClicked:"))) {
            item.setState(this.getFilter() instanceof NullFilter ? 1 : 0);
        } else if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.encoding.action())) {
            if (this.isMounted()) {
                item.setState(this.pool.getHost().getEncoding().equalsIgnoreCase(item.title()) ? 1 : 0);
            } else {
                item.setState(this.preferences.getProperty("browser.charset.encoding").equalsIgnoreCase(item.title()) ? 1 : 0);
            }
        } else if (action.equals((Object)Foundation.selector((String)"browserSwitchMenuClicked:"))) {
            if (item.tag() == this.preferences.getInteger("browser.view")) {
                item.setState(1);
            } else {
                item.setState(0);
            }
        } else if (action.equals((Object)Foundation.selector((String)"archiveMenuClicked:"))) {
            Archive archive = Archive.forName((String)item.representedObject());
            item.setTitle(archive.getTitle(this.getSelectedPaths()));
        } else if (action.equals((Object)Foundation.selector((String)"quicklookButtonClicked:"))) {
            item.setKeyEquivalent(" ");
            item.setKeyEquivalentModifierMask(0);
        } else if (action.equals((Object)Foundation.selector((String)"lockUnlockEncryptedVaultButtonClicked:")) && this.isMounted()) {
            Path selected = new UploadTargetFinder(this.workdir()).find(this.getSelectedPath());
            VaultRegistry registry = this.pool.getVault();
            if (registry.contains(selected)) {
                item.setTitle(LocaleFactory.localizedString((String)"Lock Vault", (String)"Cryptomator"));
                item.setImage((NSImage)IconCacheFactory.get().iconNamed("NSLockUnlockedTemplate"));
            } else {
                item.setTitle(LocaleFactory.localizedString((String)"Unlock Vault", (String)"Cryptomator"));
                item.setImage((NSImage)IconCacheFactory.get().iconNamed("NSLockLockedTemplate"));
            }
        }
        return this.validate(action);
    }

    private boolean validate(Selector action) {
        return this.browserToolbarValidator.validate(action);
    }

    public boolean validateToolbarItem(NSToolbarItem item) {
        return this.browserToolbarValidator.validate(item);
    }

    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String itemIdentifier, boolean inserted) {
        if (log.isDebugEnabled()) {
            log.debug("toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar:" + itemIdentifier);
        }
        return this.browserToolbarFactory.create(itemIdentifier);
    }

    public NSArray toolbarDefaultItemIdentifiers(NSToolbar toolbar) {
        return this.browserToolbarFactory.getDefault();
    }

    public NSArray toolbarAllowedItemIdentifiers(NSToolbar toolbar) {
        return this.browserToolbarFactory.getAllowed();
    }

    public NSArray toolbarSelectableItemIdentifiers(NSToolbar toolbar) {
        return NSArray.array();
    }

    public void invalidate() {
        for (Editor editor : this.editors.values()) {
            editor.close();
        }
        this.temporary.shutdown();
        this.quicklook.close();
        this.bookmarkTable.setDelegate(null);
        this.bookmarkTable.setDataSource(null);
        this.bookmarkModel.invalidate();
        this.browserListView.setDelegate(null);
        this.browserListView.setDataSource(null);
        this.browserListModel.invalidate();
        this.browserOutlineView.setDelegate(null);
        this.browserOutlineView.setDataSource(null);
        this.browserOutlineModel.invalidate();
        this.toolbar.setDelegate(null);
        this.browserListColumnsFactory.clear();
        this.browserOutlineColumnsFactory.clear();
        this.bookmarkTableColumnFactory.clear();
        this.archiveMenu.setDelegate(null);
        this.editMenu.setDelegate(null);
        super.invalidate();
    }

    public static enum BrowserSwitchSegement {
        list,
        outline;


        public static BrowserSwitchSegement byPosition(int position) {
            return BrowserSwitchSegement.values()[position];
        }

        public NSImage image() {
            NSImage image = (NSImage)IconCacheFactory.get().iconNamed(String.format("%s.tiff", this.name()), Integer.valueOf(16));
            image.setTemplate(true);
            return image;
        }
    }

    private static enum BookmarkSwitchSegement {
        browser{

            @Override
            public NSImage image() {
                NSImage image = (NSImage)IconCacheFactory.get().iconNamed(String.format("%s.tiff", "outline"), Integer.valueOf(16));
                image.setTemplate(true);
                return image;
            }
        }
        ,
        bookmarks,
        history,
        rendezvous;


        public static BookmarkSwitchSegement byPosition(int position) {
            return BookmarkSwitchSegement.values()[position];
        }

        public NSImage image() {
            return (NSImage)IconCacheFactory.get().iconNamed(String.format("%s.tiff", this.name()), Integer.valueOf(16));
        }
    }

    private abstract class AbstractBrowserTableDelegate
    extends AbstractPathTableDelegate {
        private static final double kSwipeGestureLeft = 1.0;
        private static final double kSwipeGestureRight = -1.0;
        private static final double kSwipeGestureUp = 1.0;
        private static final double kSwipeGestureDown = -1.0;

        protected AbstractBrowserTableDelegate(NSTableColumn selectedColumn) {
            super(selectedColumn);
        }

        public boolean isColumnRowEditable(NSTableColumn column, NSInteger row) {
            if (BrowserController.this.preferences.getBoolean("browser.editable") && column.identifier().equals(BrowserColumn.filename.name())) {
                Path file = this.pathAtRow(row.intValue());
                if (null == file) {
                    return false;
                }
                return ((Move)BrowserController.this.pool.getFeature(Move.class)).isSupported(file, file);
            }
            return false;
        }

        public void tableRowDoubleClicked(ID sender) {
            BrowserController.this.insideButtonClicked(sender);
        }

        public void spaceKeyPressed(ID sender) {
            BrowserController.this.quicklookButtonClicked(sender);
        }

        public void deleteKeyPressed(ID sender) {
            BrowserController.this.deleteFileButtonClicked(sender);
        }

        public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            if (this.selectedColumnIdentifier().equals(tableColumn.identifier())) {
                this.setSortedAscending(!this.isSortedAscending());
            } else {
                this.setBrowserColumnSortingIndicator(null, this.selectedColumnIdentifier());
                this.setSelectedColumn(tableColumn);
                BrowserController.this.preferences.setProperty("browser.sort.column", this.selectedColumnIdentifier());
            }
            this.setBrowserColumnSortingIndicator(this.isSortedAscending() ? (NSImage)IconCacheFactory.get().iconNamed("NSAscendingSortIndicator") : (NSImage)IconCacheFactory.get().iconNamed("NSDescendingSortIndicator"), tableColumn.identifier());
            BrowserController.this.reload();
        }

        public void columnDidResize(String columnIdentifier, float width) {
            BrowserController.this.preferences.setProperty(String.format("browser.column.%s.width", columnIdentifier), width);
        }

        public void selectionDidChange(NSNotification notification) {
            InfoController c;
            if (BrowserController.this.quicklook.isOpen()) {
                BrowserController.this.updateQuickLookSelection(BrowserController.this.getSelectedPaths());
            }
            if (BrowserController.this.preferences.getBoolean("browser.info.inspector") && null != (c = InfoControllerFactory.get(BrowserController.this))) {
                c.setFiles(BrowserController.this.getSelectedPaths());
            }
        }

        protected abstract Path pathAtRow(int var1);

        protected abstract void setBrowserColumnSortingIndicator(NSImage var1, String var2);

        public void swipeWithEvent(NSEvent event) {
            if (event.deltaX().doubleValue() == 1.0) {
                BrowserController.this.backButtonClicked(event.id());
            } else if (event.deltaX().doubleValue() == -1.0) {
                BrowserController.this.forwardButtonClicked(event.id());
            } else if (event.deltaY().doubleValue() == 1.0) {
                NSInteger row = BrowserController.this.getSelectedBrowserView().selectedRow();
                NSInteger next = -1 == row.intValue() ? new NSInteger(0L) : new NSInteger(row.longValue() - 1L);
                BrowserController.this.getSelectedBrowserView().selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)next), false);
            } else if (event.deltaY().doubleValue() == -1.0) {
                NSInteger row = BrowserController.this.getSelectedBrowserView().selectedRow();
                NSInteger next = -1 == row.intValue() ? new NSInteger(0L) : new NSInteger(row.longValue() + 1L);
                BrowserController.this.getSelectedBrowserView().selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)next), false);
            }
        }
    }

    public static enum BrowserTab {
        bookmarks,
        list,
        outline;


        public static BrowserTab byPosition(int position) {
            return BrowserTab.values()[position];
        }
    }

    private static enum NavigationSegment {
        back(0),
        forward(1),
        up(0);

        private final int position;

        private NavigationSegment(int position) {
            this.position = position;
        }

        public static NavigationSegment byPosition(int position) {
            return NavigationSegment.values()[position];
        }

        public int position() {
            return this.position;
        }
    }

    private abstract class AbstractBrowserListViewDelegate<E>
    extends AbstractBrowserTableDelegate
    implements NSTableView.Delegate {
        protected AbstractBrowserListViewDelegate(NSTableColumn selectedColumn) {
            super(selectedColumn);
        }

        public String tableView_toolTipForCell_rect_tableColumn_row_mouseLocation(NSTableView t, NSCell cell, ID rect, NSTableColumn c, NSInteger row, NSPoint mouseLocation) {
            return this.tooltip((Path)BrowserController.this.browserListModel.get(BrowserController.this.workdir).get(row.intValue()), BrowserColumn.valueOf((String)c.identifier()));
        }

        @Override
        protected void setBrowserColumnSortingIndicator(NSImage image, String columnIdentifier) {
            BrowserController.this.browserListView.setIndicatorImage_inTableColumn(image, BrowserController.this.browserListView.tableColumnWithIdentifier(columnIdentifier));
        }

        public String tableView_typeSelectStringForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
            if (tableColumn.identifier().equals(BrowserColumn.filename.name())) {
                return BrowserController.this.browserListModel.tableView_objectValueForTableColumn_row(view, tableColumn, row).toString();
            }
            return null;
        }

        @Override
        protected Path pathAtRow(int row) {
            AttributedList<Path> children = BrowserController.this.browserListModel.get(BrowserController.this.workdir());
            if (row < children.size()) {
                return (Path)children.get(row);
            }
            log.warn(String.format("No item at row %d", row));
            return null;
        }
    }

    private abstract class AbstractBrowserOutlineViewDelegate
    extends AbstractBrowserTableDelegate
    implements NSOutlineView.Delegate {
        protected AbstractBrowserOutlineViewDelegate(NSTableColumn selectedColumn) {
            super(selectedColumn);
        }

        public String outlineView_toolTipForCell_rect_tableColumn_item_mouseLocation(NSOutlineView t, NSCell cell, ID rect, NSTableColumn c, NSObject item, NSPoint mouseLocation) {
            return this.tooltip((Path)BrowserController.this.cache.lookup((CacheReference)new NSObjectPathReference(item)), BrowserColumn.valueOf((String)c.identifier()));
        }

        public String outlineView_typeSelectStringForTableColumn_item(NSOutlineView view, NSTableColumn tableColumn, NSObject item) {
            if (tableColumn.identifier().equals(BrowserColumn.filename.name())) {
                return BrowserController.this.browserOutlineModel.outlineView_objectValueForTableColumn_byItem(view, tableColumn, item).toString();
            }
            return null;
        }

        @Override
        protected void setBrowserColumnSortingIndicator(NSImage image, String columnIdentifier) {
            BrowserController.this.browserOutlineView.setIndicatorImage_inTableColumn(image, BrowserController.this.browserOutlineView.tableColumnWithIdentifier(columnIdentifier));
        }

        @Override
        protected Path pathAtRow(int row) {
            if (row < BrowserController.this.browserOutlineView.numberOfRows().intValue()) {
                return (Path)BrowserController.this.cache.lookup((CacheReference)new NSObjectPathReference(BrowserController.this.browserOutlineView.itemAtRow(new NSInteger((long)row))));
            }
            log.warn(String.format("No item at row %d", row));
            return null;
        }
    }
}

