/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AbstractTableDelegate;
import ch.cyberduck.binding.ListDataSource;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.ui.cocoa.controller.TableColumnFactory;
import ch.cyberduck.ui.cocoa.controller.TaskController;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;

public final class ActivityController
extends WindowController {
    private static final Logger log = LogManager.getLogger(ActivityController.class);
    private final BackgroundActionRegistry registry = BackgroundActionRegistry.global();
    private final Map<BackgroundAction, TaskController> tasks = Collections.synchronizedMap(new LinkedHashMap());
    private final AbstractCollectionListener<BackgroundAction> backgroundActionListener = new AbstractCollectionListener<BackgroundAction>(){

        public void collectionItemAdded(BackgroundAction action) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Add background action %s", action));
            }
            ActivityController.this.tasks.put(action, new TaskController(action));
            ActivityController.this.reload();
        }

        public void collectionItemRemoved(BackgroundAction action) {
            log.debug(String.format("Remove background action %s", action));
            TaskController controller = (TaskController)((Object)ActivityController.this.tasks.remove(action));
            if (null == controller) {
                log.warn(String.format("Failed to find controller for action %s", action));
                return;
            }
            controller.invalidate();
            ActivityController.this.reload();
        }
    };
    private final TableColumnFactory tableColumnsFactory = new TableColumnFactory();
    private NSTableView table;
    private ListDataSource model;
    private AbstractTableDelegate<TaskController, ActivityColumn> delegate;

    public void awakeFromNib() {
        BackgroundAction[] actions;
        super.awakeFromNib();
        this.registry.addListener(this.backgroundActionListener);
        for (BackgroundAction action : actions = (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
            this.tasks.put(action, new TaskController(action));
        }
        this.reload();
    }

    public void invalidate() {
        this.registry.removeListener(this.backgroundActionListener);
        this.table.setDataSource(null);
        this.table.setDelegate(null);
        super.invalidate();
    }

    private void reload() {
        while (this.table.subviews().count().intValue() > 0) {
            ((NSView)Rococoa.cast((ObjCObject)this.table.subviews().lastObject(), NSView.class)).removeFromSuperviewWithoutNeedingDisplay();
        }
        this.table.reloadData();
    }

    public void setWindow(NSWindow window) {
        window.setContentMinSize(window.frame().size);
        window.setTitle(LocaleFactory.localizedString((String)"Activity"));
        super.setWindow(window);
    }

    public boolean isSingleton() {
        return true;
    }

    public void setTable(NSTableView table) {
        this.table = table;
        this.table.setRowHeight(new CGFloat(42.0));
        NSTableColumn c = this.tableColumnsFactory.create(ActivityColumn.single.name());
        c.setMinWidth(80.0);
        c.setWidth(300.0);
        c.setResizingMask(1);
        this.table.addTableColumn(c);
        this.model = new ListDataSource(){

            public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                return null;
            }

            public NSInteger numberOfRowsInTableView(NSTableView view) {
                return new NSInteger((long)ActivityController.this.tasks.size());
            }
        };
        this.table.setDataSource(this.model.id());
        this.delegate = new AbstractTableDelegate<TaskController, ActivityColumn>(table.tableColumnWithIdentifier("Default")){

            public void enterKeyPressed(ID sender) {
            }

            public void deleteKeyPressed(ID sender) {
            }

            public String tooltip(TaskController c, ActivityColumn column) {
                return null;
            }

            public boolean tableView_shouldSelectRow(NSTableView view, NSInteger row) {
                return false;
            }

            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            public void tableRowDoubleClicked(ID sender) {
            }

            public void selectionDidChange(NSNotification notification) {
            }

            protected boolean isTypeSelectSupported() {
                return false;
            }

            public NSView tableView_viewForTableColumn_row(NSTableView view, NSTableColumn column, NSInteger row) {
                TaskController controller = ActivityController.this.getController(row);
                return controller.view();
            }
        };
        this.table.setDelegate(this.delegate.id());
        this.table.sizeToFit();
    }

    protected TaskController getController(NSInteger row) {
        return this.tasks.values().toArray(new TaskController[this.tasks.size()])[row.intValue()];
    }

    protected String getBundleName() {
        return "Activity";
    }

    private static enum ActivityColumn {
        single;

    }
}

