/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.callback;

import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.ui.cocoa.controller.PasswordController;

public class PromptPasswordCallback
implements PasswordCallback {
    private final WindowController parent;
    private PasswordController controller;
    private boolean suppressed;

    public PromptPasswordCallback(WindowController parent) {
        this.parent = parent;
    }

    public void close(String input) {
        if (null == this.controller) {
            return;
        }
        this.controller.setPasswordFieldText(input);
        this.controller.passwordFieldTextDidChange(NSNotification.notificationWithName((String)"NSControlTextDidChangeNotification", (String)input));
        this.controller.closeSheetWithOption(0);
    }

    public Credentials prompt(Host bookmark, String title, String reason, LoginOptions options) throws LoginCanceledException {
        if (this.suppressed) {
            throw new LoginCanceledException();
        }
        Credentials credentials = new Credentials().withSaved(options.keychain);
        this.controller = new PasswordController(bookmark, credentials, title, reason, options);
        int option = this.controller.beginSheet(this.parent);
        if (option == -1) {
            if (this.controller.isSuppressed()) {
                this.suppressed = true;
            }
            throw new LoginCanceledException();
        }
        return credentials;
    }
}

