/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.callback;

import ch.cyberduck.binding.DisabledSheetCallback;
import ch.cyberduck.binding.SheetInvoker;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.FoundationKitFunctions;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.core.CertificateIdentityCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.KeychainCertificateStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.keychain.SFChooseIdentityPanel;
import ch.cyberduck.core.keychain.SecIdentityRef;
import ch.cyberduck.core.keychain.SecPolicyRef;
import ch.cyberduck.core.keychain.SecurityFunctions;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import com.sun.jna.platform.mac.CoreFoundation;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;

public class PromptCertificateIdentityCallback
implements CertificateIdentityCallback {
    private static final Logger log = LogManager.getLogger(PromptCertificateIdentityCallback.class);
    private final Controller controller;

    public PromptCertificateIdentityCallback(Controller controller) {
        this.controller = controller;
    }

    public X509Certificate prompt(String hostname, List<X509Certificate> certificates) throws ConnectionCanceledException {
        final AtomicReference ref = new AtomicReference();
        this.controller.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                ref.set(SFChooseIdentityPanel.sharedChooseIdentityPanel());
            }
        }, true);
        SFChooseIdentityPanel panel = (SFChooseIdentityPanel)ref.get();
        panel.setDomain(hostname);
        SecPolicyRef policyRef = SecurityFunctions.library.SecPolicyCreateSSL(true, hostname);
        panel.setPolicies(policyRef);
        FoundationKitFunctions.library.CFRelease((CoreFoundation.CFTypeRef)policyRef);
        panel.setShowsHelp(false);
        panel.setAlternateButtonTitle(LocaleFactory.localizedString((String)"Disconnect"));
        panel.setInformativeText(MessageFormat.format(LocaleFactory.localizedString((String)"The server requires a certificate to validate your identity. Select the certificate to authenticate yourself to {0}."), hostname));
        NSArray identities = KeychainCertificateStore.toDEREncodedCertificates(certificates);
        int option = this.prompt(panel, identities);
        switch (option) {
            case 1: {
                SecIdentityRef identityRef = panel.identity();
                if (null == identityRef) {
                    log.warn(String.format("No identity selected for %s", hostname));
                    throw new ConnectionCanceledException();
                }
                return KeychainCertificateStore.toX509Certificate((SecIdentityRef)identityRef);
            }
        }
        throw new ConnectionCanceledException();
    }

    protected int prompt(final SFChooseIdentityPanel panel, final NSArray identities) {
        return new SheetInvoker((SheetCallback)new DisabledSheetCallback(), ((WindowController)this.controller).window(), (NSWindow)panel){

            protected void beginSheet(NSWindow sheet) {
                panel.beginSheetForWindow_modalDelegate_didEndSelector_contextInfo_identities_message(((WindowController)PromptCertificateIdentityCallback.this.controller).window(), this.id(), Foundation.selector((String)"sheetDidClose:returnCode:contextInfo:"), null, identities, null);
            }
        }.beginSheet();
    }
}

