/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.callback;

import ch.cyberduck.binding.WindowController;
import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.diagnostics.ReachabilityFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.notification.NotificationAlertCallback;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.FailureDiagnostics;
import ch.cyberduck.ui.cocoa.controller.BackgroundExceptionAlertController;

public class PromptAlertCallback
implements AlertCallback {
    private final WindowController parent;
    private final NotificationAlertCallback notification = new NotificationAlertCallback();

    public PromptAlertCallback(WindowController parent) {
        this.parent = parent;
    }

    public boolean alert(Host host, BackgroundException failure, StringBuilder transcript) {
        FailureDiagnostics.Type type = new DefaultFailureDiagnostics().determine(failure);
        switch (type) {
            case cancel: 
            case skip: {
                return false;
            }
        }
        this.notification.alert(host, failure, transcript);
        BackgroundExceptionAlertController alert = new BackgroundExceptionAlertController(failure, host);
        switch (alert.beginSheet(this.parent)) {
            case 0: {
                switch (type) {
                    case network: {
                        ReachabilityFactory.get().diagnose(host);
                        break;
                    }
                    case quota: {
                        BrowserLauncherFactory.get().open(new DefaultProviderHelpService().help(host.getProtocol()));
                    }
                }
                break;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }
}

