/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.security.Principal;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.UidPrincipal;

public class Subjects {
    public static final Subject ROOT = new Subject();
    public static final Subject NOBODY;

    public static boolean isRoot(Subject subject) {
        return Subjects.hasUid(subject, 0L);
    }

    public static boolean isNobody(Subject subject) {
        for (Principal principal : subject.getPrincipals()) {
            if (!(principal instanceof UidPrincipal)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasUid(Subject subject, long uid) {
        Set<UidPrincipal> principals = subject.getPrincipals(UidPrincipal.class);
        for (UidPrincipal principal : principals) {
            if (principal.getUid() != uid) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGid(Subject subject, long gid) {
        Set<GidPrincipal> principals = subject.getPrincipals(GidPrincipal.class);
        for (GidPrincipal principal : principals) {
            if (principal.getGid() != gid) continue;
            return true;
        }
        return false;
    }

    public static long[] getUids(Subject subject) {
        Set<UidPrincipal> principals = subject.getPrincipals(UidPrincipal.class);
        long[] uids = new long[principals.size()];
        int i = 0;
        for (UidPrincipal principal : principals) {
            uids[i++] = principal.getUid();
        }
        return uids;
    }

    private static <T> T getUniquePrincipal(Subject subject, Class<T> type) throws IllegalArgumentException {
        T result = null;
        if (subject == null) {
            return null;
        }
        for (Principal principal : subject.getPrincipals()) {
            if (!type.isInstance(principal)) continue;
            if (result != null) {
                throw new IllegalArgumentException("Subject has multiple principals of type " + type.getSimpleName());
            }
            result = type.cast(principal);
        }
        return result;
    }

    public static long getUid(Subject subject) throws IllegalArgumentException {
        UidPrincipal uid = Subjects.getUniquePrincipal(subject, UidPrincipal.class);
        if (uid == null) {
            return -1L;
        }
        return uid.getUid();
    }

    public static long[] getGids(Subject subject) {
        Set<GidPrincipal> principals = subject.getPrincipals(GidPrincipal.class);
        long[] gids = new long[principals.size()];
        int i = 0;
        for (GidPrincipal principal : principals) {
            if (principal.isPrimaryGroup()) {
                gids[i++] = gids[0];
                gids[0] = principal.getGid();
                continue;
            }
            gids[i++] = principal.getGid();
        }
        return gids;
    }

    public static long getPrimaryGid(Subject subject) throws NoSuchElementException, IllegalArgumentException {
        Set<GidPrincipal> principals = subject.getPrincipals(GidPrincipal.class);
        int counter = 0;
        long gid = 0L;
        for (GidPrincipal principal : principals) {
            if (!principal.isPrimaryGroup()) continue;
            gid = principal.getGid();
            ++counter;
        }
        if (counter == 0) {
            throw new NoSuchElementException("Subject has no primary GID");
        }
        if (counter > 1) {
            throw new IllegalArgumentException("Subject has multiple primary GIDs");
        }
        return gid;
    }

    public static Subject of(int uid, int gid, int ... gids) {
        Subject subject = new Subject();
        subject.getPrincipals().add(new UidPrincipal(uid));
        subject.getPrincipals().add(new GidPrincipal(gid, true));
        for (int g : gids) {
            subject.getPrincipals().add(new GidPrincipal(g, false));
        }
        return subject;
    }

    static {
        ROOT.getPrincipals().add(new UidPrincipal(0L));
        ROOT.getPrincipals().add(new GidPrincipal(0L, true));
        ROOT.setReadOnly();
        NOBODY = new Subject();
        NOBODY.setReadOnly();
    }
}

