/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallbackFactory;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.vault.LoadingVaultLookupListener;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.worker.LoadVaultWorker;
import ch.cyberduck.core.worker.LockVaultWorker;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemSelectionHandler;
import ch.iterate.mountainduck.service.InvalidatingReloadService;
import ch.iterate.mountainduck.service.VaultService;
import ch.iterate.mountainduck.service.VaultServiceFactory;
import ch.iterate.mountainduck.service.WindowAwareService;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VaultMenuItemBuilder
extends FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private static final Logger log = LogManager.getLogger((String)VaultMenuItemBuilder.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final VaultService vaultService = VaultServiceFactory.get();
    private final Controller controller;

    public VaultMenuItemBuilder(Controller controller) {
        this.controller = controller;
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        String icon;
        ContextMenuItem filesystemMenuItem;
        Object fs;
        for (Filesystem fs2 : filesystems.keySet()) {
            if (new HostPreferences(fs2.getHost()).getBoolean("cryptomator.enable")) continue;
            return Collections.emptyList();
        }
        ContextMenuItem main = new ContextMenuItem(LocaleFactory.localizedString((String)"Cryptomator", (String)"Preferences"));
        if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.cryptomator.path"))) {
            main.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.cryptomator.path"));
        }
        if (this.preferences.getBoolean("nativity.contextmenu.cryptomator.new.enable")) {
            ContextMenuItem createVault = new ContextMenuItem(LocaleFactory.localizedString((String)"New Encrypted Vault\u2026", (String)"Main"));
            for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
                if (filesystems.size() == 1) {
                    this.attach(entry, this.validateCreateVaultMenu(entry.getKey(), createVault, entry.getValue()), new CreateVaultMenuItemSelectionHandler());
                    continue;
                }
                fs = entry.getKey();
                filesystemMenuItem = this.validateCreateVaultMenu((Filesystem)fs, new ContextMenuItem(BookmarkNameProvider.toString((Host)fs.getHost())), entry.getValue());
                icon = fs.getHost().getProtocol().icon();
                if (StringUtils.isNotBlank((CharSequence)icon)) {
                    filesystemMenuItem.setIconPath(icon);
                }
                createVault.addContextMenuItem(this.attach(entry, filesystemMenuItem, new CreateVaultMenuItemSelectionHandler()));
            }
            main.addContextMenuItem(createVault);
        }
        ContextMenuItem lockVault = new ContextMenuItem(LocaleFactory.localizedString((String)"Lock Vault", (String)"Cryptomator"));
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            if (StringUtils.isNotBlank((CharSequence)entry.getKey().getHost().getProperty("cryptomator.vault.name.default"))) {
                for (FilesystemEntry f : entry.getValue()) {
                    if (StringUtils.equals((CharSequence)entry.getKey().getHost().getProperty("cryptomator.vault.name.default"), (CharSequence)f.remote.getName())) continue;
                    return Collections.emptyList();
                }
            }
            if (filesystems.size() == 1) {
                this.attach(entry, this.validateLockMenuItem(entry.getKey(), lockVault, entry.getValue()), new LockVaultMenuItemSelectionHandler());
                continue;
            }
            fs = entry.getKey();
            filesystemMenuItem = this.validateLockMenuItem((Filesystem)fs, new ContextMenuItem(BookmarkNameProvider.toString((Host)fs.getHost())), entry.getValue());
            icon = fs.getHost().getProtocol().icon();
            if (StringUtils.isNotBlank((CharSequence)icon)) {
                filesystemMenuItem.setIconPath(icon);
            }
            lockVault.addContextMenuItem(this.attach(entry, filesystemMenuItem, new LockVaultMenuItemSelectionHandler()));
        }
        main.addContextMenuItem(lockVault);
        ContextMenuItem unlockVault = new ContextMenuItem(LocaleFactory.localizedString((String)"Unlock Vault", (String)"Cryptomator"));
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            if (filesystems.size() == 1) {
                this.attach(entry, this.validateUnlockMenu(entry.getKey(), unlockVault, entry.getValue()), new UnlockVaultMenuItemSelectionHandler());
                continue;
            }
            Filesystem fs3 = entry.getKey();
            ContextMenuItem filesystemMenuItem2 = this.validateUnlockMenu(fs3, new ContextMenuItem(BookmarkNameProvider.toString((Host)fs3.getHost())), entry.getValue());
            String icon2 = fs3.getHost().getProtocol().icon();
            if (StringUtils.isNotBlank((CharSequence)icon2)) {
                filesystemMenuItem2.setIconPath(icon2);
            }
            unlockVault.addContextMenuItem(this.attach(entry, filesystemMenuItem2, new UnlockVaultMenuItemSelectionHandler()));
        }
        main.addContextMenuItem(unlockVault);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add menu %s", main));
        }
        return Collections.singletonList(main);
    }

    @Override
    public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
    }

    private ContextMenuItem validateCreateVaultMenu(Filesystem fs, ContextMenuItem menu, List<FilesystemEntry> selected) {
        for (FilesystemEntry f : selected) {
            VaultRegistry registry = fs.getVault();
            if (!registry.contains(f.remote)) continue;
            menu.setEnabled(false);
            break;
        }
        return menu;
    }

    private ContextMenuItem validateLockMenuItem(Filesystem fs, ContextMenuItem menu, List<FilesystemEntry> list) {
        for (FilesystemEntry selected : list) {
            VaultRegistry registry = fs.getVault();
            if (registry.contains(selected.remote)) continue;
            if (log.isDebugEnabled()) {
                log.debug(String.format("No vault registered for file %s", selected.remote));
            }
            menu.setEnabled(false);
            break;
        }
        return menu;
    }

    private ContextMenuItem validateUnlockMenu(Filesystem fs, ContextMenuItem menu, List<FilesystemEntry> list) {
        menu.setEnabled(false);
        for (FilesystemEntry selected : list) {
            VaultRegistry registry;
            if (!selected.remote.isDirectory() || (registry = fs.getVault()).contains(selected.remote)) continue;
            String filename = new HostPreferences(fs.getHost()).getProperty("cryptomator.vault.masterkey.filename");
            try {
                Path key = fs.getOperations().find(selected.remote, filename, FilesystemCallbacks.Flags.offline);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Found vault key file %s", key));
                }
                menu.setEnabled(null != key);
                break;
            }
            catch (BackgroundException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("No %s found in %s", filename, selected.remote));
            }
        }
        return menu;
    }

    private class CreateVaultMenuItemSelectionHandler
    implements MenuItemSelectionHandler {
        private CreateVaultMenuItemSelectionHandler() {
        }

        @Override
        public void selected(final Filesystem fs, Object window, List<FilesystemEntry> list) {
            block1: {
                WindowAwareService.setWindow((Object)VaultMenuItemBuilder.this.vaultService, (Object)window);
                Iterator<FilesystemEntry> iterator = list.iterator();
                if (!iterator.hasNext()) break block1;
                final FilesystemEntry selected = iterator.next();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Create new vault in %s", selected));
                }
                VaultMenuItemBuilder.this.vaultService.create(VaultMenuItemBuilder.this.controller, fs, selected.remote.isDirectory() ? selected.remote : selected.remote.getParent(), new VaultService.Callback(){

                    public void done(Path vault) {
                        new InvalidatingReloadService(fs).reload(selected.remote, selected.local);
                    }
                });
            }
        }
    }

    private class LockVaultMenuItemSelectionHandler
    implements MenuItemSelectionHandler {
        private LockVaultMenuItemSelectionHandler() {
        }

        @Override
        public void selected(final Filesystem fs, Object window, final List<FilesystemEntry> list) {
            for (final FilesystemEntry selected : list) {
                if (selected.remote.attributes().getVault() == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Lock vault in %s", selected));
                }
                VaultMenuItemBuilder.this.controller.background((BackgroundAction)new WorkerBackgroundAction(VaultMenuItemBuilder.this.controller, (SessionPool)fs.getPool(), (Worker)new LockVaultWorker(fs.getVault(), selected.remote.attributes().getVault()){

                    public void cleanup(Path vault) {
                        fs.getCache().swap(selected.remote, vault);
                        for (FilesystemEntry selected2 : list) {
                            new InvalidatingReloadService(fs).reload(selected2.remote, selected2.local);
                        }
                    }
                }));
            }
        }
    }

    private class UnlockVaultMenuItemSelectionHandler
    implements MenuItemSelectionHandler {
        private UnlockVaultMenuItemSelectionHandler() {
        }

        @Override
        public void selected(final Filesystem fs, Object window, final List<FilesystemEntry> list) {
            for (final FilesystemEntry selected : list) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Unlock vault in %s", selected));
                }
                VaultMenuItemBuilder.this.controller.background((BackgroundAction)new WorkerBackgroundAction(VaultMenuItemBuilder.this.controller, (SessionPool)fs.getPool(), (Worker)new LoadVaultWorker((VaultLookupListener)new LoadingVaultLookupListener(fs.getVault(), (PasswordStore)PasswordStoreFactory.get(), PasswordCallbackFactory.get((Controller)VaultMenuItemBuilder.this.controller)), selected.remote){

                    public void cleanup(Vault vault) {
                        fs.getCache().swap(selected.remote, vault.getHome());
                        for (FilesystemEntry selected2 : list) {
                            new InvalidatingReloadService(fs).reload(selected2.remote, selected2.local);
                        }
                    }
                }));
            }
        }
    }
}

