/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.BrowserLauncher;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.CustomSchemeUrlProvider;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import ch.iterate.mountainduck.service.PasteboardService;
import ch.iterate.mountainduck.service.PasteboardServiceFactory;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuAction;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UrlMenuItemBuilder
extends FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private static final Logger log = LogManager.getLogger((String)UrlMenuItemBuilder.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final BrowserLauncher browserLauncher;
    private final PasteboardService pasteboardService;

    public UrlMenuItemBuilder() {
        this(BrowserLauncherFactory.get(), PasteboardServiceFactory.get());
    }

    public UrlMenuItemBuilder(BrowserLauncher browserLauncher, PasteboardService pasteboardService) {
        this.browserLauncher = browserLauncher;
        this.pasteboardService = pasteboardService;
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        ContextMenuItem copyUrlMenu = new ContextMenuItem(LocaleFactory.localizedString((String)"Copy URL", (String)"Main"));
        if (StringUtils.isNotBlank((CharSequence)PreferencesFactory.get().getProperty("nativity.contextmenu.icon.url.copy.path"))) {
            copyUrlMenu.setIconPath(PreferencesFactory.get().getProperty("nativity.contextmenu.icon.url.copy.path"));
        }
        ContextMenuItem openUrlMenu = new ContextMenuItem(LocaleFactory.localizedString((String)"Open URL", (String)"Main"));
        if (StringUtils.isNotBlank((CharSequence)PreferencesFactory.get().getProperty("nativity.contextmenu.icon.url.open.path"))) {
            openUrlMenu.setIconPath(PreferencesFactory.get().getProperty("nativity.contextmenu.icon.url.open.path"));
        }
        DescriptiveUrlBag urls = new DescriptiveUrlBag();
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            Filesystem fs = entry.getKey();
            UrlProvider provider = (UrlProvider)fs.getFeature(UrlProvider.class);
            List<FilesystemEntry> files = entry.getValue();
            for (FilesystemEntry file : files) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add URLs to menu for file %s", file));
                }
                DescriptiveUrlBag list = provider.toUrl(file.remote);
                if (this.preferences.getBoolean("nativity.contextmenu.url.schemes.enable")) {
                    list.addAll((Collection)new CustomSchemeUrlProvider(fs.getHost()).toUrl(file.remote));
                }
                if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.url.filter"))) {
                    urls.addAll((Collection)list.filter(new DescriptiveUrl.Type[]{DescriptiveUrl.Type.valueOf((String)this.preferences.getProperty("nativity.contextmenu.url.filter"))}));
                    continue;
                }
                urls.addAll((Collection)list);
            }
        }
        if (urls.isEmpty()) {
            copyUrlMenu.setEnabled(false);
            openUrlMenu.setEnabled(false);
        } else {
            this.add(copyUrlMenu, urls, Type.copy);
            this.add(openUrlMenu, urls, Type.open);
        }
        return Arrays.asList(copyUrlMenu, openUrlMenu);
    }

    private void add(ContextMenuItem menu, DescriptiveUrlBag urls, Type type) {
        Map<String, List<DescriptiveUrl>> collected = urls.stream().collect(Collectors.groupingBy(DescriptiveUrl::getHelp));
        if (collected.keySet().size() == 1) {
            for (List<DescriptiveUrl> list : collected.values()) {
                Iterator<DescriptiveUrl> iterator;
                if (list.size() != 1 || !(iterator = list.iterator()).hasNext()) continue;
                DescriptiveUrl url = iterator.next();
                switch (type) {
                    case copy: {
                        menu.setContextMenuAction((ContextMenuAction)new CopyContextMenuAction(new DescriptiveUrlBag(Collections.singletonList(url))));
                        break;
                    }
                    case open: {
                        menu.setContextMenuAction((ContextMenuAction)new OpenContextMenuAction(new DescriptiveUrlBag(Collections.singletonList(url))));
                    }
                }
                return;
            }
        }
        for (Map.Entry group : collected.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
            ContextMenuItem headerItem = new ContextMenuItem((String)group.getKey());
            switch (type) {
                case copy: {
                    if (StringUtils.isNotBlank((CharSequence)PreferencesFactory.get().getProperty("nativity.contextmenu.icon.url.copy.path"))) {
                        headerItem.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.url.copy.path"));
                    }
                    headerItem.setContextMenuAction((ContextMenuAction)new CopyContextMenuAction(new DescriptiveUrlBag((Collection)group.getValue())));
                    break;
                }
                case open: {
                    if (StringUtils.isNotBlank((CharSequence)PreferencesFactory.get().getProperty("nativity.contextmenu.icon.url.open.path"))) {
                        headerItem.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.url.open.path"));
                    }
                    headerItem.setContextMenuAction((ContextMenuAction)new OpenContextMenuAction(new DescriptiveUrlBag((Collection)group.getValue())));
                }
            }
            menu.addContextMenuItem(headerItem);
            for (DescriptiveUrl url : (List)group.getValue()) {
                ContextMenuItem item = new ContextMenuItem(StringUtils.abbreviateMiddle((String)url.getUrl(), (String)"\u2026", (int)80));
                item.setEnabled(false);
                item.setHelpText(url.getHelp());
                menu.addContextMenuItem(item);
            }
        }
    }

    @Override
    public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
    }

    private static enum Type {
        copy,
        open;

    }

    private final class CopyContextMenuAction
    implements ContextMenuAction {
        private final DescriptiveUrlBag urls;

        public CopyContextMenuAction(DescriptiveUrlBag urls) {
            this.urls = urls;
        }

        public void onSelection(String[] paths, Object window) {
            StringBuilder text = new StringBuilder();
            Iterator iter = this.urls.iterator();
            while (iter.hasNext()) {
                text.append(((DescriptiveUrl)iter.next()).getUrl());
                if (!iter.hasNext()) continue;
                text.append(System.getProperty("line.separator"));
            }
            try {
                UrlMenuItemBuilder.this.pasteboardService.add(PasteboardService.Type.url, text.toString());
            }
            catch (LocalAccessDeniedException e) {
                log.warn(String.format("Failure %s adding url %s to pasteboard", new Object[]{e, text}));
            }
        }
    }

    private final class OpenContextMenuAction
    implements ContextMenuAction {
        private final DescriptiveUrlBag urls;

        public OpenContextMenuAction(DescriptiveUrlBag urls) {
            this.urls = urls;
        }

        public void onSelection(String[] paths, Object window) {
            for (DescriptiveUrl url : this.urls) {
                UrlMenuItemBuilder.this.browserLauncher.open(url.getUrl());
            }
        }
    }
}

