/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.TerminalService;
import ch.cyberduck.core.TerminalServiceFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TerminalMenuItemBuilder
extends FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private static final Logger log = LogManager.getLogger((String)TerminalMenuItemBuilder.class.getName());
    private final TerminalService terminalService;

    public TerminalMenuItemBuilder() {
        this(TerminalServiceFactory.get());
    }

    public TerminalMenuItemBuilder(TerminalService terminal) {
        this.terminalService = terminal;
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        ContextMenuItem main = new ContextMenuItem(LocaleFactory.localizedString((String)"Open in Terminal", (String)"Main"));
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            Filesystem fs = entry.getKey();
            switch (fs.getHost().getProtocol().getType()) {
                case sftp: {
                    if (filesystems.size() == 1) {
                        return Collections.singletonList(this.attach(entry, main));
                    }
                    ContextMenuItem filesystemMenuItem = new ContextMenuItem(BookmarkNameProvider.toString((Host)fs.getHost()));
                    String icon = fs.getHost().getProtocol().icon();
                    if (StringUtils.isNotBlank((CharSequence)icon)) {
                        filesystemMenuItem.setIconPath(icon);
                    }
                    main.addContextMenuItem(this.attach(entry, filesystemMenuItem));
                }
            }
        }
        if (main.getContextMenuItems().isEmpty()) {
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add menu %s", main));
        }
        return Collections.singletonList(main);
    }

    @Override
    public void selected(Filesystem fs, Object window, List<FilesystemEntry> selected) {
        block3: {
            Iterator<FilesystemEntry> iterator = selected.iterator();
            if (!iterator.hasNext()) break block3;
            FilesystemEntry entry = iterator.next();
            try {
                if (entry.remote.isDirectory()) {
                    this.terminalService.open(fs.getHost(), entry.remote);
                    break block3;
                }
                this.terminalService.open(fs.getHost(), entry.remote.getParent());
            }
            catch (BackgroundException e) {
                log.warn(String.format("Failure %s opening Terminal for file %s", new Object[]{e, entry}));
            }
        }
    }
}

