/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.ConnectMode;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.badge.FileOverlayIconService;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemContextMenuAction;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemSelectionHandler;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.SerializableOperationException;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuAction;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncMenuItemBuilder
extends FilesystemMenuItemBuilder {
    private static final Logger log = LogManager.getLogger((String)SyncMenuItemBuilder.class.getName());
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
        Iterator<Map.Entry<Filesystem, List<FilesystemEntry>>> iterator = filesystems.entrySet().iterator();
        if (iterator.hasNext()) {
            FileOverlayIconService.Badge status;
            Map.Entry<Filesystem, List<FilesystemEntry>> entry = iterator.next();
            Filesystem fs = entry.getKey();
            List<FilesystemEntry> files = entry.getValue();
            ContextMenuItem offlineItem = new ContextMenuItem(LocaleFactory.localizedString((String)"Keep Offline on Local Disk", (String)"Disk"));
            if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.sync.path"))) {
                offlineItem.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.sync.path"));
            }
            offlineItem.setHelpText(LocaleFactory.localizedString((String)"Keep offline copy and upload changes when server is reachable.", (String)"Disk"));
            offlineItem.setEnabled(fs.getMode() == ConnectMode.selective);
            for (FilesystemEntry file : files) {
                FileOverlayIconService.Badge status2 = fs.getBadge(file.remote);
                switch (status2) {
                    case synced: 
                    case ignored: {
                        offlineItem.setEnabled(false);
                    }
                }
            }
            offlineItem.setContextMenuAction((ContextMenuAction)new FilesystemContextMenuAction(new MenuItemSelectionHandler(){

                @Override
                public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
                    DirectoryIndexer indexer = fs.getIndexer();
                    for (FilesystemEntry entry : list) {
                        indexer.cache(entry.remote, DirectoryIndexer.NO_CALLBACK);
                    }
                }
            }, fs, entry));
            items.add(offlineItem);
            ContextMenuItem deleteItem = new ContextMenuItem(LocaleFactory.localizedString((String)"Delete on Local Disk", (String)"Disk"));
            if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.online.path"))) {
                deleteItem.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.online.path"));
            }
            deleteItem.setHelpText(LocaleFactory.localizedString((String)"Delete copy on disk and download files on demand when opened.", (String)"Disk"));
            deleteItem.setEnabled(fs.getMode() == ConnectMode.selective);
            for (FilesystemEntry file : files) {
                if (!file.remote.isFile()) continue;
                status = fs.getBadge(file.remote);
                switch (status) {
                    case ignored: 
                    case online: 
                    case error: {
                        deleteItem.setEnabled(false);
                    }
                }
            }
            deleteItem.setContextMenuAction((ContextMenuAction)new FilesystemContextMenuAction(new MenuItemSelectionHandler(){

                @Override
                public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
                    DirectoryIndexer indexer = fs.getIndexer();
                    for (FilesystemEntry entry : list) {
                        indexer.purge(entry.remote);
                    }
                }
            }, fs, entry));
            items.add(deleteItem);
            for (FilesystemEntry file : files) {
                status = fs.getStatus(file.remote);
                if (status.getState() != FileStatusService.SyncState.error) continue;
                final Set exceptions = status.getExceptions();
                ContextMenuItem errorRetry = new ContextMenuItem(LocaleFactory.localizedString((String)"Retry", (String)"Disk"));
                errorRetry.setHelpText(LocaleFactory.localizedString((String)"Retry failed sync operation.", (String)"Disk"));
                errorRetry.setEnabled(true);
                errorRetry.setContextMenuAction((ContextMenuAction)new FilesystemContextMenuAction(new MenuItemSelectionHandler(){

                    @Override
                    public void selected(Filesystem fs, Object window, List<FilesystemEntry> list_) {
                        for (SerializableOperationException exception : exceptions) {
                            SerializableOperation operation = exception.getOperation();
                            SyncQueue queue = fs.getQueue();
                            switch (queue.getStatus()) {
                                case paused: {
                                    queue.resume();
                                }
                            }
                            if (log.isInfoEnabled()) {
                                log.info(String.format("Resubmit failed operation %s to queue %s", operation, queue));
                            }
                            queue.submit(operation);
                        }
                    }
                }, fs, entry));
                items.add(errorRetry);
                for (SerializableOperationException failure : exceptions) {
                    ContextMenuItem errorDescription = new ContextMenuItem(String.format("\u2022 %s. %s", StringUtils.removeEnd((String)failure.getMessage(), (String)"."), StringUtils.removeEnd((String)failure.getDetail(false), (String)".")));
                    errorDescription.setEnabled(false);
                    items.add(errorDescription);
                }
            }
        }
        return items;
    }
}

