/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import ch.iterate.mountainduck.service.ShareProviderService;
import ch.iterate.mountainduck.service.ShareProviderServiceFactory;
import ch.iterate.mountainduck.service.WindowAwareService;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ShareMenuItemBuilder
extends FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private final Preferences preferences = PreferencesFactory.get();
    private final Controller controller;

    public ShareMenuItemBuilder(Controller controller) {
        this.controller = controller;
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        ContextMenuItem main = new ContextMenuItem(LocaleFactory.localizedString((String)"Share\u2026", (String)"Main"));
        if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.share.path"))) {
            main.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.share.path"));
        }
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            FilesystemEntry file;
            Filesystem fs = entry.getKey();
            if (null == fs.getFeature(PromptUrlProvider.class)) continue;
            List<FilesystemEntry> entries = entry.getValue();
            Iterator<FilesystemEntry> iterator = entries.iterator();
            while (iterator.hasNext()) {
                file = iterator.next();
                if (((PromptUrlProvider)fs.getFeature(PromptUrlProvider.class)).isSupported(file.remote, PromptUrlProvider.Type.download)) continue;
                main.setEnabled(false);
                return Collections.singletonList(main);
            }
            if (entries.size() == 1 && (iterator = entries.iterator()).hasNext()) {
                file = iterator.next();
                main.setTitle(LocaleFactory.localizedString((String)"Share\u2026", (String)"Main"));
                ContextMenuItem item = this.attach(entry, main);
                switch (fs.getStatus(file.remote).getState()) {
                    case ignored: 
                    case local: 
                    case inprogress: {
                        item.setEnabled(false);
                    }
                }
                return Collections.singletonList(item);
            }
            ContextMenuItem filesystemMenuItem = new ContextMenuItem(BookmarkNameProvider.toString((Host)fs.getHost()));
            String icon = fs.getHost().getProtocol().icon();
            if (StringUtils.isNotBlank((CharSequence)icon)) {
                filesystemMenuItem.setIconPath(icon);
            }
            main.addContextMenuItem(this.attach(entry, filesystemMenuItem));
        }
        if (main.getContextMenuItems().isEmpty()) {
            main.setEnabled(false);
        }
        return Collections.singletonList(main);
    }

    @Override
    public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
        block0: {
            Iterator<FilesystemEntry> iterator = list.iterator();
            if (!iterator.hasNext()) break block0;
            FilesystemEntry entry = iterator.next();
            ShareProviderService service = ShareProviderServiceFactory.get((Protocol)fs.getHost().getProtocol());
            WindowAwareService.setWindow((Object)service, (Object)window);
            service.download(this.controller, fs, entry.remote);
        }
    }
}

