/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.features.Restore;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.worker.RestoreWorker;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestoreMenuItemBuilder
extends FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private static final Logger log = LogManager.getLogger((String)RestoreMenuItemBuilder.class.getName());
    private final Controller controller;
    private final Preferences preferences = PreferencesFactory.get();

    public RestoreMenuItemBuilder(Controller controller) {
        this.controller = controller;
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        ContextMenuItem main = new ContextMenuItem(LocaleFactory.localizedString((String)"Restore", (String)"Main"));
        if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.info.path"))) {
            main.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.info.path"));
        }
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            Filesystem fs = entry.getKey();
            if (null == fs.getFeature(Restore.class)) continue;
            for (FilesystemEntry file : entry.getValue()) {
                if (((Restore)fs.getFeature(Restore.class)).isRestorable(file.remote)) continue;
                main.setEnabled(false);
                return Collections.singletonList(main);
            }
            if (filesystems.size() == 1) {
                return Collections.singletonList(this.attach(entry, main));
            }
            ContextMenuItem filesystemMenuItem = new ContextMenuItem(BookmarkNameProvider.toString((Host)fs.getHost()));
            String icon = fs.getHost().getProtocol().icon();
            if (StringUtils.isNotBlank((CharSequence)icon)) {
                filesystemMenuItem.setIconPath(icon);
            }
            main.addContextMenuItem(this.attach(entry, filesystemMenuItem));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add menu %s", main));
        }
        return Collections.singletonList(main);
    }

    @Override
    public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
        ArrayList<Path> selected = new ArrayList<Path>();
        for (FilesystemEntry entry : list) {
            selected.add(entry.remote);
        }
        this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, (SessionPool)fs.getPool(), (Worker)new RestoreWorker(LoginCallbackFactory.get((Controller)this.controller), selected)));
    }
}

