/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.PathFilenameComposer;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import ch.iterate.mountainduck.service.InvalidatingReloadService;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReloadMenuItemBuilder
extends FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private static final Logger log = LogManager.getLogger((String)ReloadMenuItemBuilder.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final NativityControl control;

    public ReloadMenuItemBuilder(NativityControl control) {
        this.control = control;
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        ContextMenuItem main = new ContextMenuItem(LocaleFactory.localizedString((String)"Reload", (String)"Localizable"));
        if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.reload.path"))) {
            main.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.reload.path"));
        }
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            if (filesystems.size() == 1) {
                return Collections.singletonList(this.attach(entry, main));
            }
            Filesystem fs = entry.getKey();
            ContextMenuItem filesystemMenuItem = new ContextMenuItem(BookmarkNameProvider.toString((Host)fs.getHost()));
            String icon = fs.getHost().getProtocol().icon();
            if (StringUtils.isNotBlank((CharSequence)icon)) {
                filesystemMenuItem.setIconPath(icon);
            }
            this.attach(entry, filesystemMenuItem);
            main.addContextMenuItem(filesystemMenuItem);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add menu %s", main));
        }
        if (main.getContextMenuItems().isEmpty()) {
            main.setEnabled(false);
        }
        return Collections.singletonList(main);
    }

    @Override
    public void selected(Filesystem fs, Object window, List<FilesystemEntry> selected) {
        DirectoryIndexer indexer = fs.getIndexer();
        switch (indexer.getStatus()) {
            case stopped: 
            case paused: {
                indexer.resume();
            }
        }
        InvalidatingReloadService reload = new InvalidatingReloadService(fs);
        for (FilesystemEntry entry : selected) {
            reload.reload(entry.remote, entry.local);
        }
        PathFilenameComposer composer = fs.getComposer();
        for (String folder : this.control.getAllObservedFolders()) {
            if (LocalFactory.get((String)folder).equals((Object)fs.getMountpoint())) {
                reload.reload(fs.getOperations().getWorkdir(), fs.getMountpoint());
                continue;
            }
            if (!LocalFactory.get((String)folder).isChild(fs.getMountpoint())) continue;
            Path remote = composer.compose(fs.getOperations().getWorkdir(), PathRelativizer.relativize((String)fs.getMountpoint().getAbsolute(), (String)folder), EnumSet.of(AbstractPath.Type.directory));
            reload.reload(remote, LocalFactory.get((String)folder));
        }
    }
}

