/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import ch.iterate.mountainduck.service.InfoService;
import ch.iterate.mountainduck.service.InfoServiceFactory;
import ch.iterate.mountainduck.service.InvalidatingReloadService;
import ch.iterate.mountainduck.service.WindowAwareService;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InfoMenuItemBuilder
extends FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private static final Logger log = LogManager.getLogger((String)InfoMenuItemBuilder.class.getName());
    private final Controller controller;
    private final InfoService info;
    private final Preferences preferences = PreferencesFactory.get();

    public InfoMenuItemBuilder(Controller controller) {
        this(controller, InfoServiceFactory.get());
    }

    public InfoMenuItemBuilder(Controller controller, InfoService service) {
        this.controller = controller;
        this.info = service;
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        ContextMenuItem main = new ContextMenuItem(LocaleFactory.localizedString((String)"Info", (String)"Main"));
        if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.info.path"))) {
            main.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.info.path"));
        }
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            if (filesystems.size() == 1) {
                return Collections.singletonList(this.attach(entry, main));
            }
            Filesystem fs = entry.getKey();
            ContextMenuItem filesystemMenuItem = new ContextMenuItem(BookmarkNameProvider.toString((Host)fs.getHost()));
            String icon = fs.getHost().getProtocol().icon();
            if (StringUtils.isNotBlank((CharSequence)icon)) {
                filesystemMenuItem.setIconPath(icon);
            }
            main.addContextMenuItem(this.attach(entry, filesystemMenuItem));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add menu %s", main));
        }
        return Collections.singletonList(main);
    }

    @Override
    public void selected(final Filesystem fs, Object window, final List<FilesystemEntry> list) {
        ArrayList<Path> selected = new ArrayList<Path>();
        for (FilesystemEntry entry : list) {
            selected.add(entry.remote);
        }
        WindowAwareService.setWindow((Object)this.info, (Object)window);
        this.info.open(this.controller, fs, selected, new InfoService.Reload(){

            public void reload(List<Path> files) {
                for (FilesystemEntry selected : list) {
                    new InvalidatingReloadService(fs).reload(selected.remote, selected.local);
                }
            }
        });
    }
}

