/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemContextMenuAction;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemSelectionHandler;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuAction;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private static final Logger log = LogManager.getLogger((String)FilesystemMenuItemBuilder.class.getName());

    protected ContextMenuItem attach(Map.Entry<Filesystem, List<FilesystemEntry>> entry, ContextMenuItem item) {
        return this.attach(entry, item, this);
    }

    protected ContextMenuItem attach(Map.Entry<Filesystem, List<FilesystemEntry>> entry, ContextMenuItem item, MenuItemSelectionHandler selection) {
        Filesystem fs = entry.getKey();
        item.setContextMenuAction((ContextMenuAction)new FilesystemContextMenuAction(selection, fs, entry));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add menu %s", item));
        }
        if (entry.getValue().isEmpty()) {
            item.setEnabled(false);
        }
        return item;
    }
}

