/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemSelectionHandler;
import ch.iterate.mountainduck.nativity.contextmenu.ReloadMenuItemBuilder;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemContextMenuAction
implements ContextMenuAction {
    private static final Logger log = LogManager.getLogger((String)ReloadMenuItemBuilder.class.getName());
    private final MenuItemSelectionHandler handler;
    private final Filesystem fs;
    private final Map.Entry<Filesystem, List<FilesystemEntry>> entry;

    public FilesystemContextMenuAction(MenuItemSelectionHandler handler, Filesystem fs, Map.Entry<Filesystem, List<FilesystemEntry>> entry) {
        this.handler = handler;
        this.fs = fs;
        this.entry = entry;
    }

    public void onSelection(String[] files, Object window) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Selected files %s for handler %s", Arrays.toString(files), this.handler));
        }
        this.handler.selected(this.fs, window, this.entry.getValue());
    }
}

