/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.CustomActions;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemSelectionHandler;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CustomActionMenuItemBuilder
extends FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private final Preferences preferences = PreferencesFactory.get();
    private final Controller controller;

    public CustomActionMenuItemBuilder(Controller controller) {
        this.controller = controller;
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            Filesystem fs = entry.getKey();
            CustomActions actions = (CustomActions)fs.getFeature(CustomActions.class);
            if (null == actions) continue;
            HashSet list = new HashSet();
            entry.getValue().forEach(item -> list.addAll(actions.list(item.remote)));
            if (filesystems.size() == 1) {
                for (CustomActions.Action action : list) {
                    ContextMenuItem menu = new ContextMenuItem(action.getTitle());
                    if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.customaction.path"))) {
                        menu.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.customaction.path"));
                    }
                    items.add(this.attach(entry, menu, new CustomActionContextMenuActionHandler(action)));
                }
                return items;
            }
            ContextMenuItem filesystemMenuItem = new ContextMenuItem(BookmarkNameProvider.toString((Host)fs.getHost()));
            String icon = fs.getHost().getProtocol().icon();
            if (StringUtils.isNotBlank((CharSequence)icon)) {
                filesystemMenuItem.setIconPath(icon);
            }
            for (CustomActions.Action action : list) {
                ContextMenuItem menu = new ContextMenuItem(action.getTitle());
                if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.customaction.path"))) {
                    menu.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.customaction.path"));
                }
                filesystemMenuItem.addContextMenuItem(this.attach(entry, menu, new CustomActionContextMenuActionHandler(action)));
            }
            items.add(filesystemMenuItem);
        }
        return items;
    }

    @Override
    public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
    }

    private final class CustomActionContextMenuActionHandler
    implements MenuItemSelectionHandler {
        private final CustomActions.Action action;

        public CustomActionContextMenuActionHandler(CustomActions.Action action) {
            this.action = action;
        }

        @Override
        public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
            for (final FilesystemEntry entry : list) {
                CustomActionMenuItemBuilder.this.controller.background((BackgroundAction)new WorkerBackgroundAction(CustomActionMenuItemBuilder.this.controller, (SessionPool)fs.getPool(), (Worker)new Worker<Void>(){

                    public Void run(Session<?> session) throws BackgroundException {
                        ((CustomActions)session.getFeature(CustomActions.class)).run(CustomActionContextMenuActionHandler.this.action, entry.remote);
                        return null;
                    }
                }));
            }
        }
    }
}

