/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity.contextmenu;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.HostDictionary;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.contextmenu.FilesystemMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BookmarkMenuItemBuilder
extends FilesystemMenuItemBuilder
implements MenuItemBuilder {
    private static final Logger log = LogManager.getLogger((String)BookmarkMenuItemBuilder.class.getName());
    private final AbstractHostCollection bookmarks;
    private final Preferences preferences = PreferencesFactory.get();

    public BookmarkMenuItemBuilder() {
        this((AbstractHostCollection)BookmarkCollection.defaultCollection());
    }

    public BookmarkMenuItemBuilder(AbstractHostCollection bookmarks) {
        this.bookmarks = bookmarks;
    }

    @Override
    public List<ContextMenuItem> build(Map<Filesystem, List<FilesystemEntry>> filesystems) {
        ContextMenuItem main = new ContextMenuItem(LocaleFactory.localizedString((String)"New Bookmark", (String)"Main"));
        if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty("nativity.contextmenu.icon.bookmark.path"))) {
            main.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.bookmark.path"));
        }
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : filesystems.entrySet()) {
            if (filesystems.size() == 1) {
                return Collections.singletonList(this.attach(entry, main));
            }
            Filesystem fs = entry.getKey();
            ContextMenuItem filesystemMenuItem = new ContextMenuItem(BookmarkNameProvider.toString((Host)fs.getHost()));
            filesystemMenuItem.setIconPath(fs.getHost().getProtocol().icon());
            main.addContextMenuItem(this.attach(entry, filesystemMenuItem));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add menu %s", main));
        }
        return Collections.singletonList(main);
    }

    @Override
    public void selected(Filesystem fs, Object window, List<FilesystemEntry> list) {
        block0: {
            Iterator<FilesystemEntry> iterator = list.iterator();
            if (!iterator.hasNext()) break block0;
            FilesystemEntry selected = iterator.next();
            Host bookmark = new HostDictionary().deserialize(fs.getHost().serialize(SerializerFactory.get()));
            bookmark.setUuid(null);
            bookmark.setNickname(null);
            bookmark.setDefaultPath(selected.remote.isDirectory() ? selected.remote.getAbsolute() : selected.remote.getParent().getAbsolute());
            this.bookmarks.add((Object)bookmark);
        }
    }
}

