/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity;

import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import ch.iterate.mountainduck.nativity.NativityService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NativityFilesystemMountListener
implements FilesystemMountRegistry.Listener {
    private static final Logger log = LogManager.getLogger((String)NativityFilesystemMountListener.class.getName());
    private final NativityService nativity;
    private final Callback callback;

    public NativityFilesystemMountListener(NativityService nativity) {
        this(nativity, new Callback(){

            @Override
            public void prompt() {
            }
        });
    }

    public NativityFilesystemMountListener(NativityService nativity, Callback callback) {
        this.nativity = nativity;
        this.callback = callback;
    }

    public void mounted(Filesystem fs) {
        try {
            switch (this.nativity.connect(fs)) {
                case connected: {
                    if (!log.isInfoEnabled()) break;
                    log.info("Successfully connected with extension");
                    break;
                }
                case disconnected: {
                    log.warn("No connection from extension");
                    this.callback.prompt();
                }
            }
        }
        catch (LocalAccessDeniedException e) {
            log.error(String.format("Failure %s initializing nativity integration for filesystem %s", new Object[]{e, fs}));
        }
    }

    public void unmounted(Filesystem fs) {
        try {
            log.warn(String.format("Disconnect nativity for filesystem %s", fs));
            this.nativity.disconnect(fs);
        }
        catch (LocalAccessDeniedException e) {
            log.warn(e.getMessage());
        }
    }

    public static interface Callback {
        public void prompt();
    }
}

