/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.NativityService;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.listeners.SocketCloseListener;
import com.liferay.nativity.listeners.SocketOpenListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FilesystemNativityService
implements NativityService,
SocketOpenListener,
SocketCloseListener {
    private static final Logger log = LogManager.getLogger((String)FilesystemNativityService.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final NativityControl control;
    private NativityService.State state = NativityService.State.disconnected;

    public FilesystemNativityService(NativityControl control) {
        this.control = control;
        this.control.addSocketOpenListener((SocketOpenListener)this);
        this.control.addSocketCloseListener((SocketCloseListener)this);
    }

    public void onSocketOpen() {
        log.debug(String.format("Opened socket for %s", this.control));
        this.setFilter();
        this.state = NativityService.State.connected;
    }

    public void onSocketClose() {
        log.debug(String.format("Closed for %s", this.control));
        this.state = NativityService.State.disconnected;
    }

    @Override
    public void disconnect(Filesystem fs) throws LocalAccessDeniedException {
        this.setFilter();
    }

    @Override
    public NativityService.State connect(Filesystem fs) throws LocalAccessDeniedException {
        if (this.control.connect()) {
            this.setFilter();
            return this.state;
        }
        throw new LocalAccessDeniedException("Unknown failure initializing connection for nativity control");
    }

    protected Path map(Set<Filesystem> mountpoints, String selected) {
        Filesystem fs = this.lookup(mountpoints, selected);
        if (null == fs) {
            return null;
        }
        if (StringUtils.equals((CharSequence)fs.getMountpoint().getAbsolute(), (CharSequence)selected)) {
            return fs.getOperations().getWorkdir();
        }
        String input = StringUtils.replace((String)StringUtils.removeStart((String)StringUtils.removeStart((String)selected, (String)fs.getMountpoint().getAbsolute()), (String)this.preferences.getProperty("local.delimiter")), (String)this.preferences.getProperty("local.delimiter"), (String)Character.toString('/'));
        try {
            return fs.getOperations().find(this.compose(fs.getOperations().getWorkdir(), PathNormalizer.parent((String)input, (char)'/')), PathNormalizer.name((String)input), FilesystemCallbacks.Flags.offline);
        }
        catch (BackgroundException e) {
            log.warn(String.format("Failure %s to map %s", new Object[]{e, selected}));
            return null;
        }
    }

    protected Path compose(Path workdir, String path) {
        if (StringUtils.equals((CharSequence)String.valueOf('/'), (CharSequence)path)) {
            return workdir;
        }
        Path parent = this.compose(workdir, PathNormalizer.parent((String)path, (char)'/'));
        return new Path(parent, PathNormalizer.name((String)path), EnumSet.of(AbstractPath.Type.directory));
    }

    protected Set<Local> getObservedFolders() {
        HashSet<Local> observed = new HashSet<Local>();
        Set allObservedFolders = this.control.getAllObservedFolders();
        if (null != allObservedFolders) {
            for (String folder : allObservedFolders) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Add %s to list of observed folders", folder));
                }
                observed.add(LocalFactory.get((String)folder));
            }
            if (observed.isEmpty()) {
                return Collections.emptySet();
            }
        }
        return observed;
    }

    protected Filesystem lookup(Set<Filesystem> mountpoints, String selected) {
        for (Filesystem fs : mountpoints) {
            Local mountpoint = fs.getMountpoint();
            if (null == mountpoint) continue;
            if (LocalFactory.get((String)selected).isChild(mountpoint)) {
                return fs;
            }
            if (!LocalFactory.get((String)selected).equals((Object)mountpoint)) continue;
            return fs;
        }
        log.warn(String.format("Failure finding mount point for path %s", selected));
        return null;
    }

    protected Map<Filesystem, List<FilesystemEntry>> select(String[] selected) {
        Set mountpoints = FilesystemMountRegistry.get().values();
        HashMap<Filesystem, List<FilesystemEntry>> mapping = new HashMap<Filesystem, List<FilesystemEntry>>();
        if (Arrays.asList(selected).isEmpty()) {
            for (Filesystem fs : mountpoints) {
                if (!mapping.containsKey(fs)) {
                    mapping.put(fs, new ArrayList());
                }
                for (Local file : this.getObservedFolders()) {
                    if (!file.equals((Object)fs.getMountpoint()) && !file.isChild(fs.getMountpoint())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Add observed directory %s", file));
                    }
                    if (fs.getMountpoint().equals((Object)file)) {
                        mapping.get(fs).add(new FilesystemEntry(file, fs.getOperations().getWorkdir()));
                        continue;
                    }
                    mapping.get(fs).add(new FilesystemEntry(file, fs.getComposer().compose(fs.getOperations().getWorkdir(), PathRelativizer.relativize((String)fs.getMountpoint().getAbsolute(), (String)file.getAbsolute()), EnumSet.of(AbstractPath.Type.directory))));
                }
                if (!mapping.get(fs).isEmpty()) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add mount point directory %s", fs.getMountpoint()));
                }
                mapping.get(fs).add(new FilesystemEntry(fs.getMountpoint(), fs.getOperations().getWorkdir()));
            }
        }
        for (String path : selected) {
            Path found;
            Filesystem fs = this.lookup(mountpoints, path);
            if (null == fs) continue;
            if (!mapping.containsKey(fs)) {
                mapping.put(fs, new ArrayList());
            }
            if (null == (found = this.map(mountpoints, path))) continue;
            mapping.get(fs).add(new FilesystemEntry(LocalFactory.get((String)path), found));
        }
        return mapping;
    }

    protected void setFilter() {
        HashSet<String> volumes = new HashSet<String>();
        for (Filesystem fs : FilesystemMountRegistry.get().values()) {
            Local mountpoint = fs.getMountpoint();
            if (null == mountpoint) continue;
            volumes.add(mountpoint.getAbsolute());
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Set filter for folders %s", volumes));
        }
        this.setFilter(volumes);
    }

    protected void setFilter(Set<String> volumes) {
        this.control.setFilterFolders(volumes.toArray(new String[volumes.size()]));
    }
}

