/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.badge.FileOverlayIconService;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.FilesystemNativityService;
import ch.iterate.mountainduck.service.BackgroundStatusListener;
import ch.iterate.mountainduck.service.DisabledBackgroundStatusListener;
import ch.iterate.mountainduck.service.FileBadgeService;
import ch.iterate.mountainduck.service.MountRegistryBackgroundStatusListener;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.modules.fileicon.FileIconControl;
import com.liferay.nativity.modules.fileicon.FileIconControlCallback;
import com.liferay.nativity.modules.fileicon.FileIconControlUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileIconService
extends FilesystemNativityService
implements FileIconControlCallback,
FileBadgeService {
    private static final Logger log = LogManager.getLogger((String)FileIconService.class.getName());
    protected static final int TYPE_ENCRYPTION = 1;
    protected static final int TYPE_SYNC = 2;
    private final FileIconControl icon;
    private final AtomicReference<BackgroundStatusListener> listener = new AtomicReference();
    private final Preferences preferences = PreferencesFactory.get();

    public FileIconService(NativityControl control) {
        this(control, (BackgroundStatusListener)new DisabledBackgroundStatusListener());
    }

    public FileIconService(NativityControl control, BackgroundStatusListener listener) {
        super(control);
        this.icon = FileIconControlUtil.getFileIconControl((NativityControl)control, (FileIconControlCallback)this);
        this.icon.enableFileIcons();
        this.listener.set((BackgroundStatusListener)new MountRegistryBackgroundStatusListener(listener));
    }

    public void register(FileBadgeService.Icon badge) {
        this.icon.registerIconWithId(badge.name, badge.description, String.valueOf(badge.id));
    }

    public void refresh(Map<Local, FileBadgeService.PathOperation> files, SyncQueue.Status status) {
        BackgroundStatusListener l = this.listener.get();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Notify listener %s with status %s", l, status));
        }
        l.refresh(status);
        HashSet<String> paths = new HashSet<String>();
        for (Map.Entry<Local, FileBadgeService.PathOperation> file : files.entrySet()) {
            FileBadgeService.PathOperation operation = file.getValue();
            if (!this.filter(file.getKey()) || !this.filter(operation.operation)) continue;
            String local = file.getKey().getAbsolute();
            paths.add(local);
        }
        if (!paths.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Refresh badge for files %s", paths));
            }
            this.icon.refreshIcons(paths.toArray(new String[paths.size()]));
        }
    }

    public void refresh(Map<Local, FileBadgeService.PathOperation> files, DirectoryIndexer.Status status) {
        BackgroundStatusListener l = this.listener.get();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Notify listener %s with status %s", l, status));
        }
        l.refresh(status);
    }

    public void refresh(TransferProgress progress) {
        BackgroundStatusListener l = this.listener.get();
        l.refresh(progress);
    }

    public FileBadgeService withListener(BackgroundStatusListener listener) {
        this.listener.set((BackgroundStatusListener)new MountRegistryBackgroundStatusListener(listener));
        return this;
    }

    public int getIconForFile(String path) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Lookup file icon for path %s", path));
        }
        Map<Filesystem, List<FilesystemEntry>> selected = this.select(new String[]{path});
        for (Map.Entry<Filesystem, List<FilesystemEntry>> entry : selected.entrySet()) {
            Filesystem fs = entry.getKey();
            List<FilesystemEntry> files = entry.getValue();
            for (FilesystemEntry file : files) {
                if (this.preferences.getBoolean("nativity.badge.cryptomator.enable") && file.remote.getType().contains(AbstractPath.Type.decrypted)) {
                    return 1 << AbstractPath.Type.decrypted.ordinal();
                }
                if (!this.preferences.getBoolean("nativity.badge.sync.enable")) continue;
                FileOverlayIconService.Badge status = fs.getBadge(file.remote);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Return status %s for path %s", status, path));
                }
                return 2 << status.ordinal();
            }
        }
        log.warn(String.format("No file icon for path %s", path));
        return -1;
    }

    protected boolean filter(Local file) {
        return true;
    }

    protected boolean filter(Operation operation) {
        switch (operation) {
            case timestamp: 
            case chmod: 
            case lock: 
            case unlock: {
                return false;
            }
        }
        return true;
    }
}

