/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.nativity.FilesystemEntry;
import ch.iterate.mountainduck.nativity.FilesystemNativityService;
import ch.iterate.mountainduck.nativity.contextmenu.BookmarkMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.CustomActionMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.InfoMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.MenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.ReloadMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.RestoreMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.ShareMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.SyncMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.TerminalMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.UploadMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.UrlMenuItemBuilder;
import ch.iterate.mountainduck.nativity.contextmenu.VaultMenuItemBuilder;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.modules.contextmenu.ContextMenuControlCallback;
import com.liferay.nativity.modules.contextmenu.ContextMenuControlUtil;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContextMenuService
extends FilesystemNativityService
implements ContextMenuControlCallback {
    private static final Logger log = LogManager.getLogger((String)ContextMenuService.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final MenuItemBuilder infoMenuItemBuilder;
    private final MenuItemBuilder customActionMenuItemBuilder;
    private final MenuItemBuilder reloadMenuItemBuilder;
    private final MenuItemBuilder bookmarkMenuItemBuilder;
    private final MenuItemBuilder terminalMenuItemBuilder;
    private final MenuItemBuilder urlMenuItemBuilder;
    private final MenuItemBuilder shareMenuItemBuilder;
    private final MenuItemBuilder vaultMenuItemBuilder;
    private final MenuItemBuilder uploadMenuItemBuilder;
    private final MenuItemBuilder syncMenuItemBuilder;
    private final MenuItemBuilder restoreMenuItemBuilder;

    public ContextMenuService(Controller controller, NativityControl control) {
        super(control);
        ContextMenuControlUtil.getContextMenuControl((NativityControl)control, (ContextMenuControlCallback)this);
        this.infoMenuItemBuilder = new InfoMenuItemBuilder(controller);
        this.customActionMenuItemBuilder = new CustomActionMenuItemBuilder(controller);
        this.reloadMenuItemBuilder = new ReloadMenuItemBuilder(control);
        this.bookmarkMenuItemBuilder = new BookmarkMenuItemBuilder();
        this.terminalMenuItemBuilder = new TerminalMenuItemBuilder();
        this.urlMenuItemBuilder = new UrlMenuItemBuilder();
        this.shareMenuItemBuilder = new ShareMenuItemBuilder(controller);
        this.vaultMenuItemBuilder = new VaultMenuItemBuilder(controller);
        this.uploadMenuItemBuilder = new UploadMenuItemBuilder(controller);
        this.syncMenuItemBuilder = new SyncMenuItemBuilder();
        this.restoreMenuItemBuilder = new RestoreMenuItemBuilder(controller);
    }

    public List<ContextMenuItem> getContextMenuItems(String[] files) {
        List<ContextMenuItem> items;
        if (log.isInfoEnabled()) {
            log.info(String.format("Return context menu items for paths %s", Arrays.toString(files)));
        }
        ContextMenuItem main = new ContextMenuItem(this.preferences.getProperty("application.name"));
        main.setIconPath(this.preferences.getProperty("nativity.contextmenu.icon.default.path"));
        Map<Filesystem, List<FilesystemEntry>> selected = this.select(files);
        if (this.preferences.getBoolean("nativity.contextmenu.reload.enable")) {
            List<ContextMenuItem> items2 = this.reloadMenuItemBuilder.build(selected);
            for (ContextMenuItem menu : items2) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add menu %s", menu));
                }
                main.addContextMenuItem(menu);
            }
            if (!items2.isEmpty()) {
                main.addSeparator();
            }
        }
        if (this.preferences.getBoolean("nativity.contextmenu.sync.enable")) {
            items = this.syncMenuItemBuilder.build(selected);
            for (ContextMenuItem menu : items) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add menu %s", menu));
                }
                main.addContextMenuItem(menu);
            }
            if (!items.isEmpty()) {
                main.addSeparator();
            }
        }
        if (this.preferences.getBoolean("nativity.contextmenu.terminal.enable")) {
            for (ContextMenuItem contextMenuItem : this.terminalMenuItemBuilder.build(selected)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add menu %s", contextMenuItem));
                }
                main.addContextMenuItem(contextMenuItem);
                main.addSeparator();
            }
        }
        if (this.preferences.getBoolean("nativity.contextmenu.info.enable")) {
            items = this.infoMenuItemBuilder.build(selected);
            for (ContextMenuItem menu : items) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add menu %s", menu));
                }
                main.addContextMenuItem(menu);
            }
            if (!items.isEmpty()) {
                main.addSeparator();
            }
        }
        if (this.preferences.getBoolean("nativity.contextmenu.customaction.enable")) {
            items = this.customActionMenuItemBuilder.build(selected);
            for (ContextMenuItem menu : items) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add menu %s", menu));
                }
                main.addContextMenuItem(menu);
            }
            if (!items.isEmpty()) {
                main.addSeparator();
            }
        }
        ArrayList<ContextMenuItem> urlItems = new ArrayList<ContextMenuItem>();
        if (this.preferences.getBoolean("nativity.contextmenu.share.enable")) {
            if (this.preferences.getBoolean("nativity.contextmenu.share.download.enable")) {
                urlItems.addAll(this.shareMenuItemBuilder.build(selected));
            }
            if (this.preferences.getBoolean("nativity.contextmenu.share.upload.enable")) {
                urlItems.addAll(this.uploadMenuItemBuilder.build(selected));
            }
        }
        if (this.preferences.getBoolean("nativity.contextmenu.url.enable")) {
            urlItems.addAll(this.urlMenuItemBuilder.build(selected));
        }
        for (ContextMenuItem menu : urlItems) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Add menu %s", menu));
            }
            main.addContextMenuItem(menu);
        }
        if (!urlItems.isEmpty()) {
            main.addSeparator();
        }
        if (this.preferences.getBoolean("nativity.contextmenu.restore.enable")) {
            List<ContextMenuItem> list = this.restoreMenuItemBuilder.build(selected);
            for (ContextMenuItem menu : list) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add menu %s", menu));
                }
                main.addContextMenuItem(menu);
            }
            if (!list.isEmpty()) {
                main.addSeparator();
            }
        }
        if (this.preferences.getBoolean("cryptomator.enable")) {
            List<ContextMenuItem> list = this.vaultMenuItemBuilder.build(selected);
            for (ContextMenuItem menu : list) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add menu %s", menu));
                }
                main.addContextMenuItem(menu);
            }
            if (!list.isEmpty() && this.preferences.getBoolean("nativity.contextmenu.bookmark.enable")) {
                main.addSeparator();
            }
        }
        if (this.preferences.getBoolean("nativity.contextmenu.bookmark.enable")) {
            List<ContextMenuItem> list = this.bookmarkMenuItemBuilder.build(selected);
            for (ContextMenuItem menu : list) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add menu %s", menu));
                }
                main.addContextMenuItem(menu);
            }
        }
        return Collections.singletonList(main);
    }
}

