/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.manta.MantaObjectAttributeAdapter;
import ch.cyberduck.core.manta.MantaSession;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaObject;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MantaSearchFeature
implements Search {
    private final MantaSession session;
    private final MantaObjectAttributeAdapter adapter;

    public MantaSearchFeature(MantaSession session) {
        this.session = session;
        this.adapter = new MantaObjectAttributeAdapter(session);
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        AttributedList list = new AttributedList();
        if (workdir.getParent().isRoot()) {
            Predicate<MantaObject> fastSearchPredicate = o -> this.session.isWorldReadable((MantaObject)o) || this.session.isUserWritable((MantaObject)o);
            List<Path> homeFolderPaths = this.findObjectsAsPaths(workdir, fastSearchPredicate);
            this.cleanResults(homeFolderPaths, regex);
            this.addPaths((AttributedList<Path>)list, workdir, listener, homeFolderPaths);
        } else {
            List<Path> foundPaths = this.findObjectsAsPaths(workdir, null);
            this.cleanResults(foundPaths, regex);
            this.addPaths((AttributedList<Path>)list, workdir, listener, foundPaths);
        }
        return list;
    }

    private void cleanResults(List<Path> foundPaths, Filter<Path> regex) {
        HashSet<Path> removal = new HashSet<Path>();
        if (regex.toPattern().pattern().equals(".*") || regex instanceof NullFilter) {
            return;
        }
        for (Path f : foundPaths) {
            if (f.getName().contains(regex.toPattern().pattern())) continue;
            removal.add(f);
        }
        foundPaths.removeAll(removal);
    }

    private List<Path> findObjectsAsPaths(Path workdir, Predicate<MantaObject> searchPredicate) {
        return ((MantaClient)this.session.getClient()).find(workdir.getAbsolute(), searchPredicate).map(this.adapter::toPath).collect(Collectors.toList());
    }

    private void addPaths(AttributedList<Path> list, Path workdir, ListProgressListener listener, List<Path> foundObjects) throws ConnectionCanceledException {
        if (!foundObjects.isEmpty()) {
            list.addAll(foundObjects);
            listener.chunk(workdir, list);
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

