/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.manta.MantaAttributesFinderFeature;
import ch.cyberduck.core.manta.MantaExceptionMappingService;
import ch.cyberduck.core.manta.MantaHttpExceptionMappingService;
import ch.cyberduck.core.manta.MantaSession;
import ch.cyberduck.core.transfer.TransferStatus;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import java.io.IOException;

public class MantaDirectoryFeature
implements Directory {
    private final MantaSession session;

    public MantaDirectoryFeature(MantaSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            ((MantaClient)this.session.getClient()).putDirectory(folder.getAbsolute());
            return folder.withAttributes(new MantaAttributesFinderFeature(this.session).find(folder));
        }
        catch (MantaException e) {
            throw new MantaExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
        catch (MantaClientHttpResponseException e) {
            throw new MantaHttpExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create folder {0}", (Throwable)e, folder);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return this.session.isUserWritable(workdir);
    }

    public Directory withWriter(Write writer) {
        return this;
    }
}

