/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.oauth;

import ch.cyberduck.core.oauth.OAuth2TokenListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OAuth2TokenListenerRegistry {
    private static final Logger log = LogManager.getLogger(OAuth2TokenListenerRegistry.class);
    private static final OAuth2TokenListenerRegistry global = new OAuth2TokenListenerRegistry();
    private final Map<String, OAuth2TokenListener> listeners = new HashMap<String, OAuth2TokenListener>();

    public static OAuth2TokenListenerRegistry get() {
        return global;
    }

    public void register(String state, OAuth2TokenListener listener) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Register listener for state %s", state));
        }
        this.listeners.put(state, listener);
    }

    public void notify(String state, String token) {
        OAuth2TokenListener listener = this.listeners.get(state);
        if (null == listener) {
            log.error(String.format("Missing listener for state %s", state));
            return;
        }
        this.listeners.remove(state);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Notify listener for state %s with token %s", state, token));
        }
        listener.callback(token);
    }

    public void shutdown() {
        for (OAuth2TokenListener listener : this.listeners.values()) {
            listener.callback(null);
        }
    }
}

