/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.oauth;

import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.OAuthTokens;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.threading.CancelCallback;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OAuth2ErrorResponseInterceptor
extends DisabledServiceUnavailableRetryStrategy {
    private static final Logger log = LogManager.getLogger(OAuth2ErrorResponseInterceptor.class);
    private static final int MAX_RETRIES = 1;
    private final Host bookmark;
    private final OAuth2RequestInterceptor service;
    private final LoginCallback prompt;

    public OAuth2ErrorResponseInterceptor(Host bookmark, OAuth2RequestInterceptor service, LoginCallback prompt) {
        this.bookmark = bookmark;
        this.service = service;
        this.prompt = prompt;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                if (executionCount <= 1) {
                    try {
                        try {
                            log.info(String.format("Attempt to refresh OAuth tokens for failure %s", response));
                            this.service.setTokens(this.service.refresh());
                        }
                        catch (InteroperabilityException | LoginFailureException e) {
                            log.warn(String.format("Failure refreshing OAuth tokens. %s", e));
                            this.bookmark.getCredentials().setOauth(OAuthTokens.EMPTY);
                            this.service.setTokens(this.service.authorize(this.bookmark, this.prompt, (CancelCallback)new DisabledCancelCallback(), OAuth2AuthorizationService.FlowType.AuthorizationCode));
                        }
                        return true;
                    }
                    catch (BackgroundException e) {
                        log.warn(String.format("Failure refreshing OAuth tokens. %s", new Object[]{e}));
                        break;
                    }
                }
                if (!log.isWarnEnabled()) break;
                log.warn(String.format("Skip retry for response %s after %d executions", response, executionCount));
            }
        }
        return false;
    }
}

