/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service.worker.dracoon;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateDownloadShareRequest;
import ch.cyberduck.core.worker.DownloadShareWorker;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import ch.iterate.mountainduck.service.PasteboardService;
import ch.iterate.mountainduck.service.PasteboardServiceFactory;
import ch.iterate.mountainduck.service.worker.dracoon.SDSCreateDownloadShareController;
import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.cocoa.foundation.NSRect;

public final class SDSDownloadShareWorker
extends DownloadShareWorker<CreateDownloadShareRequest> {
    private static final Logger log = LogManager.getLogger((String)SDSDownloadShareWorker.class.getName());
    private final SDSCreateDownloadShareController controller;
    private final CountDownLatch signal;
    private final Path file;

    public SDSDownloadShareWorker(SDSCreateDownloadShareController controller, CountDownLatch signal, Path file, PasswordCallback callback, CreateDownloadShareRequest options) {
        super(file, (Object)options, callback);
        this.controller = controller;
        this.signal = signal;
        this.file = file;
    }

    public DescriptiveUrl initialize() {
        return DescriptiveUrl.EMPTY;
    }

    public void cleanup(final DescriptiveUrl url) {
        if (!DescriptiveUrl.EMPTY.equals((Object)url)) {
            AlertController alert = new AlertController(NSAlert.alert((String)LocaleFactory.localizedString((String)"Create Download Share", (String)"Share"), (String)MessageFormat.format(LocaleFactory.localizedString((String)"You have successfully created a share link for {0}.", (String)"SDS"), this.file.getName()), (String)LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), (String)LocaleFactory.localizedString((String)"Copy", (String)"Main"), null)){

                public void callback(int returncode) {
                    switch (returncode) {
                        case -1: {
                            try {
                                PasteboardServiceFactory.get().add(PasteboardService.Type.url, url.getUrl());
                                break;
                            }
                            catch (LocalAccessDeniedException e) {
                                log.error(String.format("Error writing URL to %s", "NSStringPboardType"));
                            }
                        }
                    }
                }

                public NSView getAccessoryView(NSAlert alert) {
                    NSTextField field = NSTextField.textfieldWithFrame((NSRect)new NSRect(0.0, 22.0));
                    field.setEditable(false);
                    field.setSelectable(true);
                    field.cell().setWraps(false);
                    field.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)url.getUrl(), (NSDictionary)TRUNCATE_MIDDLE_ATTRIBUTES));
                    return field;
                }
            };
            new ModalPanelAlertRunner().run((SheetController)alert);
            this.signal.countDown();
        }
        this.controller.enable();
    }
}

