/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service.worker.dracoon;

import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSDatePicker;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSSecureTextField;
import ch.cyberduck.binding.application.NSStepper;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSDate;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateUploadShareRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.GeneralSettingsInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import ch.cyberduck.core.sds.io.swagger.client.model.SystemDefaults;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalTime;
import org.rococoa.Foundation;
import org.rococoa.ID;

public abstract class SDSCreateUploadShareController
extends SheetController {
    private final Path file;
    private NSButton expires;
    private NSDatePicker expireAt;
    private NSButton notifyCreator;
    private NSButton sendMail;
    private NSTextField smsRecipients;
    private NSButton passwordCheckbox;
    private NSSecureTextField password;
    private NSSecureTextField passwordConfirm;
    private NSTextField mailRecipients;
    private NSTextField mailSubject;
    private NSTextField mailBody;
    private NSButton maxUploadsCheckbox;
    private NSStepper maxUploadsStepper;
    private NSTextField maxUploads;
    private NSPopUpButton maxUploadsSizeUnit;
    private NSButton maxUploadsSizeCheckbox;
    private NSStepper maxUploadsSizeStepper;
    private NSTextField maxUploadsSize;
    private NSButton showUploadedFiles;
    private NSTextField notes;
    private NSButton createButton;
    private NSButton cancelButton;
    private boolean smsEnabled = false;
    private boolean defaultExpiresState = true;
    private NSDate defaultExpiry = NSDate.dateWithTimeIntervalSinceNow((double)Days.ONE.toStandardSeconds().getSeconds());
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSCreateUploadShareController(Path file) {
        this.file = file;
    }

    protected String getBundleName() {
        return "Upload";
    }

    public SDSCreateUploadShareController withConfiguration(GeneralSettingsInfo configuration, SystemDefaults defaults) {
        this.smsEnabled = configuration.isSharePasswordSmsEnabled();
        double days = defaults.getUploadShareDefaultExpirationPeriod().intValue();
        if (0.0 != days) {
            double seconds = days * 24.0 * 60.0 * 60.0;
            this.defaultExpiry = NSDate.dateWithTimeIntervalSinceNow((double)seconds);
        } else {
            this.defaultExpiresState = false;
        }
        return this;
    }

    public void enable() {
        this.createButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    public void disable() {
        this.createButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
    }

    public boolean validate() {
        if (this.passwordCheckbox.state() == 1) {
            if (StringUtils.isBlank((CharSequence)this.password.stringValue())) {
                return false;
            }
            if (!StringUtils.equals((CharSequence)this.password.stringValue(), (CharSequence)this.passwordConfirm.stringValue())) {
                return false;
            }
        }
        return true;
    }

    public void awakeFromNib() {
        this.smsRecipients.setEnabled(this.smsEnabled);
        super.awakeFromNib();
    }

    public void setWindow(NSWindow window) {
        window.setTitlebarAppearsTransparent(true);
        window.standardWindowButton(0).setHidden(true);
        window.standardWindowButton(1).setHidden(true);
        window.standardWindowButton(2).setHidden(true);
        super.setWindow(window);
    }

    public void setExpires(NSButton expires) {
        this.expires = expires;
        this.expires.setState(this.defaultExpiresState ? 1 : 0);
        this.expires.setTarget(this.id());
        this.expires.setAction(Foundation.selector((String)"expiresClicked:"));
    }

    public void expiresClicked(ID sender) {
        this.expireAt.setEnabled(this.expires.state() == 1);
    }

    public void setExpireAt(NSDatePicker expireAt) {
        this.expireAt = expireAt;
        this.expireAt.setDateValue(this.defaultExpiry);
        this.expireAt.setEnabled(true);
    }

    public void setNotifyCreator(NSButton notifyCreator) {
        this.notifyCreator = notifyCreator;
        this.notifyCreator.setState(0);
    }

    public void setSendMail(NSButton sendMail) {
        this.sendMail = sendMail;
        this.sendMail.setState(0);
        this.sendMail.setTarget(this.id());
        this.sendMail.setAction(Foundation.selector((String)"sendMailClicked:"));
    }

    public void sendMailClicked(ID sender) {
        this.mailSubject.setEnabled(this.sendMail.state() == 1);
        this.mailRecipients.setEnabled(this.sendMail.state() == 1);
        this.mailBody.setEnabled(this.sendMail.state() == 1);
    }

    public void setMailRecipients(NSTextField mailRecipients) {
        this.mailRecipients = mailRecipients;
        this.mailRecipients.setEnabled(false);
    }

    public void setMailSubject(NSTextField mailSubject) {
        this.mailSubject = mailSubject;
        this.mailSubject.setEnabled(false);
    }

    public void setMailBody(NSTextField mailBody) {
        this.mailBody = mailBody;
        this.mailBody.setEnabled(false);
    }

    public void setSmsRecipients(NSTextField smsRecipients) {
        this.smsRecipients = smsRecipients;
        this.smsRecipients.setEnabled(false);
    }

    public void setPasswordCheckbox(NSButton passwordCheckbox) {
        this.passwordCheckbox = passwordCheckbox;
        this.passwordCheckbox.setState(0);
        this.passwordCheckbox.setAction(Foundation.selector((String)"passwordCheckboxClicked:"));
    }

    public void passwordCheckboxClicked(ID sender) {
        this.password.setEnabled(this.passwordCheckbox.state() == 1);
        this.passwordConfirm.setEnabled(this.passwordCheckbox.state() == 1);
        this.smsRecipients.setEnabled(this.smsEnabled && this.passwordCheckbox.state() == 1);
    }

    public void setPassword(NSSecureTextField password) {
        this.password = password;
        this.password.setEnabled(false);
    }

    public void setPasswordConfirm(NSSecureTextField passwordConfirm) {
        this.passwordConfirm = passwordConfirm;
        this.passwordConfirm.setEnabled(false);
    }

    public void setMaxUploadsCheckbox(NSButton maxUploadsCheckbox) {
        this.maxUploadsCheckbox = maxUploadsCheckbox;
        this.maxUploadsCheckbox.setState(0);
        this.maxUploadsCheckbox.setTarget(this.id());
        this.maxUploadsCheckbox.setAction(Foundation.selector((String)"maxUploadsCheckboxClicked:"));
    }

    public void maxUploadsCheckboxClicked(ID sender) {
        this.maxUploadsStepper.setEnabled(this.maxUploadsCheckbox.state() == 1);
        this.maxUploads.setStringValue(this.maxUploadsCheckbox.state() == 1 ? "1" : "");
    }

    public void setMaxUploads(NSTextField maxUploads) {
        this.maxUploads = maxUploads;
        this.maxUploads.setEnabled(true);
        this.maxUploads.setSelectable(false);
        this.maxUploads.setEditable(false);
    }

    public void setMaxUploadsStepper(NSStepper maxUploadsStepper) {
        this.maxUploadsStepper = maxUploadsStepper;
        this.maxUploadsStepper.setMinValue(1.0);
        this.maxUploadsStepper.setIntegerValue(0);
        this.maxUploadsStepper.setMaxValue(Double.MAX_VALUE);
        this.maxUploadsStepper.setTarget(this.id());
        this.maxUploadsStepper.setAction(Foundation.selector((String)"maxUploadsStepperClicked:"));
        this.maxUploadsStepper.setEnabled(false);
    }

    public void maxUploadsStepperClicked(ID sender) {
        this.maxUploads.setIntValue(this.maxUploadsStepper.intValue());
    }

    public void setMaxUploadsSizeUnit(NSPopUpButton maxUploadsSizeUnit) {
        this.maxUploadsSizeUnit = maxUploadsSizeUnit;
        this.maxUploadsSizeUnit.addItemWithTitle("MB");
        this.maxUploadsSizeUnit.lastItem().setRepresentedObject(String.valueOf(0x100000L));
        this.maxUploadsSizeUnit.addItemWithTitle("GB");
        this.maxUploadsSizeUnit.lastItem().setRepresentedObject(String.valueOf(0x40000000L));
        this.maxUploadsSizeUnit.selectItemWithTitle("GB");
    }

    public void setMaxUploadsSizeCheckbox(NSButton maxUploadsSizeCheckbox) {
        this.maxUploadsSizeCheckbox = maxUploadsSizeCheckbox;
        this.maxUploadsSizeCheckbox.setState(0);
        this.maxUploadsSizeCheckbox.setTarget(this.id());
        this.maxUploadsSizeCheckbox.setAction(Foundation.selector((String)"maxUploadsSizeCheckboxClicked:"));
    }

    public void maxUploadsSizeCheckboxClicked(ID sender) {
        this.maxUploadsSizeStepper.setEnabled(this.maxUploadsSizeCheckbox.state() == 1);
        this.maxUploadsSize.setStringValue(this.maxUploadsSizeCheckbox.state() == 1 ? "1" : "");
    }

    public void setMaxUploadsSize(NSTextField maxUploadsSize) {
        this.maxUploadsSize = maxUploadsSize;
        this.maxUploadsSize.setEnabled(true);
        this.maxUploadsSize.setSelectable(false);
        this.maxUploadsSize.setEditable(false);
        this.maxUploadsSize.setIntegerValue(2);
    }

    public void setMaxUploadsSizeStepper(NSStepper maxUploadsSizeStepper) {
        this.maxUploadsSizeStepper = maxUploadsSizeStepper;
        this.maxUploadsSizeStepper.setMinValue(1.0);
        this.maxUploadsSizeStepper.setIntegerValue(1);
        this.maxUploadsSizeStepper.setMaxValue(Double.MAX_VALUE);
        this.maxUploadsSizeStepper.setTarget(this.id());
        this.maxUploadsSizeStepper.setAction(Foundation.selector((String)"maxUploadsSizeStepperClicked:"));
        this.maxUploadsSizeStepper.setEnabled(false);
    }

    public void maxUploadsSizeStepperClicked(ID sender) {
        this.maxUploadsSize.setIntValue(this.maxUploadsSizeStepper.intValue());
    }

    public void setShowUploadedFiles(NSButton showUploadedFiles) {
        this.showUploadedFiles = showUploadedFiles;
        this.showUploadedFiles.setState(0);
    }

    public void setNotes(NSTextField notes) {
        this.notes = notes;
    }

    public void setCreateButton(NSButton createButton) {
        this.createButton = createButton;
    }

    public void setCancelButton(NSButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    protected CreateUploadShareRequest toOptions() {
        return new CreateUploadShareRequest().expiration(new ObjectExpiration().expireAt(new DateTime((long)(this.expireAt.dateValue().timeIntervalSince1970() * 1000.0)).withTime(LocalTime.MIDNIGHT)).enableExpiration(Boolean.valueOf(this.expires.state() == 1))).notifyCreator(Boolean.valueOf(this.notifyCreator.state() == 1)).sendMail(Boolean.valueOf(this.sendMail.state() == 1)).mailRecipients(this.sendMail.state() == 1 ? (StringUtils.isNotBlank((CharSequence)this.mailRecipients.stringValue()) ? StringUtils.replaceChars((String)this.mailRecipients.stringValue(), (char)',', (char)';') : null) : null).sendSms(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)this.smsRecipients.stringValue()))).smsRecipients(StringUtils.isNotBlank((CharSequence)this.smsRecipients.stringValue()) ? this.smsRecipients.stringValue() : null).password(this.passwordCheckbox.state() == 1 ? (StringUtils.isNotBlank((CharSequence)this.password.stringValue()) ? this.password.stringValue() : null) : null).mailSubject(StringUtils.isNotBlank((CharSequence)this.mailSubject.stringValue()) ? this.mailSubject.stringValue() : null).mailBody(StringUtils.isNotBlank((CharSequence)this.mailBody.stringValue()) ? this.mailBody.stringValue() : null).notes(StringUtils.isNotBlank((CharSequence)this.notes.stringValue()) ? this.notes.stringValue() : null).maxSlots(this.maxUploadsCheckbox.state() == 1 && NumberUtils.isParsable((String)this.maxUploads.stringValue()) ? Integer.valueOf(this.maxUploads.stringValue()) : null).maxSize(this.maxUploadsSizeCheckbox.state() == 1 && NumberUtils.isParsable((String)this.maxUploadsSize.stringValue()) ? Long.valueOf(Long.valueOf(this.maxUploadsSizeUnit.selectedItem().representedObject()) * Long.valueOf(this.maxUploadsSize.stringValue())) : null).showUploadedFiles(Boolean.valueOf(this.showUploadedFiles.state() == 1));
    }
}

