/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service.worker.dracoon;

import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSDatePicker;
import ch.cyberduck.binding.application.NSSecureTextField;
import ch.cyberduck.binding.application.NSStepper;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSDate;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.io.swagger.client.model.ClassificationPoliciesConfig;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateDownloadShareRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.GeneralSettingsInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import ch.cyberduck.core.sds.io.swagger.client.model.SystemDefaults;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalTime;
import org.rococoa.Foundation;
import org.rococoa.ID;

public abstract class SDSCreateDownloadShareController
extends SheetController {
    private final Path file;
    private NSButton expires;
    private NSDatePicker expireAt;
    private NSButton notifyCreator;
    private NSButton sendMail;
    private NSTextField smsRecipients;
    private NSButton passwordCheckbox;
    private NSSecureTextField password;
    private NSSecureTextField passwordConfirm;
    private NSTextField mailRecipients;
    private NSTextField mailSubject;
    private NSTextField mailBody;
    private NSButton maxDownloadsCheckbox;
    private NSStepper maxDownloadsStepper;
    private NSTextField maxDownloads;
    private NSButton showCreatorName;
    private NSTextField notes;
    private NSButton createButton;
    private NSButton cancelButton;
    private boolean smsEnabled = false;
    private boolean defaultExpiresState = true;
    private int classificationRequiresSharePassword = 0;
    private NSDate defaultExpiry = NSDate.dateWithTimeIntervalSinceNow((double)Days.ONE.toStandardSeconds().getSeconds());
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSCreateDownloadShareController(Path file) {
        this.file = file;
    }

    protected String getBundleName() {
        return "Share";
    }

    public SDSCreateDownloadShareController withConfiguration(GeneralSettingsInfo configuration, SystemDefaults defaults, ClassificationPoliciesConfig classifications) {
        this.smsEnabled = configuration.isSharePasswordSmsEnabled() != false && !SDSNodeIdProvider.isEncrypted((Path)this.file);
        Double days = (double)defaults.getDownloadShareDefaultExpirationPeriod();
        if (0.0 != days) {
            double seconds = days * 24.0 * 60.0 * 60.0;
            this.defaultExpiry = NSDate.dateWithTimeIntervalSinceNow((double)seconds);
        } else {
            this.defaultExpiresState = false;
        }
        if (classifications != null) {
            this.classificationRequiresSharePassword = classifications.getShareClassificationPolicies().getClassificationRequiresSharePassword().getValue();
        }
        return this;
    }

    public void enable() {
        this.createButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    public void disable() {
        this.createButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
    }

    public boolean validate() {
        if (this.passwordCheckbox.state() == 1) {
            if (StringUtils.isBlank((CharSequence)this.password.stringValue())) {
                return false;
            }
            if (!StringUtils.equals((CharSequence)this.password.stringValue(), (CharSequence)this.passwordConfirm.stringValue())) {
                return false;
            }
        }
        return !SDSNodeIdProvider.isEncrypted((Path)this.containerService.getContainer(this.file)) || !StringUtils.isBlank((CharSequence)this.password.stringValue());
    }

    public void awakeFromNib() {
        int classification;
        boolean encrypted = SDSNodeIdProvider.isEncrypted((Path)this.containerService.getContainer(this.file));
        boolean classified = false;
        if (0 != this.classificationRequiresSharePassword && this.file.attributes().getCustom().containsKey("classification") && (classification = Integer.parseInt((String)this.file.attributes().getCustom().get("classification"))) >= this.classificationRequiresSharePassword) {
            classified = true;
        }
        this.passwordCheckbox.setState(encrypted || classified ? 1 : 0);
        this.passwordCheckbox.setEnabled(!encrypted && !classified);
        this.password.setEnabled(encrypted || classified);
        this.passwordConfirm.setEnabled(encrypted || classified);
        this.smsRecipients.setEnabled(this.smsEnabled && encrypted);
        super.awakeFromNib();
    }

    public void setWindow(NSWindow window) {
        window.setTitlebarAppearsTransparent(true);
        window.standardWindowButton(0).setHidden(true);
        window.standardWindowButton(1).setHidden(true);
        window.standardWindowButton(2).setHidden(true);
        super.setWindow(window);
    }

    public void setExpires(NSButton expires) {
        this.expires = expires;
        this.expires.setState(this.defaultExpiresState ? 1 : 0);
        this.expires.setTarget(this.id());
        this.expires.setAction(Foundation.selector((String)"expiresClicked:"));
    }

    public void expiresClicked(ID sender) {
        this.expireAt.setEnabled(this.expires.state() == 1);
    }

    public void setExpireAt(NSDatePicker expireAt) {
        this.expireAt = expireAt;
        this.expireAt.setDateValue(this.defaultExpiry);
        this.expireAt.setEnabled(true);
    }

    public void setNotifyCreator(NSButton notifyCreator) {
        this.notifyCreator = notifyCreator;
        this.notifyCreator.setState(0);
    }

    public void setSendMail(NSButton sendMail) {
        this.sendMail = sendMail;
        this.sendMail.setState(0);
        this.sendMail.setTarget(this.id());
        this.sendMail.setAction(Foundation.selector((String)"sendMailClicked:"));
    }

    public void sendMailClicked(ID sender) {
        this.mailSubject.setEnabled(this.sendMail.state() == 1);
        this.mailRecipients.setEnabled(this.sendMail.state() == 1);
        this.mailBody.setEnabled(this.sendMail.state() == 1);
    }

    public void setMailRecipients(NSTextField mailRecipients) {
        this.mailRecipients = mailRecipients;
        this.mailRecipients.setEnabled(false);
    }

    public void setMailSubject(NSTextField mailSubject) {
        this.mailSubject = mailSubject;
        this.mailSubject.setEnabled(false);
    }

    public void setMailBody(NSTextField mailBody) {
        this.mailBody = mailBody;
        this.mailBody.setEnabled(false);
    }

    public void setSmsRecipients(NSTextField smsRecipients) {
        this.smsRecipients = smsRecipients;
        this.smsRecipients.setEnabled(false);
    }

    public void setPasswordCheckbox(NSButton passwordCheckbox) {
        this.passwordCheckbox = passwordCheckbox;
        this.passwordCheckbox.setState(0);
        this.passwordCheckbox.setAction(Foundation.selector((String)"passwordCheckboxClicked:"));
    }

    public void passwordCheckboxClicked(ID sender) {
        this.password.setEnabled(this.passwordCheckbox.state() == 1);
        this.passwordConfirm.setEnabled(this.passwordCheckbox.state() == 1);
        this.smsRecipients.setEnabled(this.smsEnabled && this.passwordCheckbox.state() == 1);
    }

    public void setPassword(NSSecureTextField password) {
        this.password = password;
        this.password.setEnabled(false);
    }

    public void setPasswordConfirm(NSSecureTextField passwordConfirm) {
        this.passwordConfirm = passwordConfirm;
        this.passwordConfirm.setEnabled(false);
    }

    public void setMaxDownloadsCheckbox(NSButton maxDownloadsCheckbox) {
        this.maxDownloadsCheckbox = maxDownloadsCheckbox;
        this.maxDownloadsCheckbox.setState(0);
        this.maxDownloadsCheckbox.setTarget(this.id());
        this.maxDownloadsCheckbox.setAction(Foundation.selector((String)"maxDownloadsCheckboxClicked:"));
    }

    public void maxDownloadsCheckboxClicked(ID sender) {
        this.maxDownloadsStepper.setEnabled(this.maxDownloadsCheckbox.state() == 1);
        this.maxDownloads.setStringValue(this.maxDownloadsCheckbox.state() == 1 ? "1" : "");
    }

    public void setMaxDownloads(NSTextField maxDownloads) {
        this.maxDownloads = maxDownloads;
        this.maxDownloads.setEnabled(true);
        this.maxDownloads.setSelectable(false);
        this.maxDownloads.setEditable(false);
    }

    public void setMaxDownloadsStepper(NSStepper maxDownloadsStepper) {
        this.maxDownloadsStepper = maxDownloadsStepper;
        this.maxDownloadsStepper.setMinValue(1.0);
        this.maxDownloadsStepper.setIntegerValue(0);
        this.maxDownloadsStepper.setMaxValue(Double.MAX_VALUE);
        this.maxDownloadsStepper.setTarget(this.id());
        this.maxDownloadsStepper.setAction(Foundation.selector((String)"maxDownloadsStepperClicked:"));
        this.maxDownloadsStepper.setEnabled(false);
    }

    public void maxDownloadsStepperClicked(ID sender) {
        this.maxDownloads.setIntValue(this.maxDownloadsStepper.intValue());
    }

    public void setShowCreatorName(NSButton showCreatorName) {
        this.showCreatorName = showCreatorName;
        this.showCreatorName.setState(0);
    }

    public void setNotes(NSTextField notes) {
        this.notes = notes;
    }

    public void setCreateButton(NSButton createButton) {
        this.createButton = createButton;
    }

    public void setCancelButton(NSButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    protected CreateDownloadShareRequest toOptions() {
        return new CreateDownloadShareRequest().expiration(new ObjectExpiration().expireAt(new DateTime((long)(this.expireAt.dateValue().timeIntervalSince1970() * 1000.0)).withTime(LocalTime.MIDNIGHT)).enableExpiration(Boolean.valueOf(this.expires.state() == 1))).notifyCreator(Boolean.valueOf(this.notifyCreator.state() == 1)).sendMail(Boolean.valueOf(this.sendMail.state() == 1)).mailRecipients(this.sendMail.state() == 1 ? (StringUtils.isNotBlank((CharSequence)this.mailRecipients.stringValue()) ? StringUtils.replaceChars((String)this.mailRecipients.stringValue(), (char)',', (char)';') : null) : null).sendSms(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)this.smsRecipients.stringValue()))).smsRecipients(StringUtils.isNotBlank((CharSequence)this.smsRecipients.stringValue()) ? this.smsRecipients.stringValue() : null).password(this.passwordCheckbox.state() == 1 ? (StringUtils.isNotBlank((CharSequence)this.password.stringValue()) ? this.password.stringValue() : null) : null).mailSubject(StringUtils.isNotBlank((CharSequence)this.mailSubject.stringValue()) ? this.mailSubject.stringValue() : null).mailBody(StringUtils.isNotBlank((CharSequence)this.mailBody.stringValue()) ? this.mailBody.stringValue() : null).notes(StringUtils.isNotBlank((CharSequence)this.notes.stringValue()) ? this.notes.stringValue() : null).maxDownloads(this.maxDownloadsCheckbox.state() == 1 && NumberUtils.isParsable((String)this.maxDownloads.stringValue()) ? Integer.valueOf(this.maxDownloads.stringValue()) : null).showCreatorName(Boolean.valueOf(this.showCreatorName.state() == 1));
    }
}

