/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.aquaticprime.DisabledLicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.InvalidLicenseException;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseVerifier;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.cyberduck.core.date.ISO8601DateParser;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.iterate.mountainduck.AbstractShutdownTimer;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import ch.iterate.mountainduck.registration.ExpiryLicenseVerifier;
import ch.iterate.mountainduck.registration.LicenseVerifierChain;
import ch.iterate.mountainduck.registration.TrialKeyLicenseService;
import ch.iterate.mountainduck.registration.UpgradeLicenseVerifier;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkspaceShutdownTimer
extends AbstractShutdownTimer {
    private static final Logger log = LogManager.getLogger((String)WorkspaceShutdownTimer.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final Controller controller;
    private final TrialKeyLicenseService trialService;

    public WorkspaceShutdownTimer(Controller controller) {
        this.controller = controller;
        this.trialService = new TrialKeyLicenseService(controller);
    }

    public void register(License license) {
        if (!new LicenseVerifierChain(new LicenseVerifier[]{license, new ExpiryLicenseVerifier(license)}).verify((LicenseVerifierCallback)new DisabledLicenseVerifierCallback())) {
            Duration delay = this.register(new ShutdownCallback());
            NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Missing registration key", (String)"Registration"), (String)String.format("%s %s", LocaleFactory.localizedString((String)"No valid registration key found. Please purchase a license.", (String)"Registration"), MessageFormat.format(LocaleFactory.localizedString((String)"The application will quit in {0} minutes.", (String)"Registration"), delay.toMinutes())), (String)LocaleFactory.localizedString((String)"Buy", (String)"Registration"), (String)LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), (String)LocaleFactory.localizedString((String)"Request Trial", (String)"Registration"));
            switch (new ModalPanelAlertRunner().run(alert)) {
                case -1: {
                    this.trial();
                    break;
                }
                case 1: {
                    BrowserLauncherFactory.get().open(this.preferences.getProperty("website.buy"));
                }
            }
        } else if (!new UpgradeLicenseVerifier(license).verify(new LicenseVerifierCallback(){

            public void failure(InvalidLicenseException failure) {
                NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Upgrade", (String)"Registration"), (String)failure.getDetail(), (String)LocaleFactory.localizedString((String)"Upgrade", (String)"Registration"), (String)LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), (String)LocaleFactory.localizedString((String)"Request Trial", (String)"Registration"));
                switch (new ModalPanelAlertRunner().run(alert)) {
                    case -1: {
                        WorkspaceShutdownTimer.this.trial();
                        break;
                    }
                    case 1: {
                        BrowserLauncherFactory.get().open(WorkspaceShutdownTimer.this.preferences.getProperty("website.upgrade"));
                    }
                }
            }
        })) {
            this.register(new ShutdownCallback());
        }
    }

    private void trial() {
        this.trialService.install(new TrialKeyLicenseService.Callback(){

            public void failure(final InvalidLicenseException failure) {
                log.warn(String.format("Invalid trial key. %s", failure.getDetail()));
                WorkspaceShutdownTimer.this.controller.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Missing registration", (String)"Registration"), (String)failure.getDetail(), (String)LocaleFactory.localizedString((String)"Buy", (String)"Registration"), (String)LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), null);
                        alert.setAlertStyle(0);
                        alert.setShowsHelp(true);
                        alert.setDelegate(new ProxyController(){

                            public boolean alertShowHelp(NSAlert alert) {
                                BrowserLauncherFactory.get().open(ProviderHelpServiceFactory.get().help());
                                return true;
                            }
                        }.id());
                        switch (new ModalPanelAlertRunner().run(alert)) {
                            case 1: {
                                BrowserLauncherFactory.get().open(WorkspaceShutdownTimer.this.preferences.getProperty("website.buy"));
                            }
                        }
                    }
                });
            }

            public void installed(final License trial) {
                Date expiry;
                if (new LicenseVerifierChain(new LicenseVerifier[]{trial, new ExpiryLicenseVerifier(trial)}).verify((LicenseVerifierCallback)new DisabledLicenseVerifierCallback())) {
                    WorkspaceShutdownTimer.this.unregister();
                }
                try {
                    expiry = new ISO8601DateParser().parse(trial.getValue("Expiry"));
                }
                catch (InvalidDateException e) {
                    log.error("Failure parsing expiry in registration key. " + e.getMessage());
                    return;
                }
                WorkspaceShutdownTimer.this.controller.invoke((MainAction)new DefaultMainAction(){

                    public void run() {
                        NSAlert alert = NSAlert.alert((String)trial.toString(), (String)MessageFormat.format(LocaleFactory.localizedString((String)"Your trial key will expire on {0}.", (String)"Registration"), UserDateFormatterFactory.get().getShortFormat(expiry.getTime())), (String)LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), null, null);
                        alert.setAlertStyle(1);
                        new ModalPanelAlertRunner().run(alert);
                    }
                });
            }
        });
    }

    private class ShutdownCallback
    implements AbstractShutdownTimer.Callback {
        private ShutdownCallback() {
        }

        public void done() {
            WorkspaceShutdownTimer.this.controller.invoke((MainAction)new DefaultMainAction(){

                public void run() {
                    NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Missing Registration", (String)"Registration"), (String)LocaleFactory.localizedString((String)"No valid registration key found. Please purchase a license.", (String)"Registration"), (String)LocaleFactory.localizedString((String)"Buy", (String)"Registration"), (String)LocaleFactory.localizedString((String)"Quit", (String)"Main"), (String)LocaleFactory.localizedString((String)"Request Trial", (String)"Registration"));
                    switch (new ModalPanelAlertRunner().run(alert)) {
                        case -1: {
                            WorkspaceShutdownTimer.this.trial();
                            break;
                        }
                        case 1: {
                            BrowserLauncherFactory.get().open(WorkspaceShutdownTimer.this.preferences.getProperty("website.buy"));
                        }
                        default: {
                            ModalPanelAlertRunner.abort();
                            NSApplication.sharedApplication().terminate(null);
                        }
                    }
                }
            });
        }
    }
}

