/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.iterate.mountainduck.service.PasteboardService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkspacePasteboardService
implements PasteboardService {
    private static final Logger log = LogManager.getLogger((String)WorkspacePasteboardService.class.getName());

    public void add(PasteboardService.Type type, String content) throws LocalAccessDeniedException {
        switch (type) {
            case url: 
            case string: {
                NSPasteboard pboard = NSPasteboard.generalPasteboard();
                pboard.declareTypes(NSArray.arrayWithObject((NSObject)NSString.stringWithString((String)"NSStringPboardType")), null);
                if (pboard.setStringForType(content, "NSStringPboardType")) break;
                log.error(String.format("Error writing content to %s", "NSStringPboardType"));
                break;
            }
            default: {
                throw new LocalAccessDeniedException(String.format("Unsupported pasteboard type %s", type));
            }
        }
    }
}

