/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.binding.WindowController;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordCallbackFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionListener;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.ui.cocoa.callback.PromptAlertCallback;
import ch.cyberduck.ui.cocoa.callback.PromptPasswordCallback;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.service.ShareProviderService;
import ch.iterate.mountainduck.service.worker.AlertDownloadShareWorker;
import ch.iterate.mountainduck.service.worker.AlertUploadShareWorker;
import ch.iterate.mountainduck.service.worker.dracoon.SDSCreateDownloadShareController;
import ch.iterate.mountainduck.service.worker.dracoon.SDSCreateUploadShareController;
import ch.iterate.mountainduck.service.worker.dracoon.SDSDownloadShareWorker;
import ch.iterate.mountainduck.service.worker.dracoon.SDSUploadShareWorker;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PromptShareProviderService
implements ShareProviderService {
    private static final Logger log = LogManager.getLogger((String)PromptShareProviderService.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(final Controller controller, final Filesystem fs, final Path file) {
        switch (fs.getHost().getProtocol().getType()) {
            case dracoon: {
                try {
                    Session session = fs.getPool().borrow();
                    try {
                        final CountDownLatch signal = new CountDownLatch(1);
                        final SDSCreateDownloadShareController c = new SDSCreateDownloadShareController(file){

                            public void callback(int returncode) {
                                switch (returncode) {
                                    case 1: {
                                        this.disable();
                                        controller.background((BackgroundAction)new WorkerBackgroundAction((BackgroundActionListener)this, (SessionPool)fs.getPool(), (Worker)new SDSDownloadShareWorker(this, signal, file, (PasswordCallback)new PromptPasswordCallback((WindowController)this), this.toOptions()), (ProgressListener)controller, (AlertCallback)new PromptAlertCallback((WindowController)this)));
                                        break;
                                    }
                                    case -1: {
                                        signal.countDown();
                                    }
                                }
                            }
                        }.withConfiguration(((SDSSession)session).generalSettingsInfo(), ((SDSSession)session).systemDefaults(), ((SDSSession)session).shareClassificationsPolicies());
                        int option = new ModalPanelAlertRunner().run(c, signal, ModalPanelAlertRunner.CloseCallback.noop, ModalPanelAlertRunner.SignalCallback.noop);
                        switch (option) {
                            default: 
                        }
                        controller.invoke((MainAction)new DefaultMainAction(){

                            public void run() {
                                c.window().orderOut(null);
                            }
                        });
                    }
                    finally {
                        fs.getPool().release(session);
                    }
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Ignore failure %s", new Object[]{e}));
                }
                break;
            }
            default: {
                controller.background((BackgroundAction)new WorkerBackgroundAction(controller, (SessionPool)fs.getPool(), new AlertDownloadShareWorker<Object>(PasswordCallbackFactory.get((Controller)controller), file, null)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(final Controller controller, final Filesystem fs, final Path file) {
        switch (fs.getHost().getProtocol().getType()) {
            case dracoon: {
                try {
                    Session session = fs.getPool().borrow();
                    try {
                        final CountDownLatch signal = new CountDownLatch(1);
                        final SDSCreateUploadShareController c = new SDSCreateUploadShareController(file){

                            public void callback(int returncode) {
                                switch (returncode) {
                                    case 1: {
                                        this.disable();
                                        controller.background((BackgroundAction)new WorkerBackgroundAction((BackgroundActionListener)this, (SessionPool)fs.getPool(), (Worker)new SDSUploadShareWorker(this, signal, file, (PasswordCallback)new PromptPasswordCallback((WindowController)this), this.toOptions()), (ProgressListener)controller, (AlertCallback)new PromptAlertCallback((WindowController)this)));
                                        break;
                                    }
                                    case -1: {
                                        signal.countDown();
                                    }
                                }
                            }
                        }.withConfiguration(((SDSSession)session).generalSettingsInfo(), ((SDSSession)session).systemDefaults());
                        int option = new ModalPanelAlertRunner().run(c, signal, ModalPanelAlertRunner.CloseCallback.noop, ModalPanelAlertRunner.SignalCallback.noop);
                        switch (option) {
                            default: 
                        }
                        controller.invoke((MainAction)new DefaultMainAction(){

                            public void run() {
                                c.window().orderOut(null);
                            }
                        });
                    }
                    finally {
                        fs.getPool().release(session);
                    }
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Ignore failure %s", e.getDetail()));
                }
                break;
            }
            default: {
                controller.background((BackgroundAction)new WorkerBackgroundAction(controller, (SessionPool)fs.getPool(), new AlertUploadShareWorker<Object>(PasswordCallbackFactory.get((Controller)controller), file, null)));
            }
        }
    }
}

