/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSNumber;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.features.Quota;
import ch.iterate.mountainduck.service.DiskUsageService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.ObjCObjectByReference;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSError;

public class NSURLDiskUsageService
implements DiskUsageService {
    private static final Logger log = LogManager.getLogger((String)NSURLDiskUsageService.class.getName());

    public Quota.Space find(Local volume) throws LocalAccessDeniedException {
        ObjCObjectByReference error = new ObjCObjectByReference();
        NSDictionary dict = NSURL.fileURLWithPath((String)volume.getAbsolute()).resourceValuesForKeys_error(NSArray.arrayWithObject((String)"NSURLVolumeAvailableCapacityKey"), error);
        if (null == dict) {
            NSError f = (NSError)error.getValueAs(NSError.class);
            if (null == f) {
                throw new LocalAccessDeniedException(volume.getAbsolute());
            }
            throw new LocalAccessDeniedException(String.format("%s", f.localizedDescription()));
        }
        long available = Long.MAX_VALUE;
        if (dict.objectForKey("NSURLVolumeAvailableCapacityKey") != null && dict.objectForKey("NSURLVolumeAvailableCapacityKey").isKindOfClass(Rococoa.createClass((String)"NSNumber", NSNumber._Class.class))) {
            NSNumber number = (NSNumber)Rococoa.cast((ObjCObject)dict.objectForKey("NSURLVolumeAvailableCapacityKey"), NSNumber.class);
            available = number.longValue();
        }
        long total = Long.MAX_VALUE;
        if (dict.objectForKey("NSURLVolumeTotalCapacityKey") != null && dict.objectForKey("NSURLVolumeTotalCapacityKey").isKindOfClass(Rococoa.createClass((String)"NSNumber", NSNumber._Class.class))) {
            NSNumber number = (NSNumber)Rococoa.cast((ObjCObject)dict.objectForKey("NSURLVolumeTotalCapacityKey"), NSNumber.class);
            total = number.longValue();
        }
        Quota.Space quota = new Quota.Space(Long.valueOf(total - available), Long.valueOf(available));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Determined %d free disk space on %s", quota.available, volume));
        }
        return quota;
    }
}

