/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSFileManager;
import ch.cyberduck.binding.foundation.NSNumber;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.features.Quota;
import ch.iterate.mountainduck.service.DiskUsageService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.ObjCObjectByReference;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSError;

public class NSFileManagerDiskUsageService
implements DiskUsageService {
    private static final Logger log = LogManager.getLogger((String)NSFileManagerDiskUsageService.class.getName());

    public Quota.Space find(Local volume) throws LocalAccessDeniedException {
        NSObject NSFileSystemSize;
        NSObject NSFileSystemFreeSize;
        long free = Long.MAX_VALUE;
        ObjCObjectByReference error = new ObjCObjectByReference();
        NSDictionary dict = NSFileManager.defaultManager().attributesOfFileSystemForPath_error(volume.getAbsolute(), error);
        if (null == dict) {
            NSError f = (NSError)error.getValueAs(NSError.class);
            if (null == f) {
                throw new LocalAccessDeniedException(volume.getAbsolute());
            }
            throw new LocalAccessDeniedException(String.format("%s", f.localizedDescription()));
        }
        if (dict.objectForKey("NSFileSystemFreeSize") != null && (NSFileSystemFreeSize = dict.objectForKey("NSFileSystemFreeSize")).isKindOfClass(Rococoa.createClass((String)"NSNumber", NSNumber._Class.class))) {
            NSNumber number = (NSNumber)Rococoa.cast((ObjCObject)NSFileSystemFreeSize, NSNumber.class);
            free = number.longValue();
        }
        long size = Long.MAX_VALUE;
        if (dict.objectForKey("NSFileSystemSize") != null && (NSFileSystemSize = dict.objectForKey("NSFileSystemSize")).isKindOfClass(Rococoa.createClass((String)"NSNumber", NSNumber._Class.class))) {
            NSNumber number = (NSNumber)Rococoa.cast((ObjCObject)NSFileSystemSize, NSNumber.class);
            size = number.longValue();
        }
        Quota.Space quota = new Quota.Space(Long.valueOf(size - free), Long.valueOf(free));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Determined %d free disk space on %s", quota.available, volume));
        }
        return quota;
    }
}

