/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.controller.InfoController;
import ch.cyberduck.ui.cocoa.controller.ReloadCallback;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.service.InfoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FinderInfoService
implements InfoService {
    private static final Map<Filesystem, InfoController> open = new HashMap<Filesystem, InfoController>();
    public final Preferences preferences = PreferencesFactory.get();

    public void open(final Controller controller, final Filesystem fs, final List<Path> files, final InfoService.Reload callback) {
        if (this.preferences.getBoolean("browser.info.inspector") && open.containsKey(fs)) {
            final InfoController info = open.get(fs);
            controller.invoke((MainAction)new DefaultMainAction(){

                public void run() {
                    info.setFiles(files);
                }
            });
            return;
        }
        controller.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                InfoController info = new InfoController(controller, (SessionPool)fs.getPool(), files, new ReloadCallback(){

                    public void done(List<Path> files) {
                        callback.reload(files);
                    }
                }){

                    public void windowWillClose(NSNotification notification) {
                        open.remove(fs);
                        super.windowWillClose(notification);
                    }
                };
                info.loadBundle();
                new ModalPanelAlertRunner().run(info.window());
                open.put(fs, info);
            }
        });
    }
}

