/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity;

import ch.cyberduck.binding.foundation.NSUserDefaults;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.liferay.nativity.control.NativityMessage;
import com.liferay.nativity.control.findersync.FSNativityControlImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;

public class UserDefaultsFSNativityControlImpl
extends FSNativityControlImpl {
    private static final Logger log = LogManager.getLogger((String)UserDefaultsFSNativityControlImpl.class.getName());
    private final NSUserDefaults defaults;

    public UserDefaultsFSNativityControlImpl() {
        String name = String.format("%s.%s", PreferencesFactory.get().getProperty("application.container.teamidentifier"), PreferencesFactory.get().getProperty("application.container.name"));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Using shared defaults %s", name));
        }
        this.defaults = NSUserDefaults.sharedUserDefaults((String)name);
    }

    protected void connected(int port) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Listening on port %d. Write to defaults %s", port, this.defaults));
        }
        this.defaults.setInteger_forKey(new NSInteger((long)port), "nativity.socket.port");
        this.defaults.synchronize();
    }

    public boolean disconnect() {
        this.defaults.removeObjectForKey("nativity.socket.port");
        this.defaults.synchronize();
        return super.disconnect();
    }

    public NativityMessage fireMessage(NativityMessage message) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received message %s", message.getCommand()));
        }
        NativityMessage reply = super.fireMessage(message);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Reply with message value %s", null == reply ? null : reply.getValue()));
        }
        return reply;
    }
}

