/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.nativity;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.local.FinderLocal;
import ch.cyberduck.core.preferences.BundleApplicationResourcesFinder;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sparkle.Sandbox;
import ch.cyberduck.core.unicode.NFCNormalizer;
import ch.cyberduck.core.unicode.UnicodeNormalizer;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.badge.FileOverlayIconService;
import ch.iterate.mountainduck.nativity.FileIconService;
import ch.iterate.mountainduck.service.FileBadgeService;
import com.liferay.nativity.control.NativityControl;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FinderImageFileIconService
extends FileIconService {
    private static final Logger log = LogManager.getLogger((String)FinderImageFileIconService.class.getName());
    private final NativityControl nativity;
    private final Preferences preferences = PreferencesFactory.get();
    private final UnicodeNormalizer normalizer = new NFCNormalizer();

    public FinderImageFileIconService(NativityControl nativity) {
        super(nativity);
        this.nativity = nativity;
        if (this.preferences.getBoolean("finderextension.pluginkit.enable") && !Sandbox.get().isSandboxed()) {
            try {
                int exit_add;
                int exit_enable = new ProcessBuilder("/usr/bin/pluginkit", "-e", "use", "-i", String.format("%s.findersync", this.preferences.getProperty("bundle.identifier"))).start().waitFor();
                if (0 != exit_enable) {
                    log.warn(String.format("Failure running pluginkit (enable) with exit code %d", exit_enable));
                }
                if (0 != (exit_add = new ProcessBuilder("/usr/bin/pluginkit", "-a", new FinderLocal(new BundleApplicationResourcesFinder().find().getParent(), String.format("PlugIns/%s Finder Integration.appex", this.preferences.getProperty("application.name"))).getAbsolute()).start().waitFor())) {
                    log.warn(String.format("Failure running pluginkit (add) with exit code %d", exit_add));
                }
            }
            catch (InterruptedException e) {
                log.error("Failure running pluginkit");
            }
            catch (IOException e) {
                log.warn(String.format("Failure running pluginkit. %s", e.getMessage()));
            }
        }
    }

    public void onSocketOpen() {
        this.register(new FileBadgeService.Icon("NSLockUnlockedTemplate", "Unlocked", Integer.valueOf(1 << AbstractPath.Type.decrypted.ordinal())));
        this.register(new FileBadgeService.Icon("overlay-infinite.tiff", LocaleFactory.localizedString((String)"Online", (String)"Disk"), Integer.valueOf(2 << FileOverlayIconService.Badge.online.ordinal())));
        this.register(new FileBadgeService.Icon("overlay-uptodate.tiff", LocaleFactory.localizedString((String)"Up to date", (String)"Disk"), Integer.valueOf(2 << FileOverlayIconService.Badge.uptodate.ordinal())));
        this.register(new FileBadgeService.Icon("overlay-sync.tiff", LocaleFactory.localizedString((String)"In Sync", (String)"Disk"), Integer.valueOf(2 << FileOverlayIconService.Badge.synced.ordinal())));
        this.register(new FileBadgeService.Icon("overlay-syncing.tiff", LocaleFactory.localizedString((String)"Sync in Progress", (String)"Disk"), Integer.valueOf(2 << FileOverlayIconService.Badge.inprogress.ordinal())));
        this.register(new FileBadgeService.Icon("overlay-error.tiff", LocaleFactory.localizedString((String)"Sync Error", (String)"Disk"), Integer.valueOf(2 << FileOverlayIconService.Badge.error.ordinal())));
        this.register(new FileBadgeService.Icon("overlay-ignored.tiff", LocaleFactory.localizedString((String)"Ignored", (String)"Disk"), Integer.valueOf(2 << FileOverlayIconService.Badge.ignored.ordinal())));
        this.register(new FileBadgeService.Icon("overlay-pause.tiff", LocaleFactory.localizedString((String)"Sync Paused", (String)"Disk"), Integer.valueOf(2 << FileOverlayIconService.Badge.paused.ordinal())));
        super.onSocketOpen();
    }

    protected boolean filter(Local file) {
        Set observed = this.nativity.getAllObservedFolders();
        for (String f : observed) {
            Local folder = LocalFactory.get((String)f);
            if (!file.getParent().equals((Object)folder) && !file.equals((Object)folder)) continue;
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Skip icon update for file %s not observed", file));
        }
        return false;
    }

    protected Path map(Set<Filesystem> mountpoints, String selected) {
        return super.map(mountpoints, this.normalizer.normalize((CharSequence)selected).toString());
    }
}

