/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.FinderSidebarService;
import ch.cyberduck.core.local.SidebarService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.NamedThreadFactory;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SidebarFilesystemListener
implements FilesystemMountRegistry.Listener {
    private static final Logger log = LogManager.getLogger((String)SidebarFilesystemListener.class.getName());
    private static final ExecutorService sidebar = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("sidebar"));
    private final SidebarService finder = new FinderSidebarService(SidebarService.List.valueOf((String)PreferencesFactory.get().getProperty("finder.sidebar.listtype")));

    public void mounted(final Filesystem fs) {
        Local volume;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add sidebar item for %s", fs));
        }
        if (null == (volume = fs.getMountpoint())) {
            return;
        }
        sidebar.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    SidebarFilesystemListener.this.finder.add(volume, SidebarFilesystemListener.normalize(BookmarkNameProvider.toString((Host)fs.getHost())));
                    return true;
                }
                catch (LocalAccessDeniedException e) {
                    log.warn(String.format("Failure adding sidebar favorite %s", volume));
                    return false;
                }
            }
        });
    }

    public void unmounted(Filesystem fs) {
        Local volume;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Remove sidebar item for %s", fs));
        }
        if (null == (volume = fs.getMountpoint())) {
            return;
        }
        try {
            this.finder.remove(volume);
        }
        catch (LocalAccessDeniedException e) {
            log.warn(String.format("Failure removing sidebar favorite %s", volume));
        }
    }

    private static String normalize(String name) {
        return StringUtils.replace((String)name, (String)":", (String)"");
    }
}

