/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.iterate.mountainduck.fs.DirectoryVolumeService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SidebarDirectoryVolumeService
extends DirectoryVolumeService {
    private static final Logger log = LogManager.getLogger((String)SidebarDirectoryVolumeService.class.getName());

    protected boolean isLocked(final Local directory) {
        if (super.isLocked(directory)) {
            return true;
        }
        if (directory.exists()) {
            try {
                Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        try {
                            AttributedList contents = directory.list();
                            return !contents.isEmpty();
                        }
                        catch (AccessDeniedException e) {
                            return true;
                        }
                    }
                }).get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.warn(String.format("Failure to determine if directory %s is empty. %s", directory, e.getMessage()));
                return true;
            }
        }
        return false;
    }
}

