/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application.menu;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSCopying;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableAttributedString;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.local.ApplicationLauncherFactory;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.local.RevealService;
import ch.cyberduck.core.local.RevealServiceFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCache;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.cyberduck.ui.cocoa.controller.ActivityController;
import ch.cyberduck.ui.cocoa.controller.ActivityControllerFactory;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import ch.cyberduck.ui.cocoa.controller.PreferencesController;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.HistoryMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.MenuCallback;
import ch.cyberduck.ui.cocoa.delegate.RendezvousMenuDelegate;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import ch.iterate.mountainduck.application.StatusBarBookmarkController;
import ch.iterate.mountainduck.application.StatusBarController;
import ch.iterate.mountainduck.application.StatusBarPreferencesController;
import ch.iterate.mountainduck.application.menu.BookmarkMenuHandler;
import ch.iterate.mountainduck.application.menu.ConnectMenuCallback;
import ch.iterate.mountainduck.application.menu.MenuCallbackDelegate;
import ch.iterate.mountainduck.application.menu.RevealMenuCallback;
import ch.iterate.mountainduck.application.menu.SortMenuDelegate;
import ch.iterate.mountainduck.application.menu.StatusBarBonjourMenuDelegate;
import ch.iterate.mountainduck.application.menu.StatusBarHistoryMenuDelegate;
import ch.iterate.mountainduck.application.menu.StatusBarSearchController;
import ch.iterate.mountainduck.fs.ConnectMode;
import ch.iterate.mountainduck.fs.DelayedSubmitter;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.service.BackgroundStatusListener;
import ch.iterate.mountainduck.service.DisabledRevealService;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import com.google.common.util.concurrent.RateLimiter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCClass;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public class StatusBarBookmarkMenuDelegate
extends CollectionMenuDelegate<Host>
implements BackgroundStatusListener {
    private static final Logger log = LogManager.getLogger((String)StatusBarBookmarkMenuDelegate.class.getName());
    private static final NSDictionary PROGRESS_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.monospacedDigitSystemFontOfSize((double)NSFont.systemFontSize()), BundleController.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE, ExtendedNSColor.secondaryLabelColor()}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSParagraphStyle", "NSColor"}));
    private static final NSDictionary STATUS_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.monospacedDigitSystemFontOfSize((double)NSFont.smallSystemFontSize()), BundleController.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE, ExtendedNSColor.secondaryLabelColor()}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSParagraphStyle", "NSColor"}));
    public static final NSDictionary HELP_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.menuFontOfSize((double)NSFont.smallSystemFontSize()), BundleController.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE, ExtendedNSColor.secondaryLabelColor()}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSParagraphStyle", "NSColor"}));
    private final Preferences preferences = PreferencesFactory.get();
    private final IconCache<NSImage> icons = IconCacheFactory.get();
    private final FilesystemMountRegistry registry = FilesystemMountRegistry.get();
    private final StatusBarController controller;
    private final StatusBarSearchController search;
    private final AbstractHostCollection bookmarks;
    private final BookmarkMenuHandler handler;
    private final MenuCallback callback;
    private final NSMenu historyMenu = NSMenu.menu();
    private final HistoryMenuDelegate historyMenuDelegate;
    private final NSMenu rendezvousMenu = NSMenu.menu();
    private final RendezvousMenuDelegate rendezvousMenuDelegate;
    private final NSMenu sortMenu = NSMenu.menu();
    private final SortMenuDelegate sortMenuDelegate;
    private final NSMenuItem syncMenu = NSMenuItem.itemWithTitle((String)LocaleFactory.localizedString((String)"Up to date", (String)"Disk"), null, (String)"");
    private final NSMenuItem progressMenu = NSMenuItem.itemWithTitle((String)LocaleFactory.localizedString((String)"Idle", (String)"Status"), null, (String)"");
    private final NSMenuItem searchMenu = NSMenuItem.itemWithTitle((String)LocaleFactory.localizedString((String)"Search\u2026", (String)"Main"), null, (String)"");
    private final NSMenu syncSubMenu = NSMenu.menu();
    private final List<MenuItemBuilder> top;
    private final List<MenuItemBuilder> bottom;
    private HostFilter filter = HostFilter.NONE;
    private final RateLimiter limiter = RateLimiter.create((double)(1000.0 / (double)this.preferences.getInteger("menu.sync.update.delay.ms")));
    private final DelayedSubmitter<InterfaceRefresh, MainAction> delayedSubmitter = new DelayedSubmitter(arg_0 -> ((StatusBarBookmarkMenuDelegate)this).invoke(arg_0), this.preferences.getLong("menu.sync.update.delay.ms"));
    private final AtomicBoolean open = new AtomicBoolean(false);
    public static final String GROUP_MENU_IDENTIFIER = "BOOKMARK_GROUP";
    public static final String SEARCH_MENU_IDENTIFIER = "SEARCH_MENU";

    public StatusBarBookmarkMenuDelegate(StatusBarController controller, StatusBarSearchController search, AbstractHostCollection bookmarks, AbstractHostCollection history, AbstractHostCollection bonjour) {
        super((Collection)bookmarks);
        this.controller = controller;
        this.search = search;
        this.bookmarks = bookmarks;
        this.bookmarks.addListener((CollectionListener)new MenuUpdateCollectionListener((AbstractMenuDelegate)this));
        this.historyMenuDelegate = new StatusBarHistoryMenuDelegate(controller, history, new MenuCallbackDelegate(new ConnectMenuCallback(controller, history), new RevealMenuCallback(history)));
        this.rendezvousMenuDelegate = new StatusBarBonjourMenuDelegate(controller, bonjour, new MenuCallbackDelegate(new ConnectMenuCallback(controller, bonjour), new RevealMenuCallback(bonjour)));
        this.sortMenuDelegate = new SortMenuDelegate(this, bookmarks);
        this.historyMenu.setDelegate(this.historyMenuDelegate.id());
        this.rendezvousMenu.setDelegate(this.rendezvousMenuDelegate.id());
        this.sortMenu.setDelegate(this.sortMenuDelegate.id());
        this.callback = new MenuCallbackDelegate(new ConnectMenuCallback(controller, bookmarks), new RevealMenuCallback(bookmarks));
        this.handler = new BookmarkMenuHandler(controller, bookmarks);
        this.top = new ArrayList<MenuItemBuilder>();
        this.top.add(new MenuItemBuilder(LocaleFactory.localizedString((String)"Open Connection\u2026", (String)"Main"), Foundation.selector((String)"addBookmarkMenuClicked:"), this.id()));
        if (this.preferences.getBoolean("menu.sort.enable")) {
            this.top.add(new MenuItemBuilder(LocaleFactory.localizedString((String)"Sort By", (String)"Main")).withSubmenu(this.sortMenu));
        }
        this.bottom = new ArrayList<MenuItemBuilder>();
        if (this.preferences.getBoolean("menu.history.enable")) {
            this.bottom.add(new MenuItemBuilder(LocaleFactory.localizedString((String)"History", (String)"Localizable"), Foundation.selector((String)"historyMenuClicked:"), this.historyMenuDelegate.id()).withImage((NSImage)this.icons.iconNamed("history.tiff", Integer.valueOf(16))).withSubmenu(this.historyMenu));
        }
        if (this.preferences.getBoolean("menu.bonjour.enable")) {
            this.bottom.add(new MenuItemBuilder(LocaleFactory.localizedString((String)"Bonjour", (String)"Main")).withImage((NSImage)this.icons.iconNamed("rendezvous.tiff", Integer.valueOf(16))).withSubmenu(this.rendezvousMenu));
        }
        this.bottom.add(MenuItemBuilder.SEPERATOR);
        this.bottom.add(new MenuItemBuilder(StringUtils.replace((String)LocaleFactory.localizedString((String)"About Cyberduck", (String)"Main"), (String)"Cyberduck", (String)this.preferences.getProperty("application.name")), Foundation.selector((String)"aboutMenuClicked:"), this.id()));
        if (this.preferences.getBoolean("menu.help.enable")) {
            this.bottom.add(new MenuItemBuilder(LocaleFactory.localizedString((String)"Help", (String)"Main"), Foundation.selector((String)"helpMenuClicked:"), this.id()));
        }
        if (this.preferences.getBoolean("menu.quota.enable")) {
            this.bottom.add(new MenuItemBuilder(LocaleFactory.localizedString((String)"Extend Quota\u2026", (String)"Disk"), Foundation.selector((String)"quotaMenuClicked:"), this.id()));
        }
        this.bottom.add(new MenuItemBuilder(LocaleFactory.localizedString((String)"Preferences\u2026", (String)"Main"), Foundation.selector((String)"preferencesMenuClicked:"), this.id()));
        this.bottom.add(new MenuItemBuilder(StringUtils.replace((String)LocaleFactory.localizedString((String)"Quit Cyberduck", (String)"Main"), (String)"Cyberduck", (String)this.preferences.getProperty("application.name")), Foundation.selector((String)"quitMenuClicked:"), this.id()));
        this.registry.addListener((FilesystemMountRegistry.Listener)new MenuUpdateRegistryListener((AbstractMenuDelegate)this));
        this.syncSubMenu.setAutoenablesItems(false);
        this.syncMenu.setSubmenu(this.syncSubMenu);
        this.searchMenu.setEnabled(false);
        this.searchMenu.setRepresentedObject(SEARCH_MENU_IDENTIFIER);
        this.searchMenu.setView(search.getSearchView());
    }

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        throw new UnsupportedOperationException();
    }

    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        throw new UnsupportedOperationException();
    }

    public Host itemForIndex(NSInteger row) {
        Host bookmark = (Host)this.bookmarks.get(row.intValue() - this.top.size());
        if (log.isTraceEnabled()) {
            log.trace(String.format("Return %s for row %s", bookmark, row));
        }
        return bookmark;
    }

    public void menuNeedsUpdate(NSMenu menu) {
        this.setStatus(this.syncMenu);
        if (!this.isPopulated()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Build menu %s", menu));
            }
            menu.removeAllItems();
            if (this.preferences.getList("fs.sync.mode.enabled").contains(ConnectMode.selective.name())) {
                menu.addItem(this.syncMenu);
                menu.addItem(this.seperator());
            }
            for (MenuItemBuilder builder : this.top) {
                menu.addItem(builder.build());
            }
            if (!this.bookmarks.isEmpty()) {
                NSMenuItem seperator = this.seperator();
                menu.addItem(seperator);
                if (this.preferences.getBoolean("menu.search.enable")) {
                    menu.addItem(this.searchMenu);
                    this.searchMenu.setRepresentedObject(SEARCH_MENU_IDENTIFIER);
                } else {
                    seperator.setRepresentedObject(SEARCH_MENU_IDENTIFIER);
                }
                this.bookmarkMenuNeedsUpdate(menu);
            }
            menu.addItem(this.seperator());
            for (MenuItemBuilder builder : this.bottom) {
                menu.addItem(builder.build());
            }
            this.setNeedsUpdate(false);
        } else {
            for (Filesystem fs : this.registry.values()) {
                NSInteger index = menu.indexOfItemWithRepresentedObject(fs.getHost().getUuid());
                if (index.intValue() == -1) continue;
                this.handler.setState(fs.getHost(), menu.itemAtIndex(index));
            }
        }
    }

    private void bookmarkMenuNeedsUpdate(NSMenu menu) {
        int start = menu.indexOfItemWithRepresentedObject(SEARCH_MENU_IDENTIFIER).intValue();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add bookmarks to menu %s at %d", menu, start));
        }
        for (int i = menu.numberOfItems().intValue() - 1; i > start; --i) {
            if (menu.itemAtIndex(new NSInteger((long)i)).representedObject() == null) continue;
            menu.removeItemAtIndex(new NSInteger((long)i));
        }
        int position = start;
        Map groups = this.bookmarks.groups(this.filter);
        for (Map.Entry entry : groups.entrySet()) {
            NSMenu submenu;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey()))) {
                NSMenuItem group = NSMenuItem.itemWithTitle((String)((String)entry.getKey()), null, (String)"");
                group.setRepresentedObject(GROUP_MENU_IDENTIFIER);
                NSMutableAttributedString title = NSMutableAttributedString.create((String)((String)entry.getKey()));
                title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", MessageFormat.format(LocaleFactory.localizedString((String)"{0} Bookmarks", (String)"Localizable"), ((List)entry.getValue()).size())), (NSDictionary)HELP_FONT_ATTRIBUTES));
                group.setAttributedTitle((NSAttributedString)title);
                group.setImage((NSImage)IconCacheFactory.get().iconNamed("NSFolder", Integer.valueOf(this.preferences.getInteger("bookmark.menu.icon.size"))));
                group.setOffStateImage(null);
                group.setOnStateImage((NSImage)IconCacheFactory.get().iconNamed("NSStatusAvailable", Integer.valueOf(12)));
                group.setMixedStateImage((NSImage)IconCacheFactory.get().iconNamed("NSStatusPartiallyAvailable", Integer.valueOf(12)));
                group.setState(0);
                for (Host bookmark : (List)entry.getValue()) {
                    this.handler.setState(bookmark, group);
                    if (group.state() != -1 && group.state() != 1) continue;
                    break;
                }
                submenu = NSMenu.menu();
                submenu.setAutoenablesItems(false);
                group.setSubmenu(submenu);
                menu.insertItem_atIndex(group, new NSInteger((long)(++position)));
            } else {
                submenu = menu;
            }
            for (Host bookmark : (List)entry.getValue()) {
                String nickname = BookmarkNameProvider.toString((Host)bookmark);
                NSMenuItem item = NSMenuItem.itemWithTitle((String)nickname, (Selector)this.getDefaultAction(), (String)"");
                NSMutableAttributedString title = NSMutableAttributedString.create((String)nickname);
                if (this.preferences.getBoolean("menu.bookmark.hostname.enable") && this.preferences.getInteger("bookmark.menu.icon.size") >= 24) {
                    title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", bookmark.getHostname()), (NSDictionary)HELP_FONT_ATTRIBUTES));
                }
                if (this.preferences.getBoolean("menu.bookmark.username.enable") && this.preferences.getInteger("bookmark.menu.icon.size") >= 40) {
                    title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", StringUtils.isNotBlank((CharSequence)bookmark.getCredentials().getUsername()) ? bookmark.getCredentials().getUsername() : ""), (NSDictionary)HELP_FONT_ATTRIBUTES));
                }
                item.setAttributedTitle((NSAttributedString)title);
                item.setTitle(nickname);
                if (log.isTraceEnabled()) {
                    log.trace(String.format("Add menu item %s with bookmark %s", item, bookmark));
                }
                item.setTarget(this.id());
                item.setRepresentedObject(bookmark.getUuid());
                item.setImage((NSImage)IconCacheFactory.get().iconNamed(bookmark.getProtocol().icon(), Integer.valueOf(this.preferences.getInteger("bookmark.menu.icon.size"))));
                item.setSubmenu(this.handler.build(bookmark, item));
                if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey()))) {
                    submenu.insertItem_atIndex(item, new NSInteger((long)(++position)));
                    continue;
                }
                submenu.addItem(item);
            }
        }
    }

    public void menuWillOpen(NSMenu menu) {
        this.open.set(true);
    }

    public void menuDidClose(NSMenu menu) {
        this.open.set(false);
    }

    public void refresh(SyncQueue.Status status) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received sync notification %s", status));
        }
        if (this.open.get()) {
            DefaultMainAction action = new DefaultMainAction(){

                public void run() {
                    StatusBarBookmarkMenuDelegate.this.setStatus(StatusBarBookmarkMenuDelegate.this.syncMenu);
                }
            };
            if (this.limiter.tryAcquire(0L, TimeUnit.MILLISECONDS)) {
                this.invoke((MainAction)action);
            } else {
                this.delayedSubmitter.submit((Object)InterfaceRefresh.status, (Object)action);
            }
        }
    }

    public void refresh(DirectoryIndexer.Status status) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received indexer notification %s", status));
        }
        if (this.open.get()) {
            DefaultMainAction action = new DefaultMainAction(){

                public void run() {
                    StatusBarBookmarkMenuDelegate.this.setStatus(StatusBarBookmarkMenuDelegate.this.syncMenu);
                }
            };
            if (this.limiter.tryAcquire(0L, TimeUnit.MILLISECONDS)) {
                this.invoke((MainAction)action);
            } else {
                this.delayedSubmitter.submit((Object)InterfaceRefresh.status, (Object)action);
            }
        }
    }

    public void refresh(final TransferProgress progress) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received progress notification %s", progress));
        }
        if (this.open.get()) {
            DefaultMainAction action = new DefaultMainAction(){

                public void run() {
                    StatusBarBookmarkMenuDelegate.this.progressMenu.setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)progress.getProgress(), (NSDictionary)PROGRESS_FONT_ATTRIBUTES));
                }
            };
            if (this.limiter.tryAcquire(0L, TimeUnit.MILLISECONDS)) {
                this.invoke((MainAction)action);
            } else {
                this.delayedSubmitter.submit((Object)InterfaceRefresh.progress, (Object)action);
            }
        }
    }

    public void revealRecentMenuItemClicked(NSMenuItem sender) {
        RevealServiceFactory.get().reveal(LocalFactory.get((String)sender.representedObject()));
    }

    public void openRecentMenuItemClicked(NSMenuItem sender) {
        ApplicationLauncherFactory.get().open(LocalFactory.get((String)sender.representedObject()));
    }

    private void setStatus(NSMenuItem syncMenu) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Rebuild menu %s", syncMenu));
        }
        syncMenu.submenu().removeAllItems();
        FilesystemMountRegistry.Status status = this.registry.getStatus();
        NSMutableAttributedString title = NSMutableAttributedString.create((String)status.title);
        switch (status.sync) {
            case idle: {
                syncMenu.setImage((NSImage)this.icons.iconNamed("overlay-uptodate.tiff", Integer.valueOf(this.preferences.getInteger("menu.sync.icon.size"))));
                title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", LocaleFactory.localizedString((String)"Idle", (String)"Status")), (NSDictionary)STATUS_FONT_ATTRIBUTES));
                break;
            }
            case busy: {
                syncMenu.setImage((NSImage)this.icons.iconNamed("overlay-syncing.tiff", Integer.valueOf(this.preferences.getInteger("menu.sync.icon.size"))));
                if (!SyncQueue.Stats.IDLE.equals((Object)status.queue)) {
                    title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s, %s", MessageFormat.format(LocaleFactory.localizedString((String)"{0} Items", (String)"Localizable"), status.queue.files), SizeFormatterFactory.get().format(status.queue.bytes)), (NSDictionary)STATUS_FONT_ATTRIBUTES));
                    break;
                }
                if (DirectoryIndexer.Stats.IDLE.equals((Object)status.indexer)) break;
                title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", MessageFormat.format(LocaleFactory.localizedString((String)"{0} Items", (String)"Localizable"), status.indexer.files)), (NSDictionary)STATUS_FONT_ATTRIBUTES));
                break;
            }
            case paused: {
                syncMenu.setImage((NSImage)this.icons.iconNamed("overlay-pause.tiff", Integer.valueOf(this.preferences.getInteger("menu.sync.icon.size"))));
                title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", LocaleFactory.localizedString((String)"Idle", (String)"Status")), (NSDictionary)STATUS_FONT_ATTRIBUTES));
            }
        }
        syncMenu.setAttributedTitle((NSAttributedString)title);
        switch (status.sync) {
            case idle: 
            case busy: {
                NSMenuItem pauseAction = syncMenu.submenu().addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Pause Sync", (String)"Disk"), Foundation.selector((String)"pauseSyncClicked:"), "");
                pauseAction.setTarget(this.id());
                break;
            }
            case paused: {
                NSMenuItem nSMenuItem = syncMenu.submenu().addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Resume Sync", (String)"Disk"), Foundation.selector((String)"resumeSyncClicked:"), "");
                nSMenuItem.setTarget(this.id());
            }
        }
        if (this.preferences.getBoolean("menu.sync.queue.enable")) {
            syncMenu.submenu().addItem(this.seperator());
            this.progressMenu.setEnabled(false);
            syncMenu.submenu().addItem(this.progressMenu);
            switch (status.sync) {
                case busy: {
                    this.progressMenu.setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)LocaleFactory.localizedString((String)"Sync in Progress", (String)"Disk"), (NSDictionary)PROGRESS_FONT_ATTRIBUTES));
                    break;
                }
                case idle: {
                    this.progressMenu.setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)LocaleFactory.localizedString((String)"Idle", (String)"Status"), (NSDictionary)PROGRESS_FONT_ATTRIBUTES));
                    break;
                }
                case paused: {
                    this.progressMenu.setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)LocaleFactory.localizedString((String)"Sync Paused", (String)"Disk"), (NSDictionary)PROGRESS_FONT_ATTRIBUTES));
                }
            }
            for (Map.Entry entry2 : status.inprogress.entrySet()) {
                for (FileHistory.Item item : (List)entry2.getValue()) {
                    NSMenuItem menuItem = NSMenuItem.itemWithTitle((String)item.remote.getName(), (Selector)Foundation.selector((String)"revealRecentMenuItemClicked:"), (String)"");
                    boolean exists = item.operation == Operation.write;
                    menuItem.setEnabled(exists);
                    menuItem.setTarget(exists ? this.id() : null);
                    menuItem.setRepresentedObject(exists ? item.local.getAbsolute() : null);
                    menuItem.setImage((NSImage)this.icons.fileIcon(item.remote, Integer.valueOf(16)));
                    syncMenu.submenu().addItem(menuItem);
                }
            }
        }
        if (this.preferences.getBoolean("menu.sync.history.enable")) {
            syncMenu.submenu().addItem(this.seperator());
            NSMenuItem titleHistory = NSMenuItem.itemWithTitle((String)LocaleFactory.localizedString((String)"Recent Files", (String)"Disk"), null, (String)"");
            titleHistory.setEnabled(false);
            syncMenu.submenu().addItem(titleHistory);
            for (Map.Entry entry3 : status.history.entrySet()) {
                for (FileHistory.Item item : (List)entry3.getValue()) {
                    String origin;
                    NSMutableAttributedString itemTitle = NSMutableAttributedString.create((String)String.format("%s\n", item.remote.getName()));
                    if (item.application != Application.notfound) {
                        itemTitle.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("%s\n", ApplicationFinderFactory.get().getDescription(item.application.getIdentifier()).getName()), (NSDictionary)HELP_FONT_ATTRIBUTES));
                    }
                    itemTitle.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("%s\n", UserDateFormatterFactory.get().getMediumFormat(item.timestamp.longValue())), (NSDictionary)HELP_FONT_ATTRIBUTES));
                    block14 : switch (item.origin) {
                        case local: {
                            switch (item.operation) {
                                case delete: {
                                    origin = LocaleFactory.localizedString((String)"Deleted by You", (String)"Disk");
                                    break block14;
                                }
                            }
                            origin = LocaleFactory.localizedString((String)"Updated by You", (String)"Disk");
                            break;
                        }
                        default: {
                            switch (item.operation) {
                                case delete: {
                                    origin = MessageFormat.format(LocaleFactory.localizedString((String)"Deleted on {0}", (String)"Disk"), ((Host)entry3.getKey()).getHostname());
                                    break block14;
                                }
                            }
                            origin = MessageFormat.format(LocaleFactory.localizedString((String)"Updated on {0}", (String)"Disk"), ((Host)entry3.getKey()).getHostname());
                        }
                    }
                    itemTitle.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)origin, (NSDictionary)HELP_FONT_ATTRIBUTES));
                    NSMenuItem menuItem = syncMenu.submenu().addItemWithTitle_action_keyEquivalent(item.remote.getName(), Foundation.selector((String)"revealRecentMenuItemClicked:"), "");
                    menuItem.setAttributedTitle((NSAttributedString)itemTitle);
                    boolean enabled = item.operation != Operation.delete;
                    menuItem.setEnabled(enabled);
                    menuItem.setTarget(enabled ? this.id() : null);
                    menuItem.setRepresentedObject(enabled ? item.local.getAbsolute() : null);
                    menuItem.setImage((NSImage)this.icons.fileIcon(item.remote, Integer.valueOf(32)));
                    switch (item.operation) {
                        case delete: {
                            menuItem.setEnabled(false);
                        }
                    }
                    if (null != item.failure) {
                        menuItem.setState(1);
                    }
                    NSImage errorImage = (NSImage)this.icons.iconNamed("NSCaution", Integer.valueOf(16));
                    errorImage.setTemplate(false);
                    menuItem.setOnStateImage(errorImage);
                }
            }
            syncMenu.submenu().addItem(this.seperator());
            NSMenuItem nSMenuItem = NSMenuItem.itemWithTitle((String)LocaleFactory.localizedString((String)"Clear Menu"), (Selector)Foundation.selector((String)"clearMenuItemClicked:"), (String)"");
            nSMenuItem.setEnabled(status.history.entrySet().stream().anyMatch(entry -> !((List)entry.getValue()).isEmpty()));
            nSMenuItem.setTarget(this.id());
            syncMenu.submenu().addItem(nSMenuItem);
        }
    }

    public void clearMenuItemClicked(NSMenuItem sender) {
        Set mounts = this.registry.values();
        for (Filesystem fs : mounts) {
            FileHistory history = fs.getHistory();
            history.clear();
        }
        this.setNeedsUpdate(true);
    }

    public boolean validateMenuItem(NSMenuItem item) {
        return this.handler.validateMenuItem(item);
    }

    public Selector getDefaultAction() {
        return Foundation.selector((String)"menuItemClicked:");
    }

    public void menuItemClicked(NSMenuItem sender) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Menu item clicked %s", sender));
        }
        this.callback.selected(sender);
    }

    public void addBookmarkMenuClicked(ID sender) {
        final Host bookmark = new Host(ProtocolFactory.get().forName(this.preferences.getProperty("connection.protocol.default")));
        if (this.preferences.getBoolean("menu.bookmark.add.enable") && this.preferences.getBoolean("menu.bookmark.edit.enable")) {
            this.bookmarks.add((Object)bookmark);
            this.sortMenuDelegate.sort();
            BookmarkController c = StatusBarBookmarkController.Factory.create(this.controller, this.bookmarks, bookmark);
            new ModalPanelAlertRunner().run(c.window());
        } else {
            this.controller.connect(bookmark, new RevealService(){

                public boolean reveal(Local local, boolean select) {
                    StatusBarBookmarkMenuDelegate.this.bookmarks.add((Object)bookmark);
                    StatusBarBookmarkMenuDelegate.this.sortMenuDelegate.sort();
                    return PreferencesFactory.get().getBoolean("browser.open.untitled") ? RevealServiceFactory.get().reveal(local, select) : new DisabledRevealService().reveal(local, select);
                }
            });
        }
    }

    public void quitMenuClicked(ID sender) {
        ModalPanelAlertRunner.abort();
        NSApplication.sharedApplication().terminate(sender);
    }

    public void aboutMenuClicked(ID sender) {
        NSApplication application = NSApplication.sharedApplication();
        application.activateIgnoringOtherApps(true);
        application.orderFrontStandardAboutPanelWithOptions(NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((String[])new String[]{String.format("%s\n%s", this.preferences.getProperty("application.copyright"), LicenseFactory.find().toString())}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"Copyright"})));
    }

    public void helpMenuClicked(ID sender) {
        BrowserLauncherFactory.get().open(ProviderHelpServiceFactory.get().help());
    }

    public void quotaMenuClicked(ID sender) {
        Protocol protocol = ProtocolFactory.get().forName(this.preferences.getProperty("connection.protocol.default"));
        BrowserLauncherFactory.get().open(StringUtils.isNotBlank((CharSequence)((CharSequence)protocol.getProperties().get("quota.notification.url"))) ? (String)protocol.getProperties().get("quota.notification.url") : new DefaultProviderHelpService().help(protocol));
    }

    public void activityMenuClicked(ID sender) {
        ActivityController c = ActivityControllerFactory.get();
        NSWindow window = c.window();
        if (c.isVisible()) {
            window.orderOut(sender);
        } else {
            new ModalPanelAlertRunner().run(window);
        }
    }

    public void preferencesMenuClicked(ID sender) {
        PreferencesController c = StatusBarPreferencesController.Factory.instance((AbstractMenuDelegate)this);
        new ModalPanelAlertRunner().run(c.window());
    }

    public void resumeSyncClicked(ID sender) {
        this.preferences.setProperty("fs.sync.queue.paused", false);
        Set mounts = this.registry.values();
        for (Filesystem fs : mounts) {
            SyncQueue queue = fs.getQueue();
            queue.resume();
            DirectoryIndexer indexer = fs.getIndexer();
            indexer.resume();
        }
        this.setNeedsUpdate(true);
    }

    public void pauseSyncClicked(ID sender) {
        Set mounts = this.registry.values();
        for (Filesystem fs : mounts) {
            SyncQueue queue = fs.getQueue();
            queue.pause(SyncQueue.Status.paused);
            DirectoryIndexer indexer = fs.getIndexer();
            indexer.pause(DirectoryIndexer.Status.paused);
        }
        this.preferences.setProperty("fs.sync.queue.paused", true);
        this.setNeedsUpdate(true);
    }

    public void filter(NSMenu menu, HostFilter filter) {
        this.filter = filter;
        this.bookmarkMenuNeedsUpdate(menu);
    }

    private static final class MenuUpdateCollectionListener
    implements CollectionListener<Host> {
        final AbstractMenuDelegate menu;

        public MenuUpdateCollectionListener(AbstractMenuDelegate menu) {
            this.menu = menu;
        }

        public void collectionLoaded() {
            this.menu.setNeedsUpdate(true);
        }

        public void collectionItemAdded(Host host) {
            this.menu.setNeedsUpdate(true);
        }

        public void collectionItemRemoved(Host host) {
            this.menu.setNeedsUpdate(true);
        }

        public void collectionItemChanged(Host host) {
            this.menu.setNeedsUpdate(true);
        }
    }

    private static class MenuItemBuilder {
        public final String title;
        public final ID target;
        public final Selector selector;
        public boolean enabled = true;
        public NSMenu submenu;
        public NSImage image;
        static final MenuItemBuilder SEPERATOR = new MenuItemBuilder(null){

            @Override
            public NSMenuItem build() {
                return NSMenuItem.separatorItem();
            }
        };

        public MenuItemBuilder(String title) {
            this(title, null, null);
        }

        public MenuItemBuilder(String title, Selector selector, ID target) {
            this.title = title;
            this.selector = selector;
            this.target = target;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public MenuItemBuilder withSubmenu(NSMenu submenu) {
            this.submenu = submenu;
            return this;
        }

        public MenuItemBuilder withImage(NSImage image) {
            this.image = image;
            return this;
        }

        public NSMenuItem build() {
            NSMenuItem item = NSMenuItem.itemWithTitle((String)this.title, (Selector)this.selector, (String)"");
            item.setEnabled(this.enabled);
            item.setTarget(this.target);
            item.setImage(this.image);
            if (this.submenu != null) {
                this.submenu.setSupermenu(null);
            }
            item.setSubmenu(this.submenu);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Add menu item %s", item));
            }
            return item;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Menu{");
            sb.append("title='").append(this.title).append('\'');
            sb.append(", target=").append(this.target);
            sb.append(", selector=").append(this.selector);
            sb.append(", enabled=").append(this.enabled);
            sb.append(", submenu=").append(this.submenu);
            sb.append(", image=").append(this.image);
            sb.append('}');
            return sb.toString();
        }
    }

    private static final class MenuUpdateRegistryListener
    implements FilesystemMountRegistry.Listener {
        final AbstractMenuDelegate menu;

        public MenuUpdateRegistryListener(AbstractMenuDelegate menu) {
            this.menu = menu;
        }

        public void mounted(Filesystem fs) {
            this.menu.setNeedsUpdate(true);
        }

        public void unmounted(Filesystem fs) {
            this.menu.setNeedsUpdate(true);
        }
    }

    private static enum InterfaceRefresh {
        status,
        progress;

    }

    public static abstract class ExtendedNSColor
    extends NSObject
    implements NSCopying {
        private static final _Class CLASS = (_Class)Rococoa.createClass((String)"NSColor", _Class.class);

        public static NSColor secondaryLabelColor() {
            return CLASS.secondaryLabelColor();
        }

        public static interface _Class
        extends ObjCClass {
            public NSColor secondaryLabelColor();
        }
    }
}

