/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application.menu;

import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.core.AbstractCollectionListener;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public class SortMenuDelegate
extends AbstractMenuDelegate {
    private static final String SORT_NICKNAME_PROPERTY = "nickname";
    private static final String SORT_HOSTNAME_PROPERTY = "hostname";
    private static final String SORT_PROTOCOL_PROPERTY = "protocol";
    private final Preferences preferences = PreferencesFactory.get();
    private final CollectionMenuDelegate parent;
    private final AbstractHostCollection bookmarks;

    public SortMenuDelegate(CollectionMenuDelegate parent, AbstractHostCollection bookmarks) {
        this.parent = parent;
        this.bookmarks = bookmarks;
        this.bookmarks.addListener((CollectionListener)new AbstractCollectionListener<Host>(){

            public void collectionItemChanged(Host item) {
                SortMenuDelegate.this.sort();
            }
        });
        this.sort();
    }

    public Selector getDefaultAction() {
        return Foundation.selector((String)"menuItemClicked:");
    }

    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger row, boolean cancel) {
        if (row.intValue() == 0) {
            item.setEnabled(true);
            item.setTitle(LocaleFactory.localizedString((String)"Nickname", (String)"Main"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector((String)"sortBookmarksByNickame:"));
            item.setState(SORT_NICKNAME_PROPERTY.equals(this.preferences.getProperty("bookmark.sort")) ? 1 : 0);
        }
        if (row.intValue() == 1) {
            item.setEnabled(true);
            item.setTitle(LocaleFactory.localizedString((String)"Hostname", (String)"Main"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector((String)"sortBookmarksByHostname:"));
            item.setState(SORT_HOSTNAME_PROPERTY.equals(this.preferences.getProperty("bookmark.sort")) ? 1 : 0);
        }
        if (row.intValue() == 2) {
            item.setEnabled(true);
            item.setTitle(LocaleFactory.localizedString((String)"Protocol", (String)"Main"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector((String)"sortBookmarksByProtocol:"));
            item.setState(SORT_PROTOCOL_PROPERTY.equals(this.preferences.getProperty("bookmark.sort")) ? 1 : 0);
        }
        return super.menuUpdateItemAtIndex(menu, item, row, cancel);
    }

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        return new NSInteger(3L);
    }

    public void sortBookmarksByNickame(ID sender) {
        this.preferences.setProperty("bookmark.sort", SORT_NICKNAME_PROPERTY);
        this.sort();
    }

    public void sortBookmarksByHostname(ID sender) {
        this.preferences.setProperty("bookmark.sort", SORT_HOSTNAME_PROPERTY);
        this.sort();
    }

    public void sortBookmarksByProtocol(ID sender) {
        this.preferences.setProperty("bookmark.sort", SORT_PROTOCOL_PROPERTY);
        this.sort();
    }

    public void sort() {
        switch (this.preferences.getProperty("bookmark.sort")) {
            case "nickname": {
                this.bookmarks.sort(BookmarkCollection.SORT_BY_NICKNAME);
                break;
            }
            case "hostname": {
                this.bookmarks.sort(BookmarkCollection.SORT_BY_HOSTNAME);
                break;
            }
            case "protocol": {
                this.bookmarks.sort(BookmarkCollection.SORT_BY_PROTOCOL);
            }
        }
        this.parent.collectionLoaded();
    }
}

