/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application.menu;

import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.local.RevealServiceFactory;
import ch.cyberduck.ui.cocoa.delegate.MenuCallback;
import ch.iterate.mountainduck.application.StatusBarController;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;

public class ConnectMenuCallback
implements MenuCallback {
    private final FilesystemMountRegistry registry = FilesystemMountRegistry.get();
    private final AbstractHostCollection bookmarks;
    private final StatusBarController controller;

    public ConnectMenuCallback(StatusBarController controller, AbstractHostCollection bookmarks) {
        this.controller = controller;
        this.bookmarks = bookmarks;
    }

    public void selected(NSMenuItem sender) {
        Host bookmark = this.bookmarks.lookup(sender.representedObject());
        Filesystem fs = this.registry.get(bookmark);
        if (null == fs) {
            this.controller.connect(bookmark);
        } else {
            switch (fs.getMountStatus()) {
                case busy: 
                case idle: {
                    Local mountpoint = fs.getMountpoint();
                    if (null == mountpoint) break;
                    RevealServiceFactory.get().reveal(mountpoint);
                }
            }
        }
    }
}

