/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application.menu;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AlertCallbackFactory;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.TerminalService;
import ch.cyberduck.core.TerminalServiceFactory;
import ch.cyberduck.core.WebUrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.sparkle.Sandbox;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import ch.iterate.mountainduck.application.StatusBarBookmarkController;
import ch.iterate.mountainduck.application.StatusBarController;
import ch.iterate.mountainduck.application.menu.RevealMenuCallback;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;

public class BookmarkMenuHandler
extends ProxyController
implements NSMenu.Validation {
    private static final Logger log = LogManager.getLogger((String)BookmarkMenuHandler.class.getName());
    private final StatusBarController controller;
    private final AbstractHostCollection bookmarks;
    private final Preferences preferences = PreferencesFactory.get();
    private final FilesystemMountRegistry registry = FilesystemMountRegistry.get();

    public BookmarkMenuHandler(StatusBarController controller, AbstractHostCollection bookmarks) {
        this.controller = controller;
        this.bookmarks = bookmarks;
    }

    public boolean validateMenuItem(NSMenuItem sender) {
        Host bookmark;
        if (sender.action().equals((Object)Foundation.selector((String)"connectMenuClicked:"))) {
            Host bookmark2 = this.bookmarks.lookup(sender.representedObject());
            return null == this.registry.get(bookmark2);
        }
        if (sender.action().equals((Object)Foundation.selector((String)"disconnectMenuClicked:"))) {
            Host bookmark3 = this.bookmarks.lookup(sender.representedObject());
            Filesystem fs = this.registry.get(bookmark3);
            if (null != fs) {
                return fs.getMountStatus() != Filesystem.State.closed;
            }
            return false;
        }
        if (sender.action().equals((Object)Foundation.selector((String)"revealMenuClicked:"))) {
            Host bookmark4 = this.bookmarks.lookup(sender.representedObject());
            return null != this.registry.get(bookmark4);
        }
        if (sender.action().equals((Object)Foundation.selector((String)"weburlMenuClicked:"))) {
            Host bookmark5 = this.bookmarks.lookup(sender.representedObject());
            return null != bookmark5.getProtocol().getFeature(WebUrlProvider.class);
        }
        if (sender.action().equals((Object)Foundation.selector((String)"terminalMenuClicked:"))) {
            Host bookmark6 = this.bookmarks.lookup(sender.representedObject());
            return bookmark6.getProtocol().getType() == Protocol.Type.sftp;
        }
        if (sender.action().equals((Object)Foundation.selector((String)"editMenuClicked:"))) {
            return this.bookmarks.allowsEdit();
        }
        if (sender.action().equals((Object)Foundation.selector((String)"removeMenuClicked:"))) {
            Filesystem fs;
            Host bookmark7 = this.bookmarks.lookup(sender.representedObject());
            if (!this.preferences.getBoolean("menu.bookmark.connected.delete.enable") && null != (fs = this.registry.get(bookmark7))) {
                return false;
            }
            return this.bookmarks.allowsDelete();
        }
        if (sender.action().equals((Object)Foundation.selector((String)"menuItemClicked:")) && null == (bookmark = this.bookmarks.lookup(sender.representedObject()))) {
            log.warn(String.format("Failure finding bookmark with UUID %s in collection %s", sender.representedObject(), this.bookmarks));
            return false;
        }
        return true;
    }

    public void revealMenuClicked(NSMenuItem sender) {
        new RevealMenuCallback(this.bookmarks).selected(sender);
    }

    public void weburlMenuClicked(NSMenuItem sender) {
        final Host bookmark = this.bookmarks.lookup(sender.representedObject());
        this.controller.background((BackgroundAction)new AbstractBackgroundAction<Void>(){

            public Void run() {
                WebUrlProvider provider = (WebUrlProvider)bookmark.getProtocol().getFeature(WebUrlProvider.class);
                BrowserLauncherFactory.get().open(provider.toUrl(bookmark).getUrl());
                return null;
            }
        });
    }

    public void terminalMenuClicked(NSMenuItem sender) {
        Host bookmark = this.bookmarks.lookup(sender.representedObject());
        Filesystem fs = this.registry.get(bookmark);
        try {
            Path workdir = null == fs ? (StringUtils.isEmpty((CharSequence)bookmark.getDefaultPath()) ? new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.directory)) : new Path(bookmark.getDefaultPath(), EnumSet.of(AbstractPath.Type.directory))) : ((Home)fs.getFeature(Home.class)).find();
            TerminalService terminal = TerminalServiceFactory.get();
            terminal.open(bookmark, workdir);
        }
        catch (BackgroundException e) {
            AlertCallbackFactory.get((Controller)this.controller).alert(bookmark, e, new StringBuilder());
        }
    }

    public void connectMenuClicked(NSMenuItem sender) {
        Host bookmark = this.bookmarks.lookup(sender.representedObject());
        this.controller.connect(bookmark);
    }

    public void disconnectMenuClicked(NSMenuItem sender) {
        Host bookmark = this.bookmarks.lookup(sender.representedObject());
        this.controller.disconnect(bookmark);
    }

    public void editMenuClicked(NSMenuItem sender) {
        Host bookmark = this.bookmarks.lookup(sender.representedObject());
        BookmarkController c = StatusBarBookmarkController.Factory.create(this.controller, this.bookmarks, bookmark);
        new ModalPanelAlertRunner().run(c.window());
    }

    public void removeMenuClicked(NSMenuItem sender) {
        Host bookmark = this.bookmarks.lookup(sender.representedObject());
        this.controller.delete((Collection<Host>)this.bookmarks, bookmark);
    }

    public NSMenu build(Host bookmark, NSMenuItem item) {
        NSMenu submenu = NSMenu.menu();
        NSMenuItem connect = submenu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Connect", (String)"Connection"), Foundation.selector((String)"connectMenuClicked:"), "");
        connect.setRepresentedObject(bookmark.getUuid());
        connect.setTarget(this.id());
        NSMenuItem disconnect = submenu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Disconnect", (String)"Main"), Foundation.selector((String)"disconnectMenuClicked:"), "");
        disconnect.setRepresentedObject(bookmark.getUuid());
        disconnect.setTarget(this.id());
        NSMenuItem reveal = submenu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Show in Finder", (String)"Localizable"), Foundation.selector((String)"revealMenuClicked:"), "");
        reveal.setRepresentedObject(bookmark.getUuid());
        reveal.setTarget(this.id());
        if (this.preferences.getBoolean("menu.bookmark.weburl.enable")) {
            NSMenuItem weburl = submenu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Open in Web Browser", (String)"Localizable"), Foundation.selector((String)"weburlMenuClicked:"), "");
            weburl.setRepresentedObject(bookmark.getUuid());
            weburl.setTarget(this.id());
        }
        if (bookmark.getProtocol().getType() == Protocol.Type.sftp && !Sandbox.get().isSandboxed()) {
            NSMenuItem terminal = submenu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Open in Terminal", (String)"Main"), Foundation.selector((String)"terminalMenuClicked:"), "");
            terminal.setRepresentedObject(bookmark.getUuid());
            terminal.setTarget(this.id());
        }
        if (this.bookmarks.allowsEdit() && this.preferences.getBoolean("menu.bookmark.edit.enable")) {
            NSMenuItem edit = submenu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Edit Bookmark", (String)"Main"), Foundation.selector((String)"editMenuClicked:"), "");
            edit.setRepresentedObject(bookmark.getUuid());
            edit.setTarget(this.id());
            submenu.addItem(NSMenuItem.separatorItem());
        }
        if (this.bookmarks.allowsDelete()) {
            NSMenuItem delete = submenu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Delete Bookmark", (String)"Main"), Foundation.selector((String)"removeMenuClicked:"), "");
            delete.setRepresentedObject(bookmark.getUuid());
            delete.setTarget(this.id());
        }
        item.setOffStateImage(null);
        item.setOnStateImage((NSImage)IconCacheFactory.get().iconNamed("NSStatusAvailable", Integer.valueOf(12)));
        item.setMixedStateImage((NSImage)IconCacheFactory.get().iconNamed("NSStatusPartiallyAvailable", Integer.valueOf(12)));
        item.setState(0);
        this.setState(bookmark, item);
        return submenu;
    }

    protected void setState(Host bookmark, NSMenuItem item) {
        Filesystem fs = this.registry.get(bookmark);
        if (null != fs) {
            switch (fs.getMountStatus()) {
                case busy: {
                    item.setState(-1);
                    break;
                }
                case idle: {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Set idle state for %s", bookmark));
                    }
                    item.setState(1);
                }
            }
        }
    }
}

